/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>RelativeDatesFilter</code> filters relative dates values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelativeDatesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<RelativeDatesFilter.Builder, RelativeDatesFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(RelativeDatesFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(RelativeDatesFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<AnchorDateConfiguration> ANCHOR_DATE_CONFIGURATION_FIELD = SdkField
            .<AnchorDateConfiguration> builder(MarshallingType.SDK_POJO).memberName("AnchorDateConfiguration")
            .getter(getter(RelativeDatesFilter::anchorDateConfiguration)).setter(setter(Builder::anchorDateConfiguration))
            .constructor(AnchorDateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnchorDateConfiguration").build())
            .build();

    private static final SdkField<String> MINIMUM_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumGranularity").getter(getter(RelativeDatesFilter::minimumGranularityAsString))
            .setter(setter(Builder::minimumGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumGranularity").build())
            .build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(RelativeDatesFilter::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<String> RELATIVE_DATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelativeDateType").getter(getter(RelativeDatesFilter::relativeDateTypeAsString))
            .setter(setter(Builder::relativeDateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateType").build()).build();

    private static final SdkField<Integer> RELATIVE_DATE_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RelativeDateValue").getter(getter(RelativeDatesFilter::relativeDateValue))
            .setter(setter(Builder::relativeDateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateValue").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(RelativeDatesFilter::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOption").getter(getter(RelativeDatesFilter::nullOptionAsString)).setter(setter(Builder::nullOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()).build();

    private static final SdkField<ExcludePeriodConfiguration> EXCLUDE_PERIOD_CONFIGURATION_FIELD = SdkField
            .<ExcludePeriodConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExcludePeriodConfiguration")
            .getter(getter(RelativeDatesFilter::excludePeriodConfiguration))
            .setter(setter(Builder::excludePeriodConfiguration))
            .constructor(ExcludePeriodConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePeriodConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            ANCHOR_DATE_CONFIGURATION_FIELD, MINIMUM_GRANULARITY_FIELD, TIME_GRANULARITY_FIELD, RELATIVE_DATE_TYPE_FIELD,
            RELATIVE_DATE_VALUE_FIELD, PARAMETER_NAME_FIELD, NULL_OPTION_FIELD, EXCLUDE_PERIOD_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final AnchorDateConfiguration anchorDateConfiguration;

    private final String minimumGranularity;

    private final String timeGranularity;

    private final String relativeDateType;

    private final Integer relativeDateValue;

    private final String parameterName;

    private final String nullOption;

    private final ExcludePeriodConfiguration excludePeriodConfiguration;

    private RelativeDatesFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.anchorDateConfiguration = builder.anchorDateConfiguration;
        this.minimumGranularity = builder.minimumGranularity;
        this.timeGranularity = builder.timeGranularity;
        this.relativeDateType = builder.relativeDateType;
        this.relativeDateValue = builder.relativeDateValue;
        this.parameterName = builder.parameterName;
        this.nullOption = builder.nullOption;
        this.excludePeriodConfiguration = builder.excludePeriodConfiguration;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The date configuration of the filter.
     * </p>
     * 
     * @return The date configuration of the filter.
     */
    public final AnchorDateConfiguration anchorDateConfiguration() {
        return anchorDateConfiguration;
    }

    /**
     * <p>
     * The minimum granularity (period granularity) of the relative dates filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #minimumGranularity} will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #minimumGranularityAsString}.
     * </p>
     * 
     * @return The minimum granularity (period granularity) of the relative dates filter.
     * @see TimeGranularity
     */
    public final TimeGranularity minimumGranularity() {
        return TimeGranularity.fromValue(minimumGranularity);
    }

    /**
     * <p>
     * The minimum granularity (period granularity) of the relative dates filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #minimumGranularity} will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #minimumGranularityAsString}.
     * </p>
     * 
     * @return The minimum granularity (period granularity) of the relative dates filter.
     * @see TimeGranularity
     */
    public final String minimumGranularityAsString() {
        return minimumGranularity;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The range date type of the filter. Choose one of the options below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PREVIOUS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOW</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEXT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relativeDateType}
     * will return {@link RelativeDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relativeDateTypeAsString}.
     * </p>
     * 
     * @return The range date type of the filter. Choose one of the options below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PREVIOUS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOW</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEXT</code>
     *         </p>
     *         </li>
     * @see RelativeDateType
     */
    public final RelativeDateType relativeDateType() {
        return RelativeDateType.fromValue(relativeDateType);
    }

    /**
     * <p>
     * The range date type of the filter. Choose one of the options below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PREVIOUS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOW</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEXT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relativeDateType}
     * will return {@link RelativeDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relativeDateTypeAsString}.
     * </p>
     * 
     * @return The range date type of the filter. Choose one of the options below:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PREVIOUS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOW</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEXT</code>
     *         </p>
     *         </li>
     * @see RelativeDateType
     */
    public final String relativeDateTypeAsString() {
        return relativeDateType;
    }

    /**
     * <p>
     * The date value of the filter.
     * </p>
     * 
     * @return The date value of the filter.
     */
    public final Integer relativeDateValue() {
        return relativeDateValue;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * 
     * @return The parameter whose value should be used for the filter value.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(nullOption);
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final String nullOptionAsString() {
        return nullOption;
    }

    /**
     * <p>
     * The configuration for the exclude period of the filter.
     * </p>
     * 
     * @return The configuration for the exclude period of the filter.
     */
    public final ExcludePeriodConfiguration excludePeriodConfiguration() {
        return excludePeriodConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(anchorDateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(minimumGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relativeDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relativeDateValue());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(excludePeriodConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelativeDatesFilter)) {
            return false;
        }
        RelativeDatesFilter other = (RelativeDatesFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(anchorDateConfiguration(), other.anchorDateConfiguration())
                && Objects.equals(minimumGranularityAsString(), other.minimumGranularityAsString())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(relativeDateTypeAsString(), other.relativeDateTypeAsString())
                && Objects.equals(relativeDateValue(), other.relativeDateValue())
                && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(nullOptionAsString(), other.nullOptionAsString())
                && Objects.equals(excludePeriodConfiguration(), other.excludePeriodConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelativeDatesFilter").add("FilterId", filterId()).add("Column", column())
                .add("AnchorDateConfiguration", anchorDateConfiguration())
                .add("MinimumGranularity", minimumGranularityAsString()).add("TimeGranularity", timeGranularityAsString())
                .add("RelativeDateType", relativeDateTypeAsString()).add("RelativeDateValue", relativeDateValue())
                .add("ParameterName", parameterName()).add("NullOption", nullOptionAsString())
                .add("ExcludePeriodConfiguration", excludePeriodConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "AnchorDateConfiguration":
            return Optional.ofNullable(clazz.cast(anchorDateConfiguration()));
        case "MinimumGranularity":
            return Optional.ofNullable(clazz.cast(minimumGranularityAsString()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "RelativeDateType":
            return Optional.ofNullable(clazz.cast(relativeDateTypeAsString()));
        case "RelativeDateValue":
            return Optional.ofNullable(clazz.cast(relativeDateValue()));
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "NullOption":
            return Optional.ofNullable(clazz.cast(nullOptionAsString()));
        case "ExcludePeriodConfiguration":
            return Optional.ofNullable(clazz.cast(excludePeriodConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelativeDatesFilter, T> g) {
        return obj -> g.apply((RelativeDatesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelativeDatesFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The date configuration of the filter.
         * </p>
         * 
         * @param anchorDateConfiguration
         *        The date configuration of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anchorDateConfiguration(AnchorDateConfiguration anchorDateConfiguration);

        /**
         * <p>
         * The date configuration of the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnchorDateConfiguration.Builder} avoiding
         * the need to create one manually via {@link AnchorDateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnchorDateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #anchorDateConfiguration(AnchorDateConfiguration)}.
         * 
         * @param anchorDateConfiguration
         *        a consumer that will call methods on {@link AnchorDateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anchorDateConfiguration(AnchorDateConfiguration)
         */
        default Builder anchorDateConfiguration(Consumer<AnchorDateConfiguration.Builder> anchorDateConfiguration) {
            return anchorDateConfiguration(AnchorDateConfiguration.builder().applyMutation(anchorDateConfiguration).build());
        }

        /**
         * <p>
         * The minimum granularity (period granularity) of the relative dates filter.
         * </p>
         * 
         * @param minimumGranularity
         *        The minimum granularity (period granularity) of the relative dates filter.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder minimumGranularity(String minimumGranularity);

        /**
         * <p>
         * The minimum granularity (period granularity) of the relative dates filter.
         * </p>
         * 
         * @param minimumGranularity
         *        The minimum granularity (period granularity) of the relative dates filter.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder minimumGranularity(TimeGranularity minimumGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);

        /**
         * <p>
         * The range date type of the filter. Choose one of the options below:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PREVIOUS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOW</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEXT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param relativeDateType
         *        The range date type of the filter. Choose one of the options below:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PREVIOUS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOW</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEXT</code>
         *        </p>
         *        </li>
         * @see RelativeDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativeDateType
         */
        Builder relativeDateType(String relativeDateType);

        /**
         * <p>
         * The range date type of the filter. Choose one of the options below:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PREVIOUS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOW</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEXT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param relativeDateType
         *        The range date type of the filter. Choose one of the options below:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PREVIOUS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOW</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEXT</code>
         *        </p>
         *        </li>
         * @see RelativeDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativeDateType
         */
        Builder relativeDateType(RelativeDateType relativeDateType);

        /**
         * <p>
         * The date value of the filter.
         * </p>
         * 
         * @param relativeDateValue
         *        The date value of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeDateValue(Integer relativeDateValue);

        /**
         * <p>
         * The parameter whose value should be used for the filter value.
         * </p>
         * 
         * @param parameterName
         *        The parameter whose value should be used for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(String nullOption);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(FilterNullOption nullOption);

        /**
         * <p>
         * The configuration for the exclude period of the filter.
         * </p>
         * 
         * @param excludePeriodConfiguration
         *        The configuration for the exclude period of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePeriodConfiguration(ExcludePeriodConfiguration excludePeriodConfiguration);

        /**
         * <p>
         * The configuration for the exclude period of the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExcludePeriodConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExcludePeriodConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExcludePeriodConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #excludePeriodConfiguration(ExcludePeriodConfiguration)}.
         * 
         * @param excludePeriodConfiguration
         *        a consumer that will call methods on {@link ExcludePeriodConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludePeriodConfiguration(ExcludePeriodConfiguration)
         */
        default Builder excludePeriodConfiguration(Consumer<ExcludePeriodConfiguration.Builder> excludePeriodConfiguration) {
            return excludePeriodConfiguration(ExcludePeriodConfiguration.builder().applyMutation(excludePeriodConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private AnchorDateConfiguration anchorDateConfiguration;

        private String minimumGranularity;

        private String timeGranularity;

        private String relativeDateType;

        private Integer relativeDateValue;

        private String parameterName;

        private String nullOption;

        private ExcludePeriodConfiguration excludePeriodConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RelativeDatesFilter model) {
            filterId(model.filterId);
            column(model.column);
            anchorDateConfiguration(model.anchorDateConfiguration);
            minimumGranularity(model.minimumGranularity);
            timeGranularity(model.timeGranularity);
            relativeDateType(model.relativeDateType);
            relativeDateValue(model.relativeDateValue);
            parameterName(model.parameterName);
            nullOption(model.nullOption);
            excludePeriodConfiguration(model.excludePeriodConfiguration);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final AnchorDateConfiguration.Builder getAnchorDateConfiguration() {
            return anchorDateConfiguration != null ? anchorDateConfiguration.toBuilder() : null;
        }

        public final void setAnchorDateConfiguration(AnchorDateConfiguration.BuilderImpl anchorDateConfiguration) {
            this.anchorDateConfiguration = anchorDateConfiguration != null ? anchorDateConfiguration.build() : null;
        }

        @Override
        public final Builder anchorDateConfiguration(AnchorDateConfiguration anchorDateConfiguration) {
            this.anchorDateConfiguration = anchorDateConfiguration;
            return this;
        }

        public final String getMinimumGranularity() {
            return minimumGranularity;
        }

        public final void setMinimumGranularity(String minimumGranularity) {
            this.minimumGranularity = minimumGranularity;
        }

        @Override
        public final Builder minimumGranularity(String minimumGranularity) {
            this.minimumGranularity = minimumGranularity;
            return this;
        }

        @Override
        public final Builder minimumGranularity(TimeGranularity minimumGranularity) {
            this.minimumGranularity(minimumGranularity == null ? null : minimumGranularity.toString());
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final String getRelativeDateType() {
            return relativeDateType;
        }

        public final void setRelativeDateType(String relativeDateType) {
            this.relativeDateType = relativeDateType;
        }

        @Override
        public final Builder relativeDateType(String relativeDateType) {
            this.relativeDateType = relativeDateType;
            return this;
        }

        @Override
        public final Builder relativeDateType(RelativeDateType relativeDateType) {
            this.relativeDateType(relativeDateType == null ? null : relativeDateType.toString());
            return this;
        }

        public final Integer getRelativeDateValue() {
            return relativeDateValue;
        }

        public final void setRelativeDateValue(Integer relativeDateValue) {
            this.relativeDateValue = relativeDateValue;
        }

        @Override
        public final Builder relativeDateValue(Integer relativeDateValue) {
            this.relativeDateValue = relativeDateValue;
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNullOption() {
            return nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final ExcludePeriodConfiguration.Builder getExcludePeriodConfiguration() {
            return excludePeriodConfiguration != null ? excludePeriodConfiguration.toBuilder() : null;
        }

        public final void setExcludePeriodConfiguration(ExcludePeriodConfiguration.BuilderImpl excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration != null ? excludePeriodConfiguration.build() : null;
        }

        @Override
        public final Builder excludePeriodConfiguration(ExcludePeriodConfiguration excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration;
            return this;
        }

        @Override
        public RelativeDatesFilter build() {
            return new RelativeDatesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
