/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value label configuration of the label in a reference line.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLineValueLabelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceLineValueLabelConfiguration.Builder, ReferenceLineValueLabelConfiguration> {
    private static final SdkField<String> RELATIVE_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelativePosition").getter(getter(ReferenceLineValueLabelConfiguration::relativePositionAsString))
            .setter(setter(Builder::relativePosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePosition").build()).build();

    private static final SdkField<NumericFormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumericFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("FormatConfiguration")
            .getter(getter(ReferenceLineValueLabelConfiguration::formatConfiguration))
            .setter(setter(Builder::formatConfiguration)).constructor(NumericFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIVE_POSITION_FIELD,
            FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String relativePosition;

    private final NumericFormatConfiguration formatConfiguration;

    private ReferenceLineValueLabelConfiguration(BuilderImpl builder) {
        this.relativePosition = builder.relativePosition;
        this.formatConfiguration = builder.formatConfiguration;
    }

    /**
     * <p>
     * The relative position of the value label. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BEFORE_CUSTOM_LABEL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_CUSTOM_LABEL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relativePosition}
     * will return {@link ReferenceLineValueLabelRelativePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #relativePositionAsString}.
     * </p>
     * 
     * @return The relative position of the value label. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BEFORE_CUSTOM_LABEL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_CUSTOM_LABEL</code>
     *         </p>
     *         </li>
     * @see ReferenceLineValueLabelRelativePosition
     */
    public final ReferenceLineValueLabelRelativePosition relativePosition() {
        return ReferenceLineValueLabelRelativePosition.fromValue(relativePosition);
    }

    /**
     * <p>
     * The relative position of the value label. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BEFORE_CUSTOM_LABEL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_CUSTOM_LABEL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relativePosition}
     * will return {@link ReferenceLineValueLabelRelativePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #relativePositionAsString}.
     * </p>
     * 
     * @return The relative position of the value label. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BEFORE_CUSTOM_LABEL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_CUSTOM_LABEL</code>
     *         </p>
     *         </li>
     * @see ReferenceLineValueLabelRelativePosition
     */
    public final String relativePositionAsString() {
        return relativePosition;
    }

    /**
     * <p>
     * The format configuration of the value label.
     * </p>
     * 
     * @return The format configuration of the value label.
     */
    public final NumericFormatConfiguration formatConfiguration() {
        return formatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relativePositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineValueLabelConfiguration)) {
            return false;
        }
        ReferenceLineValueLabelConfiguration other = (ReferenceLineValueLabelConfiguration) obj;
        return Objects.equals(relativePositionAsString(), other.relativePositionAsString())
                && Objects.equals(formatConfiguration(), other.formatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLineValueLabelConfiguration").add("RelativePosition", relativePositionAsString())
                .add("FormatConfiguration", formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RelativePosition":
            return Optional.ofNullable(clazz.cast(relativePositionAsString()));
        case "FormatConfiguration":
            return Optional.ofNullable(clazz.cast(formatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineValueLabelConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineValueLabelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLineValueLabelConfiguration> {
        /**
         * <p>
         * The relative position of the value label. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BEFORE_CUSTOM_LABEL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_CUSTOM_LABEL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param relativePosition
         *        The relative position of the value label. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BEFORE_CUSTOM_LABEL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_CUSTOM_LABEL</code>
         *        </p>
         *        </li>
         * @see ReferenceLineValueLabelRelativePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceLineValueLabelRelativePosition
         */
        Builder relativePosition(String relativePosition);

        /**
         * <p>
         * The relative position of the value label. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BEFORE_CUSTOM_LABEL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_CUSTOM_LABEL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param relativePosition
         *        The relative position of the value label. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BEFORE_CUSTOM_LABEL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_CUSTOM_LABEL</code>
         *        </p>
         *        </li>
         * @see ReferenceLineValueLabelRelativePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceLineValueLabelRelativePosition
         */
        Builder relativePosition(ReferenceLineValueLabelRelativePosition relativePosition);

        /**
         * <p>
         * The format configuration of the value label.
         * </p>
         * 
         * @param formatConfiguration
         *        The format configuration of the value label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfiguration(NumericFormatConfiguration formatConfiguration);

        /**
         * <p>
         * The format configuration of the value label.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumericFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #formatConfiguration(NumericFormatConfiguration)}.
         * 
         * @param formatConfiguration
         *        a consumer that will call methods on {@link NumericFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatConfiguration(NumericFormatConfiguration)
         */
        default Builder formatConfiguration(Consumer<NumericFormatConfiguration.Builder> formatConfiguration) {
            return formatConfiguration(NumericFormatConfiguration.builder().applyMutation(formatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String relativePosition;

        private NumericFormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineValueLabelConfiguration model) {
            relativePosition(model.relativePosition);
            formatConfiguration(model.formatConfiguration);
        }

        public final String getRelativePosition() {
            return relativePosition;
        }

        public final void setRelativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
        }

        @Override
        public final Builder relativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
            return this;
        }

        @Override
        public final Builder relativePosition(ReferenceLineValueLabelRelativePosition relativePosition) {
            this.relativePosition(relativePosition == null ? null : relativePosition.toString());
            return this;
        }

        public final NumericFormatConfiguration.Builder getFormatConfiguration() {
            return formatConfiguration != null ? formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(NumericFormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(NumericFormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        @Override
        public ReferenceLineValueLabelConfiguration build() {
            return new ReferenceLineValueLabelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
