/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the numeric format configuration.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericFormatConfiguration.Builder, NumericFormatConfiguration> {
    private static final SdkField<NumberDisplayFormatConfiguration> NUMBER_DISPLAY_FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumberDisplayFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NumberDisplayFormatConfiguration")
            .getter(getter(NumericFormatConfiguration::numberDisplayFormatConfiguration))
            .setter(setter(Builder::numberDisplayFormatConfiguration))
            .constructor(NumberDisplayFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberDisplayFormatConfiguration")
                    .build()).build();

    private static final SdkField<CurrencyDisplayFormatConfiguration> CURRENCY_DISPLAY_FORMAT_CONFIGURATION_FIELD = SdkField
            .<CurrencyDisplayFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CurrencyDisplayFormatConfiguration")
            .getter(getter(NumericFormatConfiguration::currencyDisplayFormatConfiguration))
            .setter(setter(Builder::currencyDisplayFormatConfiguration))
            .constructor(CurrencyDisplayFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyDisplayFormatConfiguration")
                    .build()).build();

    private static final SdkField<PercentageDisplayFormatConfiguration> PERCENTAGE_DISPLAY_FORMAT_CONFIGURATION_FIELD = SdkField
            .<PercentageDisplayFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PercentageDisplayFormatConfiguration")
            .getter(getter(NumericFormatConfiguration::percentageDisplayFormatConfiguration))
            .setter(setter(Builder::percentageDisplayFormatConfiguration))
            .constructor(PercentageDisplayFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PercentageDisplayFormatConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_DISPLAY_FORMAT_CONFIGURATION_FIELD, CURRENCY_DISPLAY_FORMAT_CONFIGURATION_FIELD,
            PERCENTAGE_DISPLAY_FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final NumberDisplayFormatConfiguration numberDisplayFormatConfiguration;

    private final CurrencyDisplayFormatConfiguration currencyDisplayFormatConfiguration;

    private final PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration;

    private NumericFormatConfiguration(BuilderImpl builder) {
        this.numberDisplayFormatConfiguration = builder.numberDisplayFormatConfiguration;
        this.currencyDisplayFormatConfiguration = builder.currencyDisplayFormatConfiguration;
        this.percentageDisplayFormatConfiguration = builder.percentageDisplayFormatConfiguration;
    }

    /**
     * <p>
     * The options that determine the number display format configuration.
     * </p>
     * 
     * @return The options that determine the number display format configuration.
     */
    public final NumberDisplayFormatConfiguration numberDisplayFormatConfiguration() {
        return numberDisplayFormatConfiguration;
    }

    /**
     * <p>
     * The options that determine the currency display format configuration.
     * </p>
     * 
     * @return The options that determine the currency display format configuration.
     */
    public final CurrencyDisplayFormatConfiguration currencyDisplayFormatConfiguration() {
        return currencyDisplayFormatConfiguration;
    }

    /**
     * <p>
     * The options that determine the percentage display format configuration.
     * </p>
     * 
     * @return The options that determine the percentage display format configuration.
     */
    public final PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration() {
        return percentageDisplayFormatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberDisplayFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(currencyDisplayFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(percentageDisplayFormatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericFormatConfiguration)) {
            return false;
        }
        NumericFormatConfiguration other = (NumericFormatConfiguration) obj;
        return Objects.equals(numberDisplayFormatConfiguration(), other.numberDisplayFormatConfiguration())
                && Objects.equals(currencyDisplayFormatConfiguration(), other.currencyDisplayFormatConfiguration())
                && Objects.equals(percentageDisplayFormatConfiguration(), other.percentageDisplayFormatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericFormatConfiguration")
                .add("NumberDisplayFormatConfiguration", numberDisplayFormatConfiguration())
                .add("CurrencyDisplayFormatConfiguration", currencyDisplayFormatConfiguration())
                .add("PercentageDisplayFormatConfiguration", percentageDisplayFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberDisplayFormatConfiguration":
            return Optional.ofNullable(clazz.cast(numberDisplayFormatConfiguration()));
        case "CurrencyDisplayFormatConfiguration":
            return Optional.ofNullable(clazz.cast(currencyDisplayFormatConfiguration()));
        case "PercentageDisplayFormatConfiguration":
            return Optional.ofNullable(clazz.cast(percentageDisplayFormatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericFormatConfiguration, T> g) {
        return obj -> g.apply((NumericFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericFormatConfiguration> {
        /**
         * <p>
         * The options that determine the number display format configuration.
         * </p>
         * 
         * @param numberDisplayFormatConfiguration
         *        The options that determine the number display format configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration numberDisplayFormatConfiguration);

        /**
         * <p>
         * The options that determine the number display format configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberDisplayFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumberDisplayFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberDisplayFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration)}.
         * 
         * @param numberDisplayFormatConfiguration
         *        a consumer that will call methods on {@link NumberDisplayFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration)
         */
        default Builder numberDisplayFormatConfiguration(
                Consumer<NumberDisplayFormatConfiguration.Builder> numberDisplayFormatConfiguration) {
            return numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration.builder()
                    .applyMutation(numberDisplayFormatConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the currency display format configuration.
         * </p>
         * 
         * @param currencyDisplayFormatConfiguration
         *        The options that determine the currency display format configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfiguration currencyDisplayFormatConfiguration);

        /**
         * <p>
         * The options that determine the currency display format configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CurrencyDisplayFormatConfiguration.Builder} avoiding the need to create one manually via
         * {@link CurrencyDisplayFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrencyDisplayFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfiguration)}.
         * 
         * @param currencyDisplayFormatConfiguration
         *        a consumer that will call methods on {@link CurrencyDisplayFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfiguration)
         */
        default Builder currencyDisplayFormatConfiguration(
                Consumer<CurrencyDisplayFormatConfiguration.Builder> currencyDisplayFormatConfiguration) {
            return currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfiguration.builder()
                    .applyMutation(currencyDisplayFormatConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the percentage display format configuration.
         * </p>
         * 
         * @param percentageDisplayFormatConfiguration
         *        The options that determine the percentage display format configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration);

        /**
         * <p>
         * The options that determine the percentage display format configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PercentageDisplayFormatConfiguration.Builder} avoiding the need to create one manually via
         * {@link PercentageDisplayFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PercentageDisplayFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration)}.
         * 
         * @param percentageDisplayFormatConfiguration
         *        a consumer that will call methods on {@link PercentageDisplayFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration)
         */
        default Builder percentageDisplayFormatConfiguration(
                Consumer<PercentageDisplayFormatConfiguration.Builder> percentageDisplayFormatConfiguration) {
            return percentageDisplayFormatConfiguration(PercentageDisplayFormatConfiguration.builder()
                    .applyMutation(percentageDisplayFormatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumberDisplayFormatConfiguration numberDisplayFormatConfiguration;

        private CurrencyDisplayFormatConfiguration currencyDisplayFormatConfiguration;

        private PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericFormatConfiguration model) {
            numberDisplayFormatConfiguration(model.numberDisplayFormatConfiguration);
            currencyDisplayFormatConfiguration(model.currencyDisplayFormatConfiguration);
            percentageDisplayFormatConfiguration(model.percentageDisplayFormatConfiguration);
        }

        public final NumberDisplayFormatConfiguration.Builder getNumberDisplayFormatConfiguration() {
            return numberDisplayFormatConfiguration != null ? numberDisplayFormatConfiguration.toBuilder() : null;
        }

        public final void setNumberDisplayFormatConfiguration(
                NumberDisplayFormatConfiguration.BuilderImpl numberDisplayFormatConfiguration) {
            this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration != null ? numberDisplayFormatConfiguration
                    .build() : null;
        }

        @Override
        public final Builder numberDisplayFormatConfiguration(NumberDisplayFormatConfiguration numberDisplayFormatConfiguration) {
            this.numberDisplayFormatConfiguration = numberDisplayFormatConfiguration;
            return this;
        }

        public final CurrencyDisplayFormatConfiguration.Builder getCurrencyDisplayFormatConfiguration() {
            return currencyDisplayFormatConfiguration != null ? currencyDisplayFormatConfiguration.toBuilder() : null;
        }

        public final void setCurrencyDisplayFormatConfiguration(
                CurrencyDisplayFormatConfiguration.BuilderImpl currencyDisplayFormatConfiguration) {
            this.currencyDisplayFormatConfiguration = currencyDisplayFormatConfiguration != null ? currencyDisplayFormatConfiguration
                    .build() : null;
        }

        @Override
        public final Builder currencyDisplayFormatConfiguration(
                CurrencyDisplayFormatConfiguration currencyDisplayFormatConfiguration) {
            this.currencyDisplayFormatConfiguration = currencyDisplayFormatConfiguration;
            return this;
        }

        public final PercentageDisplayFormatConfiguration.Builder getPercentageDisplayFormatConfiguration() {
            return percentageDisplayFormatConfiguration != null ? percentageDisplayFormatConfiguration.toBuilder() : null;
        }

        public final void setPercentageDisplayFormatConfiguration(
                PercentageDisplayFormatConfiguration.BuilderImpl percentageDisplayFormatConfiguration) {
            this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration != null ? percentageDisplayFormatConfiguration
                    .build() : null;
        }

        @Override
        public final Builder percentageDisplayFormatConfiguration(
                PercentageDisplayFormatConfiguration percentageDisplayFormatConfiguration) {
            this.percentageDisplayFormatConfiguration = percentageDisplayFormatConfiguration;
            return this;
        }

        @Override
        public NumericFormatConfiguration build() {
            return new NumericFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
