/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting configuration for number fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NumberFormatConfiguration.Builder, NumberFormatConfiguration> {
    private static final SdkField<NumericFormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumericFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("FormatConfiguration")
            .getter(getter(NumberFormatConfiguration::formatConfiguration)).setter(setter(Builder::formatConfiguration))
            .constructor(NumericFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final NumericFormatConfiguration formatConfiguration;

    private NumberFormatConfiguration(BuilderImpl builder) {
        this.formatConfiguration = builder.formatConfiguration;
    }

    /**
     * <p>
     * The options that determine the numeric format configuration.
     * </p>
     * 
     * @return The options that determine the numeric format configuration.
     */
    public final NumericFormatConfiguration formatConfiguration() {
        return formatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberFormatConfiguration)) {
            return false;
        }
        NumberFormatConfiguration other = (NumberFormatConfiguration) obj;
        return Objects.equals(formatConfiguration(), other.formatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumberFormatConfiguration").add("FormatConfiguration", formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FormatConfiguration":
            return Optional.ofNullable(clazz.cast(formatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumberFormatConfiguration, T> g) {
        return obj -> g.apply((NumberFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumberFormatConfiguration> {
        /**
         * <p>
         * The options that determine the numeric format configuration.
         * </p>
         * 
         * @param formatConfiguration
         *        The options that determine the numeric format configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfiguration(NumericFormatConfiguration formatConfiguration);

        /**
         * <p>
         * The options that determine the numeric format configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumericFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #formatConfiguration(NumericFormatConfiguration)}.
         * 
         * @param formatConfiguration
         *        a consumer that will call methods on {@link NumericFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatConfiguration(NumericFormatConfiguration)
         */
        default Builder formatConfiguration(Consumer<NumericFormatConfiguration.Builder> formatConfiguration) {
            return formatConfiguration(NumericFormatConfiguration.builder().applyMutation(formatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumericFormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberFormatConfiguration model) {
            formatConfiguration(model.formatConfiguration);
        }

        public final NumericFormatConfiguration.Builder getFormatConfiguration() {
            return formatConfiguration != null ? formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(NumericFormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(NumericFormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        @Override
        public NumberFormatConfiguration build() {
            return new NumberFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
