/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPISparklineOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<KPISparklineOptions.Builder, KPISparklineOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(KPISparklineOptions::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(KPISparklineOptions::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(KPISparklineOptions::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<String> TOOLTIP_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TooltipVisibility").getter(getter(KPISparklineOptions::tooltipVisibilityAsString))
            .setter(setter(Builder::tooltipVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipVisibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, TYPE_FIELD,
            COLOR_FIELD, TOOLTIP_VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final String type;

    private final String color;

    private final String tooltipVisibility;

    private KPISparklineOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.type = builder.type;
        this.color = builder.color;
        this.tooltipVisibility = builder.tooltipVisibility;
    }

    /**
     * <p>
     * The visibility of the sparkline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the sparkline.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the sparkline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the sparkline.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The type of the sparkline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KPISparklineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the sparkline.
     * @see KPISparklineType
     */
    public final KPISparklineType type() {
        return KPISparklineType.fromValue(type);
    }

    /**
     * <p>
     * The type of the sparkline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KPISparklineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the sparkline.
     * @see KPISparklineType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The color of the sparkline.
     * </p>
     * 
     * @return The color of the sparkline.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The tooltip visibility of the sparkline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tooltipVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tooltipVisibilityAsString}.
     * </p>
     * 
     * @return The tooltip visibility of the sparkline.
     * @see Visibility
     */
    public final Visibility tooltipVisibility() {
        return Visibility.fromValue(tooltipVisibility);
    }

    /**
     * <p>
     * The tooltip visibility of the sparkline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tooltipVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tooltipVisibilityAsString}.
     * </p>
     * 
     * @return The tooltip visibility of the sparkline.
     * @see Visibility
     */
    public final String tooltipVisibilityAsString() {
        return tooltipVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(tooltipVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPISparklineOptions)) {
            return false;
        }
        KPISparklineOptions other = (KPISparklineOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(color(), other.color())
                && Objects.equals(tooltipVisibilityAsString(), other.tooltipVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPISparklineOptions").add("Visibility", visibilityAsString()).add("Type", typeAsString())
                .add("Color", color()).add("TooltipVisibility", tooltipVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "TooltipVisibility":
            return Optional.ofNullable(clazz.cast(tooltipVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KPISparklineOptions, T> g) {
        return obj -> g.apply((KPISparklineOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPISparklineOptions> {
        /**
         * <p>
         * The visibility of the sparkline.
         * </p>
         * 
         * @param visibility
         *        The visibility of the sparkline.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the sparkline.
         * </p>
         * 
         * @param visibility
         *        The visibility of the sparkline.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The type of the sparkline.
         * </p>
         * 
         * @param type
         *        The type of the sparkline.
         * @see KPISparklineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KPISparklineType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the sparkline.
         * </p>
         * 
         * @param type
         *        The type of the sparkline.
         * @see KPISparklineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KPISparklineType
         */
        Builder type(KPISparklineType type);

        /**
         * <p>
         * The color of the sparkline.
         * </p>
         * 
         * @param color
         *        The color of the sparkline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The tooltip visibility of the sparkline.
         * </p>
         * 
         * @param tooltipVisibility
         *        The tooltip visibility of the sparkline.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder tooltipVisibility(String tooltipVisibility);

        /**
         * <p>
         * The tooltip visibility of the sparkline.
         * </p>
         * 
         * @param tooltipVisibility
         *        The tooltip visibility of the sparkline.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder tooltipVisibility(Visibility tooltipVisibility);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private String type;

        private String color;

        private String tooltipVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(KPISparklineOptions model) {
            visibility(model.visibility);
            type(model.type);
            color(model.color);
            tooltipVisibility(model.tooltipVisibility);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KPISparklineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getTooltipVisibility() {
            return tooltipVisibility;
        }

        public final void setTooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
        }

        @Override
        public final Builder tooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
            return this;
        }

        @Override
        public final Builder tooltipVisibility(Visibility tooltipVisibility) {
            this.tooltipVisibility(tooltipVisibility == null ? null : tooltipVisibility.toString());
            return this;
        }

        @Override
        public KPISparklineOptions build() {
            return new KPISparklineOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
