/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The control of a filter that is used to interact with a dashboard or an analysis.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterControl implements SdkPojo, Serializable, ToCopyableBuilder<FilterControl.Builder, FilterControl> {
    private static final SdkField<FilterDateTimePickerControl> DATE_TIME_PICKER_FIELD = SdkField
            .<FilterDateTimePickerControl> builder(MarshallingType.SDK_POJO).memberName("DateTimePicker")
            .getter(getter(FilterControl::dateTimePicker)).setter(setter(Builder::dateTimePicker))
            .constructor(FilterDateTimePickerControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimePicker").build()).build();

    private static final SdkField<FilterListControl> LIST_FIELD = SdkField.<FilterListControl> builder(MarshallingType.SDK_POJO)
            .memberName("List").getter(getter(FilterControl::list)).setter(setter(Builder::list))
            .constructor(FilterListControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("List").build()).build();

    private static final SdkField<FilterDropDownControl> DROPDOWN_FIELD = SdkField
            .<FilterDropDownControl> builder(MarshallingType.SDK_POJO).memberName("Dropdown")
            .getter(getter(FilterControl::dropdown)).setter(setter(Builder::dropdown))
            .constructor(FilterDropDownControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dropdown").build()).build();

    private static final SdkField<FilterTextFieldControl> TEXT_FIELD_FIELD = SdkField
            .<FilterTextFieldControl> builder(MarshallingType.SDK_POJO).memberName("TextField")
            .getter(getter(FilterControl::textField)).setter(setter(Builder::textField))
            .constructor(FilterTextFieldControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextField").build()).build();

    private static final SdkField<FilterTextAreaControl> TEXT_AREA_FIELD = SdkField
            .<FilterTextAreaControl> builder(MarshallingType.SDK_POJO).memberName("TextArea")
            .getter(getter(FilterControl::textArea)).setter(setter(Builder::textArea))
            .constructor(FilterTextAreaControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextArea").build()).build();

    private static final SdkField<FilterSliderControl> SLIDER_FIELD = SdkField
            .<FilterSliderControl> builder(MarshallingType.SDK_POJO).memberName("Slider").getter(getter(FilterControl::slider))
            .setter(setter(Builder::slider)).constructor(FilterSliderControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slider").build()).build();

    private static final SdkField<FilterRelativeDateTimeControl> RELATIVE_DATE_TIME_FIELD = SdkField
            .<FilterRelativeDateTimeControl> builder(MarshallingType.SDK_POJO).memberName("RelativeDateTime")
            .getter(getter(FilterControl::relativeDateTime)).setter(setter(Builder::relativeDateTime))
            .constructor(FilterRelativeDateTimeControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_PICKER_FIELD,
            LIST_FIELD, DROPDOWN_FIELD, TEXT_FIELD_FIELD, TEXT_AREA_FIELD, SLIDER_FIELD, RELATIVE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final FilterDateTimePickerControl dateTimePicker;

    private final FilterListControl list;

    private final FilterDropDownControl dropdown;

    private final FilterTextFieldControl textField;

    private final FilterTextAreaControl textArea;

    private final FilterSliderControl slider;

    private final FilterRelativeDateTimeControl relativeDateTime;

    private FilterControl(BuilderImpl builder) {
        this.dateTimePicker = builder.dateTimePicker;
        this.list = builder.list;
        this.dropdown = builder.dropdown;
        this.textField = builder.textField;
        this.textArea = builder.textArea;
        this.slider = builder.slider;
        this.relativeDateTime = builder.relativeDateTime;
    }

    /**
     * <p>
     * A control from a date filter that is used to specify date and time.
     * </p>
     * 
     * @return A control from a date filter that is used to specify date and time.
     */
    public final FilterDateTimePickerControl dateTimePicker() {
        return dateTimePicker;
    }

    /**
     * <p>
     * A control to display a list of buttons or boxes. This is used to select either a single value or multiple values.
     * </p>
     * 
     * @return A control to display a list of buttons or boxes. This is used to select either a single value or multiple
     *         values.
     */
    public final FilterListControl list() {
        return list;
    }

    /**
     * <p>
     * A control to display a dropdown list with buttons that are used to select a single value.
     * </p>
     * 
     * @return A control to display a dropdown list with buttons that are used to select a single value.
     */
    public final FilterDropDownControl dropdown() {
        return dropdown;
    }

    /**
     * <p>
     * A control to display a text box that is used to enter a single entry.
     * </p>
     * 
     * @return A control to display a text box that is used to enter a single entry.
     */
    public final FilterTextFieldControl textField() {
        return textField;
    }

    /**
     * <p>
     * A control to display a text box that is used to enter multiple entries.
     * </p>
     * 
     * @return A control to display a text box that is used to enter multiple entries.
     */
    public final FilterTextAreaControl textArea() {
        return textArea;
    }

    /**
     * <p>
     * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
     * </p>
     * 
     * @return A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
     */
    public final FilterSliderControl slider() {
        return slider;
    }

    /**
     * <p>
     * A control from a date filter that is used to specify the relative date.
     * </p>
     * 
     * @return A control from a date filter that is used to specify the relative date.
     */
    public final FilterRelativeDateTimeControl relativeDateTime() {
        return relativeDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateTimePicker());
        hashCode = 31 * hashCode + Objects.hashCode(list());
        hashCode = 31 * hashCode + Objects.hashCode(dropdown());
        hashCode = 31 * hashCode + Objects.hashCode(textField());
        hashCode = 31 * hashCode + Objects.hashCode(textArea());
        hashCode = 31 * hashCode + Objects.hashCode(slider());
        hashCode = 31 * hashCode + Objects.hashCode(relativeDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterControl)) {
            return false;
        }
        FilterControl other = (FilterControl) obj;
        return Objects.equals(dateTimePicker(), other.dateTimePicker()) && Objects.equals(list(), other.list())
                && Objects.equals(dropdown(), other.dropdown()) && Objects.equals(textField(), other.textField())
                && Objects.equals(textArea(), other.textArea()) && Objects.equals(slider(), other.slider())
                && Objects.equals(relativeDateTime(), other.relativeDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterControl").add("DateTimePicker", dateTimePicker()).add("List", list())
                .add("Dropdown", dropdown()).add("TextField", textField()).add("TextArea", textArea()).add("Slider", slider())
                .add("RelativeDateTime", relativeDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DateTimePicker":
            return Optional.ofNullable(clazz.cast(dateTimePicker()));
        case "List":
            return Optional.ofNullable(clazz.cast(list()));
        case "Dropdown":
            return Optional.ofNullable(clazz.cast(dropdown()));
        case "TextField":
            return Optional.ofNullable(clazz.cast(textField()));
        case "TextArea":
            return Optional.ofNullable(clazz.cast(textArea()));
        case "Slider":
            return Optional.ofNullable(clazz.cast(slider()));
        case "RelativeDateTime":
            return Optional.ofNullable(clazz.cast(relativeDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterControl, T> g) {
        return obj -> g.apply((FilterControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterControl> {
        /**
         * <p>
         * A control from a date filter that is used to specify date and time.
         * </p>
         * 
         * @param dateTimePicker
         *        A control from a date filter that is used to specify date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimePicker(FilterDateTimePickerControl dateTimePicker);

        /**
         * <p>
         * A control from a date filter that is used to specify date and time.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterDateTimePickerControl.Builder}
         * avoiding the need to create one manually via {@link FilterDateTimePickerControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterDateTimePickerControl.Builder#build()} is called
         * immediately and its result is passed to {@link #dateTimePicker(FilterDateTimePickerControl)}.
         * 
         * @param dateTimePicker
         *        a consumer that will call methods on {@link FilterDateTimePickerControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimePicker(FilterDateTimePickerControl)
         */
        default Builder dateTimePicker(Consumer<FilterDateTimePickerControl.Builder> dateTimePicker) {
            return dateTimePicker(FilterDateTimePickerControl.builder().applyMutation(dateTimePicker).build());
        }

        /**
         * <p>
         * A control to display a list of buttons or boxes. This is used to select either a single value or multiple
         * values.
         * </p>
         * 
         * @param list
         *        A control to display a list of buttons or boxes. This is used to select either a single value or
         *        multiple values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(FilterListControl list);

        /**
         * <p>
         * A control to display a list of buttons or boxes. This is used to select either a single value or multiple
         * values.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterListControl.Builder} avoiding the
         * need to create one manually via {@link FilterListControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterListControl.Builder#build()} is called immediately and its
         * result is passed to {@link #list(FilterListControl)}.
         * 
         * @param list
         *        a consumer that will call methods on {@link FilterListControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #list(FilterListControl)
         */
        default Builder list(Consumer<FilterListControl.Builder> list) {
            return list(FilterListControl.builder().applyMutation(list).build());
        }

        /**
         * <p>
         * A control to display a dropdown list with buttons that are used to select a single value.
         * </p>
         * 
         * @param dropdown
         *        A control to display a dropdown list with buttons that are used to select a single value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dropdown(FilterDropDownControl dropdown);

        /**
         * <p>
         * A control to display a dropdown list with buttons that are used to select a single value.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterDropDownControl.Builder} avoiding
         * the need to create one manually via {@link FilterDropDownControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterDropDownControl.Builder#build()} is called immediately and
         * its result is passed to {@link #dropdown(FilterDropDownControl)}.
         * 
         * @param dropdown
         *        a consumer that will call methods on {@link FilterDropDownControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dropdown(FilterDropDownControl)
         */
        default Builder dropdown(Consumer<FilterDropDownControl.Builder> dropdown) {
            return dropdown(FilterDropDownControl.builder().applyMutation(dropdown).build());
        }

        /**
         * <p>
         * A control to display a text box that is used to enter a single entry.
         * </p>
         * 
         * @param textField
         *        A control to display a text box that is used to enter a single entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textField(FilterTextFieldControl textField);

        /**
         * <p>
         * A control to display a text box that is used to enter a single entry.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterTextFieldControl.Builder} avoiding
         * the need to create one manually via {@link FilterTextFieldControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterTextFieldControl.Builder#build()} is called immediately and
         * its result is passed to {@link #textField(FilterTextFieldControl)}.
         * 
         * @param textField
         *        a consumer that will call methods on {@link FilterTextFieldControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textField(FilterTextFieldControl)
         */
        default Builder textField(Consumer<FilterTextFieldControl.Builder> textField) {
            return textField(FilterTextFieldControl.builder().applyMutation(textField).build());
        }

        /**
         * <p>
         * A control to display a text box that is used to enter multiple entries.
         * </p>
         * 
         * @param textArea
         *        A control to display a text box that is used to enter multiple entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textArea(FilterTextAreaControl textArea);

        /**
         * <p>
         * A control to display a text box that is used to enter multiple entries.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterTextAreaControl.Builder} avoiding
         * the need to create one manually via {@link FilterTextAreaControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterTextAreaControl.Builder#build()} is called immediately and
         * its result is passed to {@link #textArea(FilterTextAreaControl)}.
         * 
         * @param textArea
         *        a consumer that will call methods on {@link FilterTextAreaControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textArea(FilterTextAreaControl)
         */
        default Builder textArea(Consumer<FilterTextAreaControl.Builder> textArea) {
            return textArea(FilterTextAreaControl.builder().applyMutation(textArea).build());
        }

        /**
         * <p>
         * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
         * </p>
         * 
         * @param slider
         *        A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slider(FilterSliderControl slider);

        /**
         * <p>
         * A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterSliderControl.Builder} avoiding the
         * need to create one manually via {@link FilterSliderControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterSliderControl.Builder#build()} is called immediately and
         * its result is passed to {@link #slider(FilterSliderControl)}.
         * 
         * @param slider
         *        a consumer that will call methods on {@link FilterSliderControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slider(FilterSliderControl)
         */
        default Builder slider(Consumer<FilterSliderControl.Builder> slider) {
            return slider(FilterSliderControl.builder().applyMutation(slider).build());
        }

        /**
         * <p>
         * A control from a date filter that is used to specify the relative date.
         * </p>
         * 
         * @param relativeDateTime
         *        A control from a date filter that is used to specify the relative date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeDateTime(FilterRelativeDateTimeControl relativeDateTime);

        /**
         * <p>
         * A control from a date filter that is used to specify the relative date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterRelativeDateTimeControl.Builder}
         * avoiding the need to create one manually via {@link FilterRelativeDateTimeControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterRelativeDateTimeControl.Builder#build()} is called
         * immediately and its result is passed to {@link #relativeDateTime(FilterRelativeDateTimeControl)}.
         * 
         * @param relativeDateTime
         *        a consumer that will call methods on {@link FilterRelativeDateTimeControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeDateTime(FilterRelativeDateTimeControl)
         */
        default Builder relativeDateTime(Consumer<FilterRelativeDateTimeControl.Builder> relativeDateTime) {
            return relativeDateTime(FilterRelativeDateTimeControl.builder().applyMutation(relativeDateTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterDateTimePickerControl dateTimePicker;

        private FilterListControl list;

        private FilterDropDownControl dropdown;

        private FilterTextFieldControl textField;

        private FilterTextAreaControl textArea;

        private FilterSliderControl slider;

        private FilterRelativeDateTimeControl relativeDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterControl model) {
            dateTimePicker(model.dateTimePicker);
            list(model.list);
            dropdown(model.dropdown);
            textField(model.textField);
            textArea(model.textArea);
            slider(model.slider);
            relativeDateTime(model.relativeDateTime);
        }

        public final FilterDateTimePickerControl.Builder getDateTimePicker() {
            return dateTimePicker != null ? dateTimePicker.toBuilder() : null;
        }

        public final void setDateTimePicker(FilterDateTimePickerControl.BuilderImpl dateTimePicker) {
            this.dateTimePicker = dateTimePicker != null ? dateTimePicker.build() : null;
        }

        @Override
        public final Builder dateTimePicker(FilterDateTimePickerControl dateTimePicker) {
            this.dateTimePicker = dateTimePicker;
            return this;
        }

        public final FilterListControl.Builder getList() {
            return list != null ? list.toBuilder() : null;
        }

        public final void setList(FilterListControl.BuilderImpl list) {
            this.list = list != null ? list.build() : null;
        }

        @Override
        public final Builder list(FilterListControl list) {
            this.list = list;
            return this;
        }

        public final FilterDropDownControl.Builder getDropdown() {
            return dropdown != null ? dropdown.toBuilder() : null;
        }

        public final void setDropdown(FilterDropDownControl.BuilderImpl dropdown) {
            this.dropdown = dropdown != null ? dropdown.build() : null;
        }

        @Override
        public final Builder dropdown(FilterDropDownControl dropdown) {
            this.dropdown = dropdown;
            return this;
        }

        public final FilterTextFieldControl.Builder getTextField() {
            return textField != null ? textField.toBuilder() : null;
        }

        public final void setTextField(FilterTextFieldControl.BuilderImpl textField) {
            this.textField = textField != null ? textField.build() : null;
        }

        @Override
        public final Builder textField(FilterTextFieldControl textField) {
            this.textField = textField;
            return this;
        }

        public final FilterTextAreaControl.Builder getTextArea() {
            return textArea != null ? textArea.toBuilder() : null;
        }

        public final void setTextArea(FilterTextAreaControl.BuilderImpl textArea) {
            this.textArea = textArea != null ? textArea.build() : null;
        }

        @Override
        public final Builder textArea(FilterTextAreaControl textArea) {
            this.textArea = textArea;
            return this;
        }

        public final FilterSliderControl.Builder getSlider() {
            return slider != null ? slider.toBuilder() : null;
        }

        public final void setSlider(FilterSliderControl.BuilderImpl slider) {
            this.slider = slider != null ? slider.build() : null;
        }

        @Override
        public final Builder slider(FilterSliderControl slider) {
            this.slider = slider;
            return this;
        }

        public final FilterRelativeDateTimeControl.Builder getRelativeDateTime() {
            return relativeDateTime != null ? relativeDateTime.toBuilder() : null;
        }

        public final void setRelativeDateTime(FilterRelativeDateTimeControl.BuilderImpl relativeDateTime) {
            this.relativeDateTime = relativeDateTime != null ? relativeDateTime.build() : null;
        }

        @Override
        public final Builder relativeDateTime(FilterRelativeDateTimeControl relativeDateTime) {
            this.relativeDateTime = relativeDateTime;
            return this;
        }

        @Override
        public FilterControl build() {
            return new FilterControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
