/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIpRestrictionResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeIpRestrictionResponse.Builder, DescribeIpRestrictionResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeIpRestrictionResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<Map<String, String>> IP_RESTRICTION_RULE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("IpRestrictionRuleMap")
            .getter(getter(DescribeIpRestrictionResponse::ipRestrictionRuleMap))
            .setter(setter(Builder::ipRestrictionRuleMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRestrictionRuleMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(DescribeIpRestrictionResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeIpRestrictionResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeIpRestrictionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            IP_RESTRICTION_RULE_MAP_FIELD, ENABLED_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String awsAccountId;

    private final Map<String, String> ipRestrictionRuleMap;

    private final Boolean enabled;

    private final String requestId;

    private final Integer status;

    private DescribeIpRestrictionResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.ipRestrictionRuleMap = builder.ipRestrictionRuleMap;
        this.enabled = builder.enabled;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the IP rules.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the IP rules.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpRestrictionRuleMap property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpRestrictionRuleMap() {
        return ipRestrictionRuleMap != null && !(ipRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that describes the IP rules with CIDR range and description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpRestrictionRuleMap} method.
     * </p>
     * 
     * @return A map that describes the IP rules with CIDR range and description.
     */
    public final Map<String, String> ipRestrictionRuleMap() {
        return ipRestrictionRuleMap;
    }

    /**
     * <p>
     * A value that specifies whether IP rules are turned on.
     * </p>
     * 
     * @return A value that specifies whether IP rules are turned on.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRestrictionRuleMap() ? ipRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpRestrictionResponse)) {
            return false;
        }
        DescribeIpRestrictionResponse other = (DescribeIpRestrictionResponse) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && hasIpRestrictionRuleMap() == other.hasIpRestrictionRuleMap()
                && Objects.equals(ipRestrictionRuleMap(), other.ipRestrictionRuleMap())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIpRestrictionResponse").add("AwsAccountId", awsAccountId())
                .add("IpRestrictionRuleMap", hasIpRestrictionRuleMap() ? ipRestrictionRuleMap() : null).add("Enabled", enabled())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "IpRestrictionRuleMap":
            return Optional.ofNullable(clazz.cast(ipRestrictionRuleMap()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpRestrictionResponse, T> g) {
        return obj -> g.apply((DescribeIpRestrictionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIpRestrictionResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the IP rules.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the IP rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A map that describes the IP rules with CIDR range and description.
         * </p>
         * 
         * @param ipRestrictionRuleMap
         *        A map that describes the IP rules with CIDR range and description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap);

        /**
         * <p>
         * A value that specifies whether IP rules are turned on.
         * </p>
         * 
         * @param enabled
         *        A value that specifies whether IP rules are turned on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String awsAccountId;

        private Map<String, String> ipRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enabled;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpRestrictionResponse model) {
            super(model);
            awsAccountId(model.awsAccountId);
            ipRestrictionRuleMap(model.ipRestrictionRuleMap);
            enabled(model.enabled);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Map<String, String> getIpRestrictionRuleMap() {
            if (ipRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return ipRestrictionRuleMap;
        }

        public final void setIpRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
        }

        @Override
        public final Builder ipRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeIpRestrictionResponse build() {
            return new DescribeIpRestrictionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
