/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardSnapshotJobRequest extends QuickSightRequest implements
        ToCopyableBuilder<DescribeDashboardSnapshotJobRequest.Builder, DescribeDashboardSnapshotJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeDashboardSnapshotJobRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DescribeDashboardSnapshotJobRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> SNAPSHOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotJobId").getter(getter(DescribeDashboardSnapshotJobRequest::snapshotJobId))
            .setter(setter(Builder::snapshotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SnapshotJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, SNAPSHOT_JOB_ID_FIELD));

    private final String awsAccountId;

    private final String dashboardId;

    private final String snapshotJobId;

    private DescribeDashboardSnapshotJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.snapshotJobId = builder.snapshotJobId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the dashboard that you have started a snapshot job for.
     * </p>
     * 
     * @return The ID of the dashboard that you have started a snapshot job for.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The ID of the job to be described. The job ID is set when you start a new job with a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return The ID of the job to be described. The job ID is set when you start a new job with a
     *         <code>StartDashboardSnapshotJob</code> API call.
     */
    public final String snapshotJobId() {
        return snapshotJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardSnapshotJobRequest)) {
            return false;
        }
        DescribeDashboardSnapshotJobRequest other = (DescribeDashboardSnapshotJobRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(snapshotJobId(), other.snapshotJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardSnapshotJobRequest").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("SnapshotJobId", snapshotJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "SnapshotJobId":
            return Optional.ofNullable(clazz.cast(snapshotJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardSnapshotJobRequest, T> g) {
        return obj -> g.apply((DescribeDashboardSnapshotJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDashboardSnapshotJobRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the dashboard that you have started a snapshot job for.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard that you have started a snapshot job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The ID of the job to be described. The job ID is set when you start a new job with a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param snapshotJobId
         *        The ID of the job to be described. The job ID is set when you start a new job with a
         *        <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotJobId(String snapshotJobId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String snapshotJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardSnapshotJobRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            snapshotJobId(model.snapshotJobId);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getSnapshotJobId() {
            return snapshotJobId;
        }

        public final void setSnapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
        }

        @Override
        public final Builder snapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDashboardSnapshotJobRequest build() {
            return new DescribeDashboardSnapshotJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
