/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of the visual.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComboChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<ComboChartFieldWells.Builder, ComboChartFieldWells> {
    private static final SdkField<ComboChartAggregatedFieldWells> COMBO_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<ComboChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("ComboChartAggregatedFieldWells")
            .getter(getter(ComboChartFieldWells::comboChartAggregatedFieldWells))
            .setter(setter(Builder::comboChartAggregatedFieldWells))
            .constructor(ComboChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComboChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMBO_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComboChartAggregatedFieldWells comboChartAggregatedFieldWells;

    private ComboChartFieldWells(BuilderImpl builder) {
        this.comboChartAggregatedFieldWells = builder.comboChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in a combo
     * chart are aggregated by category.
     * </p>
     * 
     * @return The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in a
     *         combo chart are aggregated by category.
     */
    public final ComboChartAggregatedFieldWells comboChartAggregatedFieldWells() {
        return comboChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comboChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComboChartFieldWells)) {
            return false;
        }
        ComboChartFieldWells other = (ComboChartFieldWells) obj;
        return Objects.equals(comboChartAggregatedFieldWells(), other.comboChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComboChartFieldWells").add("ComboChartAggregatedFieldWells", comboChartAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComboChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(comboChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComboChartFieldWells, T> g) {
        return obj -> g.apply((ComboChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComboChartFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in a
         * combo chart are aggregated by category.
         * </p>
         * 
         * @param comboChartAggregatedFieldWells
         *        The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in
         *        a combo chart are aggregated by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comboChartAggregatedFieldWells(ComboChartAggregatedFieldWells comboChartAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in a
         * combo chart are aggregated by category.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComboChartAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link ComboChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComboChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #comboChartAggregatedFieldWells(ComboChartAggregatedFieldWells)}.
         * 
         * @param comboChartAggregatedFieldWells
         *        a consumer that will call methods on {@link ComboChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comboChartAggregatedFieldWells(ComboChartAggregatedFieldWells)
         */
        default Builder comboChartAggregatedFieldWells(
                Consumer<ComboChartAggregatedFieldWells.Builder> comboChartAggregatedFieldWells) {
            return comboChartAggregatedFieldWells(ComboChartAggregatedFieldWells.builder()
                    .applyMutation(comboChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComboChartAggregatedFieldWells comboChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(ComboChartFieldWells model) {
            comboChartAggregatedFieldWells(model.comboChartAggregatedFieldWells);
        }

        public final ComboChartAggregatedFieldWells.Builder getComboChartAggregatedFieldWells() {
            return comboChartAggregatedFieldWells != null ? comboChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setComboChartAggregatedFieldWells(
                ComboChartAggregatedFieldWells.BuilderImpl comboChartAggregatedFieldWells) {
            this.comboChartAggregatedFieldWells = comboChartAggregatedFieldWells != null ? comboChartAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder comboChartAggregatedFieldWells(ComboChartAggregatedFieldWells comboChartAggregatedFieldWells) {
            this.comboChartAggregatedFieldWells = comboChartAggregatedFieldWells;
            return this;
        }

        @Override
        public ComboChartFieldWells build() {
            return new ComboChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
