/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label options for an axis on a chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChartAxisLabelOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ChartAxisLabelOptions.Builder, ChartAxisLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(ChartAxisLabelOptions::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> SORT_ICON_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortIconVisibility").getter(getter(ChartAxisLabelOptions::sortIconVisibilityAsString))
            .setter(setter(Builder::sortIconVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortIconVisibility").build())
            .build();

    private static final SdkField<List<AxisLabelOptions>> AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<List<AxisLabelOptions>> builder(MarshallingType.LIST)
            .memberName("AxisLabelOptions")
            .getter(getter(ChartAxisLabelOptions::axisLabelOptions))
            .setter(setter(Builder::axisLabelOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisLabelOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AxisLabelOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AxisLabelOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            SORT_ICON_VISIBILITY_FIELD, AXIS_LABEL_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final String sortIconVisibility;

    private final List<AxisLabelOptions> axisLabelOptions;

    private ChartAxisLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.sortIconVisibility = builder.sortIconVisibility;
        this.axisLabelOptions = builder.axisLabelOptions;
    }

    /**
     * <p>
     * The visibility of an axis label on a chart. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VISIBLE</code>: Shows the axis.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIDDEN</code>: Hides the axis.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of an axis label on a chart. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VISIBLE</code>: Shows the axis.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIDDEN</code>: Hides the axis.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of an axis label on a chart. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VISIBLE</code>: Shows the axis.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIDDEN</code>: Hides the axis.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of an axis label on a chart. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VISIBLE</code>: Shows the axis.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIDDEN</code>: Hides the axis.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The visibility configuration of the sort icon on a chart's axis label.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sortIconVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortIconVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration of the sort icon on a chart's axis label.
     * @see Visibility
     */
    public final Visibility sortIconVisibility() {
        return Visibility.fromValue(sortIconVisibility);
    }

    /**
     * <p>
     * The visibility configuration of the sort icon on a chart's axis label.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sortIconVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortIconVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration of the sort icon on a chart's axis label.
     * @see Visibility
     */
    public final String sortIconVisibilityAsString() {
        return sortIconVisibility;
    }

    /**
     * For responses, this returns true if the service returned a value for the AxisLabelOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAxisLabelOptions() {
        return axisLabelOptions != null && !(axisLabelOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The label options for a chart axis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAxisLabelOptions} method.
     * </p>
     * 
     * @return The label options for a chart axis.
     */
    public final List<AxisLabelOptions> axisLabelOptions() {
        return axisLabelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortIconVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAxisLabelOptions() ? axisLabelOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChartAxisLabelOptions)) {
            return false;
        }
        ChartAxisLabelOptions other = (ChartAxisLabelOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(sortIconVisibilityAsString(), other.sortIconVisibilityAsString())
                && hasAxisLabelOptions() == other.hasAxisLabelOptions()
                && Objects.equals(axisLabelOptions(), other.axisLabelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChartAxisLabelOptions").add("Visibility", visibilityAsString())
                .add("SortIconVisibility", sortIconVisibilityAsString())
                .add("AxisLabelOptions", hasAxisLabelOptions() ? axisLabelOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "SortIconVisibility":
            return Optional.ofNullable(clazz.cast(sortIconVisibilityAsString()));
        case "AxisLabelOptions":
            return Optional.ofNullable(clazz.cast(axisLabelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChartAxisLabelOptions, T> g) {
        return obj -> g.apply((ChartAxisLabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChartAxisLabelOptions> {
        /**
         * <p>
         * The visibility of an axis label on a chart. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VISIBLE</code>: Shows the axis.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIDDEN</code>: Hides the axis.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        The visibility of an axis label on a chart. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VISIBLE</code>: Shows the axis.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIDDEN</code>: Hides the axis.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of an axis label on a chart. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VISIBLE</code>: Shows the axis.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIDDEN</code>: Hides the axis.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        The visibility of an axis label on a chart. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VISIBLE</code>: Shows the axis.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIDDEN</code>: Hides the axis.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The visibility configuration of the sort icon on a chart's axis label.
         * </p>
         * 
         * @param sortIconVisibility
         *        The visibility configuration of the sort icon on a chart's axis label.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder sortIconVisibility(String sortIconVisibility);

        /**
         * <p>
         * The visibility configuration of the sort icon on a chart's axis label.
         * </p>
         * 
         * @param sortIconVisibility
         *        The visibility configuration of the sort icon on a chart's axis label.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder sortIconVisibility(Visibility sortIconVisibility);

        /**
         * <p>
         * The label options for a chart axis.
         * </p>
         * 
         * @param axisLabelOptions
         *        The label options for a chart axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder axisLabelOptions(Collection<AxisLabelOptions> axisLabelOptions);

        /**
         * <p>
         * The label options for a chart axis.
         * </p>
         * 
         * @param axisLabelOptions
         *        The label options for a chart axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder axisLabelOptions(AxisLabelOptions... axisLabelOptions);

        /**
         * <p>
         * The label options for a chart axis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AxisLabelOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.AxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AxisLabelOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #axisLabelOptions(List<AxisLabelOptions>)}.
         * 
         * @param axisLabelOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #axisLabelOptions(java.util.Collection<AxisLabelOptions>)
         */
        Builder axisLabelOptions(Consumer<AxisLabelOptions.Builder>... axisLabelOptions);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private String sortIconVisibility;

        private List<AxisLabelOptions> axisLabelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChartAxisLabelOptions model) {
            visibility(model.visibility);
            sortIconVisibility(model.sortIconVisibility);
            axisLabelOptions(model.axisLabelOptions);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getSortIconVisibility() {
            return sortIconVisibility;
        }

        public final void setSortIconVisibility(String sortIconVisibility) {
            this.sortIconVisibility = sortIconVisibility;
        }

        @Override
        public final Builder sortIconVisibility(String sortIconVisibility) {
            this.sortIconVisibility = sortIconVisibility;
            return this;
        }

        @Override
        public final Builder sortIconVisibility(Visibility sortIconVisibility) {
            this.sortIconVisibility(sortIconVisibility == null ? null : sortIconVisibility.toString());
            return this;
        }

        public final List<AxisLabelOptions.Builder> getAxisLabelOptions() {
            List<AxisLabelOptions.Builder> result = AxisLabelOptionsListCopier.copyToBuilder(this.axisLabelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAxisLabelOptions(Collection<AxisLabelOptions.BuilderImpl> axisLabelOptions) {
            this.axisLabelOptions = AxisLabelOptionsListCopier.copyFromBuilder(axisLabelOptions);
        }

        @Override
        public final Builder axisLabelOptions(Collection<AxisLabelOptions> axisLabelOptions) {
            this.axisLabelOptions = AxisLabelOptionsListCopier.copy(axisLabelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder axisLabelOptions(AxisLabelOptions... axisLabelOptions) {
            axisLabelOptions(Arrays.asList(axisLabelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder axisLabelOptions(Consumer<AxisLabelOptions.Builder>... axisLabelOptions) {
            axisLabelOptions(Stream.of(axisLabelOptions).map(c -> AxisLabelOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChartAxisLabelOptions build() {
            return new ChartAxisLabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
