/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration of a <code>BoxPlotVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BoxPlotSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BoxPlotSortConfiguration.Builder, BoxPlotSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("CategorySort")
            .getter(getter(BoxPlotSortConfiguration::categorySort))
            .setter(setter(Builder::categorySort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PaginationConfiguration> PAGINATION_CONFIGURATION_FIELD = SdkField
            .<PaginationConfiguration> builder(MarshallingType.SDK_POJO).memberName("PaginationConfiguration")
            .getter(getter(BoxPlotSortConfiguration::paginationConfiguration)).setter(setter(Builder::paginationConfiguration))
            .constructor(PaginationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD,
            PAGINATION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> categorySort;

    private final PaginationConfiguration paginationConfiguration;

    private BoxPlotSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.paginationConfiguration = builder.paginationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategorySort property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCategorySort() {
        return categorySort != null && !(categorySort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sort configuration of a group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategorySort} method.
     * </p>
     * 
     * @return The sort configuration of a group by fields.
     */
    public final List<FieldSortOptions> categorySort() {
        return categorySort;
    }

    /**
     * <p>
     * The pagination configuration of a table visual or box plot.
     * </p>
     * 
     * @return The pagination configuration of a table visual or box plot.
     */
    public final PaginationConfiguration paginationConfiguration() {
        return paginationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategorySort() ? categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotSortConfiguration)) {
            return false;
        }
        BoxPlotSortConfiguration other = (BoxPlotSortConfiguration) obj;
        return hasCategorySort() == other.hasCategorySort() && Objects.equals(categorySort(), other.categorySort())
                && Objects.equals(paginationConfiguration(), other.paginationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BoxPlotSortConfiguration").add("CategorySort", hasCategorySort() ? categorySort() : null)
                .add("PaginationConfiguration", paginationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategorySort":
            return Optional.ofNullable(clazz.cast(categorySort()));
        case "PaginationConfiguration":
            return Optional.ofNullable(clazz.cast(paginationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotSortConfiguration, T> g) {
        return obj -> g.apply((BoxPlotSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BoxPlotSortConfiguration> {
        /**
         * <p>
         * The sort configuration of a group by fields.
         * </p>
         * 
         * @param categorySort
         *        The sort configuration of a group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySort(Collection<FieldSortOptions> categorySort);

        /**
         * <p>
         * The sort configuration of a group by fields.
         * </p>
         * 
         * @param categorySort
         *        The sort configuration of a group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySort(FieldSortOptions... categorySort);

        /**
         * <p>
         * The sort configuration of a group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #categorySort(List<FieldSortOptions>)}.
         * 
         * @param categorySort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categorySort(java.util.Collection<FieldSortOptions>)
         */
        Builder categorySort(Consumer<FieldSortOptions.Builder>... categorySort);

        /**
         * <p>
         * The pagination configuration of a table visual or box plot.
         * </p>
         * 
         * @param paginationConfiguration
         *        The pagination configuration of a table visual or box plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationConfiguration(PaginationConfiguration paginationConfiguration);

        /**
         * <p>
         * The pagination configuration of a table visual or box plot.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaginationConfiguration.Builder} avoiding
         * the need to create one manually via {@link PaginationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaginationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #paginationConfiguration(PaginationConfiguration)}.
         * 
         * @param paginationConfiguration
         *        a consumer that will call methods on {@link PaginationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paginationConfiguration(PaginationConfiguration)
         */
        default Builder paginationConfiguration(Consumer<PaginationConfiguration.Builder> paginationConfiguration) {
            return paginationConfiguration(PaginationConfiguration.builder().applyMutation(paginationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();

        private PaginationConfiguration paginationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotSortConfiguration model) {
            categorySort(model.categorySort);
            paginationConfiguration(model.paginationConfiguration);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions... categorySort) {
            categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder>... categorySort) {
            categorySort(Stream.of(categorySort).map(c -> FieldSortOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PaginationConfiguration.Builder getPaginationConfiguration() {
            return paginationConfiguration != null ? paginationConfiguration.toBuilder() : null;
        }

        public final void setPaginationConfiguration(PaginationConfiguration.BuilderImpl paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration != null ? paginationConfiguration.build() : null;
        }

        @Override
        public final Builder paginationConfiguration(PaginationConfiguration paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration;
            return this;
        }

        @Override
        public BoxPlotSortConfiguration build() {
            return new BoxPlotSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
