/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>BoxPlotVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BoxPlotChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BoxPlotChartConfiguration.Builder, BoxPlotChartConfiguration> {
    private static final SdkField<BoxPlotFieldWells> FIELD_WELLS_FIELD = SdkField
            .<BoxPlotFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(BoxPlotChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(BoxPlotFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<BoxPlotSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<BoxPlotSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(BoxPlotChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(BoxPlotSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<BoxPlotOptions> BOX_PLOT_OPTIONS_FIELD = SdkField
            .<BoxPlotOptions> builder(MarshallingType.SDK_POJO).memberName("BoxPlotOptions")
            .getter(getter(BoxPlotChartConfiguration::boxPlotOptions)).setter(setter(Builder::boxPlotOptions))
            .constructor(BoxPlotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoxPlotOptions").build()).build();

    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryAxis")
            .getter(getter(BoxPlotChartConfiguration::categoryAxis)).setter(setter(Builder::categoryAxis))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()).build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(BoxPlotChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryYAxisDisplayOptions")
            .getter(getter(BoxPlotChartConfiguration::primaryYAxisDisplayOptions))
            .setter(setter(Builder::primaryYAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions")
            .getter(getter(BoxPlotChartConfiguration::primaryYAxisLabelOptions))
            .setter(setter(Builder::primaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build())
            .build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(BoxPlotChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(BoxPlotChartConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField
            .<List<ReferenceLine>> builder(MarshallingType.LIST)
            .memberName("ReferenceLines")
            .getter(getter(BoxPlotChartConfiguration::referenceLines))
            .setter(setter(Builder::referenceLines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceLine> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceLine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(BoxPlotChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, BOX_PLOT_OPTIONS_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD,
            PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD, LEGEND_FIELD, TOOLTIP_FIELD,
            REFERENCE_LINES_FIELD, VISUAL_PALETTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final BoxPlotFieldWells fieldWells;

    private final BoxPlotSortConfiguration sortConfiguration;

    private final BoxPlotOptions boxPlotOptions;

    private final AxisDisplayOptions categoryAxis;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final AxisDisplayOptions primaryYAxisDisplayOptions;

    private final ChartAxisLabelOptions primaryYAxisLabelOptions;

    private final LegendOptions legend;

    private final TooltipOptions tooltip;

    private final List<ReferenceLine> referenceLines;

    private final VisualPalette visualPalette;

    private BoxPlotChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.boxPlotOptions = builder.boxPlotOptions;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.legend = builder.legend;
        this.tooltip = builder.tooltip;
        this.referenceLines = builder.referenceLines;
        this.visualPalette = builder.visualPalette;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final BoxPlotFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a <code>BoxPlotVisual</code>.
     * </p>
     * 
     * @return The sort configuration of a <code>BoxPlotVisual</code>.
     */
    public final BoxPlotSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The box plot chart options for a box plot visual
     * </p>
     * 
     * @return The box plot chart options for a box plot visual
     */
    public final BoxPlotOptions boxPlotOptions() {
        return boxPlotOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, axis step) of a box plot category.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, axis step) of a box plot category.
     */
    public final AxisDisplayOptions categoryAxis() {
        return categoryAxis;
    }

    /**
     * <p>
     * The label options (label text, label visibility and sort Icon visibility) of a box plot category.
     * </p>
     * 
     * @return The label options (label text, label visibility and sort Icon visibility) of a box plot category.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, axis step) of a box plot category.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, axis step) of a box plot category.
     */
    public final AxisDisplayOptions primaryYAxisDisplayOptions() {
        return primaryYAxisDisplayOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility and sort icon visibility) of a box plot value.
     * </p>
     * 
     * @return The label options (label text, label visibility and sort icon visibility) of a box plot value.
     */
    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return primaryYAxisLabelOptions;
    }

    /**
     * Returns the value of the Legend property for this object.
     * 
     * @return The value of the Legend property for this object.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceLines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceLines() {
        return referenceLines != null && !(referenceLines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reference line setup of the visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceLines} method.
     * </p>
     * 
     * @return The reference line setup of the visual.
     */
    public final List<ReferenceLine> referenceLines() {
        return referenceLines;
    }

    /**
     * <p>
     * The palette (chart color) display setup of the visual.
     * </p>
     * 
     * @return The palette (chart color) display setup of the visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(boxPlotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceLines() ? referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotChartConfiguration)) {
            return false;
        }
        BoxPlotChartConfiguration other = (BoxPlotChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(boxPlotOptions(), other.boxPlotOptions())
                && Objects.equals(categoryAxis(), other.categoryAxis())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions())
                && Objects.equals(primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions())
                && Objects.equals(legend(), other.legend()) && Objects.equals(tooltip(), other.tooltip())
                && hasReferenceLines() == other.hasReferenceLines() && Objects.equals(referenceLines(), other.referenceLines())
                && Objects.equals(visualPalette(), other.visualPalette());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BoxPlotChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("BoxPlotOptions", boxPlotOptions())
                .add("CategoryAxis", categoryAxis()).add("CategoryLabelOptions", categoryLabelOptions())
                .add("PrimaryYAxisDisplayOptions", primaryYAxisDisplayOptions())
                .add("PrimaryYAxisLabelOptions", primaryYAxisLabelOptions()).add("Legend", legend()).add("Tooltip", tooltip())
                .add("ReferenceLines", hasReferenceLines() ? referenceLines() : null).add("VisualPalette", visualPalette())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "BoxPlotOptions":
            return Optional.ofNullable(clazz.cast(boxPlotOptions()));
        case "CategoryAxis":
            return Optional.ofNullable(clazz.cast(categoryAxis()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "PrimaryYAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisDisplayOptions()));
        case "PrimaryYAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisLabelOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "ReferenceLines":
            return Optional.ofNullable(clazz.cast(referenceLines()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotChartConfiguration, T> g) {
        return obj -> g.apply((BoxPlotChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BoxPlotChartConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(BoxPlotFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoxPlotFieldWells.Builder} avoiding the
         * need to create one manually via {@link BoxPlotFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoxPlotFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(BoxPlotFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link BoxPlotFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(BoxPlotFieldWells)
         */
        default Builder fieldWells(Consumer<BoxPlotFieldWells.Builder> fieldWells) {
            return fieldWells(BoxPlotFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a <code>BoxPlotVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a <code>BoxPlotVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(BoxPlotSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a <code>BoxPlotVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoxPlotSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link BoxPlotSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoxPlotSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(BoxPlotSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link BoxPlotSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(BoxPlotSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<BoxPlotSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(BoxPlotSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The box plot chart options for a box plot visual
         * </p>
         * 
         * @param boxPlotOptions
         *        The box plot chart options for a box plot visual
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boxPlotOptions(BoxPlotOptions boxPlotOptions);

        /**
         * <p>
         * The box plot chart options for a box plot visual
         * </p>
         * This is a convenience method that creates an instance of the {@link BoxPlotOptions.Builder} avoiding the need
         * to create one manually via {@link BoxPlotOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoxPlotOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #boxPlotOptions(BoxPlotOptions)}.
         * 
         * @param boxPlotOptions
         *        a consumer that will call methods on {@link BoxPlotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boxPlotOptions(BoxPlotOptions)
         */
        default Builder boxPlotOptions(Consumer<BoxPlotOptions.Builder> boxPlotOptions) {
            return boxPlotOptions(BoxPlotOptions.builder().applyMutation(boxPlotOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         * </p>
         * 
         * @param categoryAxis
         *        The label display options (grid line, range, scale, axis step) of a box plot category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryAxis(AxisDisplayOptions categoryAxis);

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryAxis(AxisDisplayOptions)}.
         * 
         * @param categoryAxis
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryAxis(AxisDisplayOptions)
         */
        default Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return categoryAxis(AxisDisplayOptions.builder().applyMutation(categoryAxis).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility and sort Icon visibility) of a box plot category.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The label options (label text, label visibility and sort Icon visibility) of a box plot category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility and sort Icon visibility) of a box plot category.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         * </p>
         * 
         * @param primaryYAxisDisplayOptions
         *        The label display options (grid line, range, scale, axis step) of a box plot category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions);

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryYAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param primaryYAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder primaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return primaryYAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) of a box plot value.
         * </p>
         * 
         * @param primaryYAxisLabelOptions
         *        The label options (label text, label visibility and sort icon visibility) of a box plot value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) of a box plot value.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryYAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param primaryYAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return primaryYAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions).build());
        }

        /**
         * Sets the value of the Legend property for this object.
         *
         * @param legend
         *        The new value for the Legend property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * Sets the value of the Legend property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * 
         * @param referenceLines
         *        The reference line setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(Collection<ReferenceLine> referenceLines);

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * 
         * @param referenceLines
         *        The reference line setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(ReferenceLine... referenceLines);

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder#build()} is called immediately
         * and its result is passed to {@link #referenceLines(List<ReferenceLine>)}.
         * 
         * @param referenceLines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceLines(java.util.Collection<ReferenceLine>)
         */
        Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * 
         * @param visualPalette
         *        The palette (chart color) display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BoxPlotFieldWells fieldWells;

        private BoxPlotSortConfiguration sortConfiguration;

        private BoxPlotOptions boxPlotOptions;

        private AxisDisplayOptions categoryAxis;

        private ChartAxisLabelOptions categoryLabelOptions;

        private AxisDisplayOptions primaryYAxisDisplayOptions;

        private ChartAxisLabelOptions primaryYAxisLabelOptions;

        private LegendOptions legend;

        private TooltipOptions tooltip;

        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();

        private VisualPalette visualPalette;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            boxPlotOptions(model.boxPlotOptions);
            categoryAxis(model.categoryAxis);
            categoryLabelOptions(model.categoryLabelOptions);
            primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            legend(model.legend);
            tooltip(model.tooltip);
            referenceLines(model.referenceLines);
            visualPalette(model.visualPalette);
        }

        public final BoxPlotFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(BoxPlotFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(BoxPlotFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final BoxPlotSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(BoxPlotSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(BoxPlotSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final BoxPlotOptions.Builder getBoxPlotOptions() {
            return boxPlotOptions != null ? boxPlotOptions.toBuilder() : null;
        }

        public final void setBoxPlotOptions(BoxPlotOptions.BuilderImpl boxPlotOptions) {
            this.boxPlotOptions = boxPlotOptions != null ? boxPlotOptions.build() : null;
        }

        @Override
        public final Builder boxPlotOptions(BoxPlotOptions boxPlotOptions) {
            this.boxPlotOptions = boxPlotOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return categoryAxis != null ? categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine... referenceLines) {
            referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines) {
            referenceLines(Stream.of(referenceLines).map(c -> ReferenceLine.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        @Override
        public BoxPlotChartConfiguration build() {
            return new BoxPlotChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
