/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata structure for an analysis in Amazon QuickSight
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Analysis implements SdkPojo, Serializable, ToCopyableBuilder<Analysis.Builder, Analysis> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(Analysis::analysisId)).setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Analysis::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Analysis::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Analysis::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<AnalysisError>> ERRORS_FIELD = SdkField
            .<List<AnalysisError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(Analysis::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_SET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataSetArns")
            .getter(getter(Analysis::dataSetArns))
            .setter(setter(Builder::dataSetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(Analysis::themeArn)).setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Analysis::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Analysis::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<List<Sheet>> SHEETS_FIELD = SdkField
            .<List<Sheet>> builder(MarshallingType.LIST)
            .memberName("Sheets")
            .getter(getter(Analysis::sheets))
            .setter(setter(Builder::sheets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sheet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sheet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD, ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, ERRORS_FIELD, DATA_SET_ARNS_FIELD, THEME_ARN_FIELD, CREATED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, SHEETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String analysisId;

    private final String arn;

    private final String name;

    private final String status;

    private final List<AnalysisError> errors;

    private final List<String> dataSetArns;

    private final String themeArn;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final List<Sheet> sheets;

    private Analysis(BuilderImpl builder) {
        this.analysisId = builder.analysisId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.errors = builder.errors;
        this.dataSetArns = builder.dataSetArns;
        this.themeArn = builder.themeArn;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.sheets = builder.sheets;
    }

    /**
     * <p>
     * The ID of the analysis.
     * </p>
     * 
     * @return The ID of the analysis.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the analysis.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The descriptive name of the analysis.
     * </p>
     * 
     * @return The descriptive name of the analysis.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Status associated with the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status associated with the analysis.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Status associated with the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status associated with the analysis.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with the analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Errors associated with the analysis.
     */
    public final List<AnalysisError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSetArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSetArns() {
        return dataSetArns != null && !(dataSetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the datasets of the analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSetArns} method.
     * </p>
     * 
     * @return The ARNs of the datasets of the analysis.
     */
    public final List<String> dataSetArns() {
        return dataSetArns;
    }

    /**
     * <p>
     * The ARN of the theme of the analysis.
     * </p>
     * 
     * @return The ARN of the theme of the analysis.
     */
    public final String themeArn() {
        return themeArn;
    }

    /**
     * <p>
     * The time that the analysis was created.
     * </p>
     * 
     * @return The time that the analysis was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that the analysis was last updated.
     * </p>
     * 
     * @return The time that the analysis was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sheets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSheets() {
        return sheets != null && !(sheets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the associated sheets with the unique identifier and name of each sheet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSheets} method.
     * </p>
     * 
     * @return A list of the associated sheets with the unique identifier and name of each sheet.
     */
    public final List<Sheet> sheets() {
        return sheets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetArns() ? dataSetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSheets() ? sheets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Analysis)) {
            return false;
        }
        Analysis other = (Analysis) obj;
        return Objects.equals(analysisId(), other.analysisId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasDataSetArns() == other.hasDataSetArns() && Objects.equals(dataSetArns(), other.dataSetArns())
                && Objects.equals(themeArn(), other.themeArn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasSheets() == other.hasSheets()
                && Objects.equals(sheets(), other.sheets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Analysis").add("AnalysisId", analysisId()).add("Arn", arn()).add("Name", name())
                .add("Status", statusAsString()).add("Errors", hasErrors() ? errors() : null)
                .add("DataSetArns", hasDataSetArns() ? dataSetArns() : null).add("ThemeArn", themeArn())
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("Sheets", hasSheets() ? sheets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "DataSetArns":
            return Optional.ofNullable(clazz.cast(dataSetArns()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Sheets":
            return Optional.ofNullable(clazz.cast(sheets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Analysis, T> g) {
        return obj -> g.apply((Analysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Analysis> {
        /**
         * <p>
         * The ID of the analysis.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the analysis.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The descriptive name of the analysis.
         * </p>
         * 
         * @param name
         *        The descriptive name of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status associated with the analysis.
         * </p>
         * 
         * @param status
         *        Status associated with the analysis.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status associated with the analysis.
         * </p>
         * 
         * @param status
         *        Status associated with the analysis.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Errors associated with the analysis.
         * </p>
         * 
         * @param errors
         *        Errors associated with the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AnalysisError> errors);

        /**
         * <p>
         * Errors associated with the analysis.
         * </p>
         * 
         * @param errors
         *        Errors associated with the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AnalysisError... errors);

        /**
         * <p>
         * Errors associated with the analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AnalysisError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.AnalysisError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AnalysisError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<AnalysisError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AnalysisError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<AnalysisError>)
         */
        Builder errors(Consumer<AnalysisError.Builder>... errors);

        /**
         * <p>
         * The ARNs of the datasets of the analysis.
         * </p>
         * 
         * @param dataSetArns
         *        The ARNs of the datasets of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArns(Collection<String> dataSetArns);

        /**
         * <p>
         * The ARNs of the datasets of the analysis.
         * </p>
         * 
         * @param dataSetArns
         *        The ARNs of the datasets of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArns(String... dataSetArns);

        /**
         * <p>
         * The ARN of the theme of the analysis.
         * </p>
         * 
         * @param themeArn
         *        The ARN of the theme of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        /**
         * <p>
         * The time that the analysis was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the analysis was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that the analysis was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the analysis was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * A list of the associated sheets with the unique identifier and name of each sheet.
         * </p>
         * 
         * @param sheets
         *        A list of the associated sheets with the unique identifier and name of each sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheets(Collection<Sheet> sheets);

        /**
         * <p>
         * A list of the associated sheets with the unique identifier and name of each sheet.
         * </p>
         * 
         * @param sheets
         *        A list of the associated sheets with the unique identifier and name of each sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheets(Sheet... sheets);

        /**
         * <p>
         * A list of the associated sheets with the unique identifier and name of each sheet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Sheet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Sheet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Sheet.Builder#build()} is called immediately and its
         * result is passed to {@link #sheets(List<Sheet>)}.
         * 
         * @param sheets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Sheet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheets(java.util.Collection<Sheet>)
         */
        Builder sheets(Consumer<Sheet.Builder>... sheets);
    }

    static final class BuilderImpl implements Builder {
        private String analysisId;

        private String arn;

        private String name;

        private String status;

        private List<AnalysisError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataSetArns = DefaultSdkAutoConstructList.getInstance();

        private String themeArn;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private List<Sheet> sheets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Analysis model) {
            analysisId(model.analysisId);
            arn(model.arn);
            name(model.name);
            status(model.status);
            errors(model.errors);
            dataSetArns(model.dataSetArns);
            themeArn(model.themeArn);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            sheets(model.sheets);
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AnalysisError.Builder> getErrors() {
            List<AnalysisError.Builder> result = AnalysisErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AnalysisError.BuilderImpl> errors) {
            this.errors = AnalysisErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AnalysisError> errors) {
            this.errors = AnalysisErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AnalysisError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AnalysisError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AnalysisError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDataSetArns() {
            if (dataSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSetArns;
        }

        public final void setDataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
        }

        @Override
        public final Builder dataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetArns(String... dataSetArns) {
            dataSetArns(Arrays.asList(dataSetArns));
            return this;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<Sheet.Builder> getSheets() {
            List<Sheet.Builder> result = SheetListCopier.copyToBuilder(this.sheets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheets(Collection<Sheet.BuilderImpl> sheets) {
            this.sheets = SheetListCopier.copyFromBuilder(sheets);
        }

        @Override
        public final Builder sheets(Collection<Sheet> sheets) {
            this.sheets = SheetListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Sheet... sheets) {
            sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<Sheet.Builder>... sheets) {
            sheets(Stream.of(sheets).map(c -> Sheet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Analysis build() {
            return new Analysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
