/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.DataSourceSummary;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse;

public class SearchDataSourcesPublisher
implements SdkPublisher<SearchDataSourcesResponse> {
    private final QuickSightAsyncClient client;
    private final SearchDataSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDataSourcesPublisher(QuickSightAsyncClient client, SearchDataSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDataSourcesPublisher(QuickSightAsyncClient client, SearchDataSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDataSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchDataSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSourceSummary> dataSourceSummaries() {
        Function<SearchDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSourceSummaries() != null) {
                return response.dataSourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchDataSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchDataSourcesResponseFetcher
    implements AsyncPageFetcher<SearchDataSourcesResponse> {
        private SearchDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchDataSourcesResponse> nextPage(SearchDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return SearchDataSourcesPublisher.this.client.searchDataSources(SearchDataSourcesPublisher.this.firstRequest);
            }
            return SearchDataSourcesPublisher.this.client.searchDataSources((SearchDataSourcesRequest)((Object)SearchDataSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

