/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FilterVisualScope;
import software.amazon.awssdk.services.quicksight.model.FilteredVisualsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetVisualScopingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetVisualScopingConfiguration> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SheetId").getter(SheetVisualScopingConfiguration.getter(SheetVisualScopingConfiguration::sheetId)).setter(SheetVisualScopingConfiguration.setter(Builder::sheetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(SheetVisualScopingConfiguration.getter(SheetVisualScopingConfiguration::scopeAsString)).setter(SheetVisualScopingConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<List<String>> VISUAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VisualIds").getter(SheetVisualScopingConfiguration.getter(SheetVisualScopingConfiguration::visualIds)).setter(SheetVisualScopingConfiguration.setter(Builder::visualIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD, SCOPE_FIELD, VISUAL_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sheetId;
    private final String scope;
    private final List<String> visualIds;

    private SheetVisualScopingConfiguration(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.scope = builder.scope;
        this.visualIds = builder.visualIds;
    }

    public final String sheetId() {
        return this.sheetId;
    }

    public final FilterVisualScope scope() {
        return FilterVisualScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final boolean hasVisualIds() {
        return this.visualIds != null && !(this.visualIds instanceof SdkAutoConstructList);
    }

    public final List<String> visualIds() {
        return this.visualIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVisualIds() ? this.visualIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetVisualScopingConfiguration)) {
            return false;
        }
        SheetVisualScopingConfiguration other = (SheetVisualScopingConfiguration)obj;
        return Objects.equals(this.sheetId(), other.sheetId()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && this.hasVisualIds() == other.hasVisualIds() && Objects.equals(this.visualIds(), other.visualIds());
    }

    public final String toString() {
        return ToString.builder((String)"SheetVisualScopingConfiguration").add("SheetId", (Object)this.sheetId()).add("Scope", (Object)this.scopeAsString()).add("VisualIds", this.hasVisualIds() ? this.visualIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SheetId": {
                return Optional.ofNullable(clazz.cast(this.sheetId()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "VisualIds": {
                return Optional.ofNullable(clazz.cast(this.visualIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SheetVisualScopingConfiguration, T> g) {
        return obj -> g.apply((SheetVisualScopingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sheetId;
        private String scope;
        private List<String> visualIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SheetVisualScopingConfiguration model) {
            this.sheetId(model.sheetId);
            this.scope(model.scope);
            this.visualIds(model.visualIds);
        }

        public final String getSheetId() {
            return this.sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(FilterVisualScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final Collection<String> getVisualIds() {
            if (this.visualIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.visualIds;
        }

        public final void setVisualIds(Collection<String> visualIds) {
            this.visualIds = FilteredVisualsListCopier.copy(visualIds);
        }

        @Override
        public final Builder visualIds(Collection<String> visualIds) {
            this.visualIds = FilteredVisualsListCopier.copy(visualIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualIds(String ... visualIds) {
            this.visualIds(Arrays.asList(visualIds));
            return this;
        }

        public SheetVisualScopingConfiguration build() {
            return new SheetVisualScopingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetVisualScopingConfiguration> {
        public Builder sheetId(String var1);

        public Builder scope(String var1);

        public Builder scope(FilterVisualScope var1);

        public Builder visualIds(Collection<String> var1);

        public Builder visualIds(String ... var1);
    }
}

