/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentTargetResourceType {
    ENVIRONMENT("ENVIRONMENT"),
    SERVICE_PIPELINE("SERVICE_PIPELINE"),
    SERVICE_INSTANCE("SERVICE_INSTANCE"),
    COMPONENT("COMPONENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentTargetResourceType> VALUE_MAP;
    private final String value;

    private DeploymentTargetResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentTargetResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentTargetResourceType> knownValues() {
        EnumSet<DeploymentTargetResourceType> knownValues = EnumSet.allOf(DeploymentTargetResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentTargetResourceType.class, DeploymentTargetResourceType::toString);
    }
}

