/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.MSKAccessCredentials;
import software.amazon.awssdk.services.pipes.model.MSKStartPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeSourceManagedStreamingKafkaParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeSourceManagedStreamingKafkaParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(PipeSourceManagedStreamingKafkaParameters.getter(PipeSourceManagedStreamingKafkaParameters::batchSize)).setter(PipeSourceManagedStreamingKafkaParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<String> CONSUMER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerGroupID").getter(PipeSourceManagedStreamingKafkaParameters.getter(PipeSourceManagedStreamingKafkaParameters::consumerGroupID)).setter(PipeSourceManagedStreamingKafkaParameters.setter(Builder::consumerGroupID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerGroupID").build()}).build();
    private static final SdkField<MSKAccessCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(PipeSourceManagedStreamingKafkaParameters.getter(PipeSourceManagedStreamingKafkaParameters::credentials)).setter(PipeSourceManagedStreamingKafkaParameters.setter(Builder::credentials)).constructor(MSKAccessCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(PipeSourceManagedStreamingKafkaParameters.getter(PipeSourceManagedStreamingKafkaParameters::maximumBatchingWindowInSeconds)).setter(PipeSourceManagedStreamingKafkaParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(PipeSourceManagedStreamingKafkaParameters.getter(PipeSourceManagedStreamingKafkaParameters::startingPositionAsString)).setter(PipeSourceManagedStreamingKafkaParameters.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(PipeSourceManagedStreamingKafkaParameters.getter(PipeSourceManagedStreamingKafkaParameters::topicName)).setter(PipeSourceManagedStreamingKafkaParameters.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD, CONSUMER_GROUP_ID_FIELD, CREDENTIALS_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, STARTING_POSITION_FIELD, TOPIC_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer batchSize;
    private final String consumerGroupID;
    private final MSKAccessCredentials credentials;
    private final Integer maximumBatchingWindowInSeconds;
    private final String startingPosition;
    private final String topicName;

    private PipeSourceManagedStreamingKafkaParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.consumerGroupID = builder.consumerGroupID;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.startingPosition = builder.startingPosition;
        this.topicName = builder.topicName;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final String consumerGroupID() {
        return this.consumerGroupID;
    }

    public final MSKAccessCredentials credentials() {
        return this.credentials;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final MSKStartPosition startingPosition() {
        return MSKStartPosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final String topicName() {
        return this.topicName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerGroupID());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceManagedStreamingKafkaParameters)) {
            return false;
        }
        PipeSourceManagedStreamingKafkaParameters other = (PipeSourceManagedStreamingKafkaParameters)obj;
        return Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.consumerGroupID(), other.consumerGroupID()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.topicName(), other.topicName());
    }

    public final String toString() {
        return ToString.builder((String)"PipeSourceManagedStreamingKafkaParameters").add("BatchSize", (Object)this.batchSize()).add("ConsumerGroupID", (Object)(this.consumerGroupID() == null ? null : "*** Sensitive Data Redacted ***")).add("Credentials", (Object)this.credentials()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("StartingPosition", (Object)this.startingPositionAsString()).add("TopicName", (Object)(this.topicName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "ConsumerGroupID": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupID()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceManagedStreamingKafkaParameters, T> g) {
        return obj -> g.apply((PipeSourceManagedStreamingKafkaParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer batchSize;
        private String consumerGroupID;
        private MSKAccessCredentials credentials;
        private Integer maximumBatchingWindowInSeconds;
        private String startingPosition;
        private String topicName;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceManagedStreamingKafkaParameters model) {
            this.batchSize(model.batchSize);
            this.consumerGroupID(model.consumerGroupID);
            this.credentials(model.credentials);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.startingPosition(model.startingPosition);
            this.topicName(model.topicName);
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final String getConsumerGroupID() {
            return this.consumerGroupID;
        }

        public final void setConsumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
        }

        @Override
        public final Builder consumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
            return this;
        }

        public final MSKAccessCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(MSKAccessCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(MSKAccessCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(MSKStartPosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public PipeSourceManagedStreamingKafkaParameters build() {
            return new PipeSourceManagedStreamingKafkaParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeSourceManagedStreamingKafkaParameters> {
        public Builder batchSize(Integer var1);

        public Builder consumerGroupID(String var1);

        public Builder credentials(MSKAccessCredentials var1);

        default public Builder credentials(Consumer<MSKAccessCredentials.Builder> credentials) {
            return this.credentials((MSKAccessCredentials)((MSKAccessCredentials.Builder)MSKAccessCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(MSKStartPosition var1);

        public Builder topicName(String var1);
    }
}

