/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneySchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneySchedule> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(JourneySchedule.getter(JourneySchedule::endTime)).setter(JourneySchedule.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(JourneySchedule.getter(JourneySchedule::startTime)).setter(JourneySchedule.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(JourneySchedule.getter(JourneySchedule::timezone)).setter(JourneySchedule.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, START_TIME_FIELD, TIMEZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant endTime;
    private final Instant startTime;
    private final String timezone;

    private JourneySchedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String timezone() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneySchedule)) {
            return false;
        }
        JourneySchedule other = (JourneySchedule)obj;
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.timezone(), other.timezone());
    }

    public final String toString() {
        return ToString.builder((String)"JourneySchedule").add("EndTime", (Object)this.endTime()).add("StartTime", (Object)this.startTime()).add("Timezone", (Object)this.timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneySchedule, T> g) {
        return obj -> g.apply((JourneySchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant endTime;
        private Instant startTime;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneySchedule model) {
            this.endTime(model.endTime);
            this.startTime(model.startTime);
            this.timezone(model.timezone);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public JourneySchedule build() {
            return new JourneySchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneySchedule> {
        public Builder endTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder timezone(String var1);
    }
}

