/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationSettingsRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::applicationId)).setter(UpdateApplicationSettingsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<WriteApplicationSettingsRequest> WRITE_APPLICATION_SETTINGS_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WriteApplicationSettingsRequest").getter(UpdateApplicationSettingsRequest.getter(UpdateApplicationSettingsRequest::writeApplicationSettingsRequest)).setter(UpdateApplicationSettingsRequest.setter(Builder::writeApplicationSettingsRequest)).constructor(WriteApplicationSettingsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteApplicationSettingsRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, WRITE_APPLICATION_SETTINGS_REQUEST_FIELD));
    private final String applicationId;
    private final WriteApplicationSettingsRequest writeApplicationSettingsRequest;

    private UpdateApplicationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeApplicationSettingsRequest = builder.writeApplicationSettingsRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final WriteApplicationSettingsRequest writeApplicationSettingsRequest() {
        return this.writeApplicationSettingsRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeApplicationSettingsRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsRequest)) {
            return false;
        }
        UpdateApplicationSettingsRequest other = (UpdateApplicationSettingsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.writeApplicationSettingsRequest(), other.writeApplicationSettingsRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationSettingsRequest").add("ApplicationId", (Object)this.applicationId()).add("WriteApplicationSettingsRequest", (Object)this.writeApplicationSettingsRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "WriteApplicationSettingsRequest": {
                return Optional.ofNullable(clazz.cast(this.writeApplicationSettingsRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationSettingsRequest, T> g) {
        return obj -> g.apply((UpdateApplicationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteApplicationSettingsRequest writeApplicationSettingsRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.writeApplicationSettingsRequest(model.writeApplicationSettingsRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteApplicationSettingsRequest.Builder getWriteApplicationSettingsRequest() {
            return this.writeApplicationSettingsRequest != null ? this.writeApplicationSettingsRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeApplicationSettingsRequest(WriteApplicationSettingsRequest writeApplicationSettingsRequest) {
            this.writeApplicationSettingsRequest = writeApplicationSettingsRequest;
            return this;
        }

        public final void setWriteApplicationSettingsRequest(WriteApplicationSettingsRequest.BuilderImpl writeApplicationSettingsRequest) {
            this.writeApplicationSettingsRequest = writeApplicationSettingsRequest != null ? writeApplicationSettingsRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationSettingsRequest build() {
            return new UpdateApplicationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
        public Builder applicationId(String var1);

        public Builder writeApplicationSettingsRequest(WriteApplicationSettingsRequest var1);

        default public Builder writeApplicationSettingsRequest(Consumer<WriteApplicationSettingsRequest.Builder> writeApplicationSettingsRequest) {
            return this.writeApplicationSettingsRequest((WriteApplicationSettingsRequest)((WriteApplicationSettingsRequest.Builder)WriteApplicationSettingsRequest.builder().applyMutation(writeApplicationSettingsRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

