/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JWTOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JWTOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(JWTOptionsInput.getter(JWTOptionsInput::enabled)).setter(JWTOptionsInput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectKey").getter(JWTOptionsInput.getter(JWTOptionsInput::subjectKey)).setter(JWTOptionsInput.setter(Builder::subjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()}).build();
    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RolesKey").getter(JWTOptionsInput.getter(JWTOptionsInput::rolesKey)).setter(JWTOptionsInput.setter(Builder::rolesKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(JWTOptionsInput.getter(JWTOptionsInput::publicKey)).setter(JWTOptionsInput.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, PUBLIC_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String subjectKey;
    private final String rolesKey;
    private final String publicKey;

    private JWTOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.publicKey = builder.publicKey;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String subjectKey() {
        return this.subjectKey;
    }

    public final String rolesKey() {
        return this.rolesKey;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolesKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JWTOptionsInput)) {
            return false;
        }
        JWTOptionsInput other = (JWTOptionsInput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.subjectKey(), other.subjectKey()) && Objects.equals(this.rolesKey(), other.rolesKey()) && Objects.equals(this.publicKey(), other.publicKey());
    }

    public final String toString() {
        return ToString.builder((String)"JWTOptionsInput").add("Enabled", (Object)this.enabled()).add("SubjectKey", (Object)this.subjectKey()).add("RolesKey", (Object)this.rolesKey()).add("PublicKey", (Object)this.publicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SubjectKey": {
                return Optional.ofNullable(clazz.cast(this.subjectKey()));
            }
            case "RolesKey": {
                return Optional.ofNullable(clazz.cast(this.rolesKey()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JWTOptionsInput, T> g) {
        return obj -> g.apply((JWTOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String subjectKey;
        private String rolesKey;
        private String publicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(JWTOptionsInput model) {
            this.enabled(model.enabled);
            this.subjectKey(model.subjectKey);
            this.rolesKey(model.rolesKey);
            this.publicKey(model.publicKey);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSubjectKey() {
            return this.subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        public final String getRolesKey() {
            return this.rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public JWTOptionsInput build() {
            return new JWTOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JWTOptionsInput> {
        public Builder enabled(Boolean var1);

        public Builder subjectKey(String var1);

        public Builder rolesKey(String var1);

        public Builder publicKey(String var1);
    }
}

