/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.LaunchProfileState;
import software.amazon.awssdk.services.nimble.model.LaunchProfileStateListCopier;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLaunchProfilesRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, ListLaunchProfilesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListLaunchProfilesRequest.getter(ListLaunchProfilesRequest::maxResults)).setter(ListLaunchProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLaunchProfilesRequest.getter(ListLaunchProfilesRequest::nextToken)).setter(ListLaunchProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(ListLaunchProfilesRequest.getter(ListLaunchProfilesRequest::principalId)).setter(ListLaunchProfilesRequest.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("principalId").build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("states").getter(ListLaunchProfilesRequest.getter(ListLaunchProfilesRequest::statesAsStrings)).setter(ListLaunchProfilesRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(ListLaunchProfilesRequest.getter(ListLaunchProfilesRequest::studioId)).setter(ListLaunchProfilesRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PRINCIPAL_ID_FIELD, STATES_FIELD, STUDIO_ID_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final String principalId;
    private final List<String> states;
    private final String studioId;

    private ListLaunchProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.principalId = builder.principalId;
        this.states = builder.states;
        this.studioId = builder.studioId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final List<LaunchProfileState> states() {
        return LaunchProfileStateListCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchProfilesRequest)) {
            return false;
        }
        ListLaunchProfilesRequest other = (ListLaunchProfilesRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.principalId(), other.principalId()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"ListLaunchProfilesRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("PrincipalId", (Object)this.principalId()).add("States", this.hasStates() ? this.statesAsStrings() : null).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "states": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLaunchProfilesRequest, T> g) {
        return obj -> g.apply((ListLaunchProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String principalId;
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchProfilesRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.principalId(model.principalId);
            this.statesWithStrings(model.states);
            this.studioId(model.studioId);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        public final void setStates(Collection<String> states) {
            this.states = LaunchProfileStateListCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = LaunchProfileStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<LaunchProfileState> states) {
            this.states = LaunchProfileStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(LaunchProfileState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLaunchProfilesRequest build() {
            return new ListLaunchProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLaunchProfilesRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder principalId(String var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<LaunchProfileState> var1);

        public Builder states(LaunchProfileState ... var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

