/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public class SdkHttp2FrameLogger
extends Http2FrameLogger {
    private static final Logger log = LoggerFactory.getLogger(SdkHttp2FrameLogger.class);

    public SdkHttp2FrameLogger(LogLevel level) {
        super(level);
    }

    public void logWindowsUpdate(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        this.log("{} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", direction.name(), streamId, windowSizeIncrement);
    }

    public void logGoAway(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        this.log("{} GO_AWAY: lastStreamId={} errorCode={} length={}\n{}", direction.name(), lastStreamId, errorCode, debugData.readableBytes(), this.dataToString(direction, debugData));
    }

    public void logSettings(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        this.log("{} SETTINGS: ack=false settings={}", direction.name(), settings);
    }

    public void logPing(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, long data) {
        this.log("{} PING: ack=false length={}", direction.name(), data);
    }

    public void logPingAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, long data) {
        this.log("{} PING: ack=true length={}\n{}", direction.name(), data);
    }

    public void logPriority(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        this.log("{} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", direction.name(), streamId, streamDependency, weight, exclusive);
    }

    public void logRstStream(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        this.log("{} RST_STREAM: streamId={} errorCode={}", direction.name(), streamId, errorCode);
    }

    public void logUnknownFrame(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        this.log("{} UNKNOWN: frameType={} streamId={} flags={} length={}\n{}", direction.name(), frameType & 0xFF, streamId, flags.value(), data.readableBytes(), this.dataToString(direction, data));
    }

    public void logPushPromise(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        this.log("{} PUSH_PROMISE: streamId={} promisedStreamId={} padding={}\n{}", direction.name(), streamId, promisedStreamId, padding, this.formatHeaders(direction, headers));
    }

    public void logSettingsAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx) {
        this.log("{} SETTINGS: ack=true", direction.name());
    }

    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        this.log("{} HEADERS: streamId={} padding={} endStream={}\n{}", direction.name(), streamId, padding, endStream, this.formatHeaders(direction, headers));
    }

    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        this.log("{} HEADERS: streamId={} streamDependency={} weight={} exclusive={} padding={} endStream={}\n{}", direction.name(), streamId, streamDependency, weight, exclusive, padding, endStream, this.formatHeaders(direction, headers));
    }

    private String formatHeaders(Http2FrameLogger.Direction direction, Http2Headers headers) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(headers.iterator(), 16), false).map(h -> String.format("%s %s: %s", this.indentArrow(direction), h.getKey(), h.getValue())).collect(Collectors.joining("\n"));
    }

    private String indentArrow(Http2FrameLogger.Direction direction) {
        if (direction == Http2FrameLogger.Direction.INBOUND) {
            return "\t\t<<";
        }
        return "\t\t>>";
    }

    public void logData(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (log.isTraceEnabled()) {
            log.trace("{} DATA: streamId={} padding={} endStream={} length={}\n{}", new Object[]{direction, streamId, padding, endStream, data.nioBuffer().remaining(), this.dataToString(direction, data)});
        } else {
            this.log("{} DATA: streamId={} padding={} endStream={} length={}\n", direction, streamId, padding, endStream, data.nioBuffer().remaining());
        }
    }

    private void log(String msg, Object ... args) {
        log.debug(msg, args);
    }

    private String dataToString(Http2FrameLogger.Direction direction, ByteBuf data) {
        return this.indentArrow(direction) + " " + new String(BinaryUtils.copyBytesFrom((ByteBuffer)data.nioBuffer()), StandardCharsets.UTF_8);
    }

    public static Optional<Http2FrameLogger> frameLogger() {
        return log.isDebugEnabled() ? Optional.of(new SdkHttp2FrameLogger(LogLevel.DEBUG)) : Optional.empty();
    }
}

