/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.http2.Http2MultiplexedChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.utils.BetterFixedChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;

@SdkInternalApi
public class HttpOrHttp2ChannelPool
implements ChannelPool {
    private final ChannelPool simpleChannelPool;
    private final int maxConcurrency;
    private final EventLoop eventLoop;
    private final NettyConfiguration configuration;
    private Promise<ChannelPool> protocolImplPromise;
    private ChannelPool protocolImpl;

    public HttpOrHttp2ChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, int maxConcurrency, NettyConfiguration configuration) {
        this.simpleChannelPool = new SimpleChannelPool(bootstrap, handler);
        this.maxConcurrency = maxConcurrency;
        this.eventLoop = bootstrap.config().group().next();
        this.configuration = configuration;
    }

    public Future<Channel> acquire() {
        return this.acquire((Promise<Channel>)new DefaultPromise((EventExecutor)this.eventLoop));
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.acquire0(promise), promise);
        return promise;
    }

    private void acquire0(Promise<Channel> promise) {
        if (this.protocolImpl != null) {
            this.protocolImpl.acquire(promise);
            return;
        }
        if (this.protocolImplPromise == null) {
            this.initializeProtocol();
        }
        this.protocolImplPromise.addListener(future -> {
            if (future.isSuccess()) {
                ((ChannelPool)future.getNow()).acquire(promise);
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    private void initializeProtocol() {
        this.protocolImplPromise = new DefaultPromise((EventExecutor)this.eventLoop);
        this.simpleChannelPool.acquire().addListener(future -> {
            if (future.isSuccess()) {
                Channel newChannel = (Channel)future.getNow();
                ((CompletableFuture)newChannel.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).whenComplete((r, e) -> {
                    if (e != null) {
                        this.failProtocolImplPromise((Throwable)e);
                    } else {
                        this.protocolImplPromise.setSuccess((Object)this.configureProtocol(newChannel, (Protocol)r));
                    }
                });
            } else {
                this.failProtocolImplPromise(future.cause());
            }
        });
    }

    private void failProtocolImplPromise(Throwable e) {
        this.protocolImplPromise.setFailure(e);
        this.protocolImplPromise = null;
    }

    private ChannelPool configureProtocol(Channel newChannel, Protocol protocol) {
        if (Protocol.HTTP1_1 == protocol) {
            this.protocolImpl = BetterFixedChannelPool.builder().channelPool(this.simpleChannelPool).executor((EventExecutor)this.eventLoop).acquireTimeoutAction(BetterFixedChannelPool.AcquireTimeoutAction.FAIL).acquireTimeoutMillis(this.configuration.connectionAcquireTimeoutMillis()).maxConnections(this.maxConcurrency).maxPendingAcquires(this.configuration.maxPendingConnectionAcquires()).build();
        } else {
            Http2MultiplexedChannelPool h2Pool = new Http2MultiplexedChannelPool(this.simpleChannelPool, this.eventLoop, (Long)newChannel.attr(ChannelAttributeKey.MAX_CONCURRENT_STREAMS).get());
            this.protocolImpl = BetterFixedChannelPool.builder().channelPool(h2Pool).executor((EventExecutor)this.eventLoop).acquireTimeoutAction(BetterFixedChannelPool.AcquireTimeoutAction.FAIL).acquireTimeoutMillis(this.configuration.connectionAcquireTimeoutMillis()).maxConnections(this.maxConcurrency).maxPendingAcquires(this.configuration.maxPendingConnectionAcquires()).build();
        }
        this.simpleChannelPool.release(newChannel);
        return this.protocolImpl;
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)this.eventLoop.newPromise());
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.release0(channel, promise), promise);
        return promise;
    }

    private void release0(Channel channel, Promise<Void> promise) {
        if (this.protocolImpl == null) {
            this.simpleChannelPool.release(channel, promise);
        } else {
            this.protocolImpl.release(channel, promise);
        }
    }

    public void close() {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> ((ChannelPool)this.protocolImpl).close());
    }
}

