/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessorRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<CreateAccessorRequest.Builder, CreateAccessorRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateAccessorRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ACCESSOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessorType").getter(getter(CreateAccessorRequest::accessorTypeAsString))
            .setter(setter(Builder::accessorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessorType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAccessorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            ACCESSOR_TYPE_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final String accessorType;

    private final Map<String, String> tags;

    private CreateAccessorRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.accessorType = builder.accessorType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     * idempotent operation completes no more than once. This identifier is required only if you make a service request
     * directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the Amazon
     * Web Services CLI.
     * </p>
     * 
     * @return This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation.
     *         An idempotent operation completes no more than once. This identifier is required only if you make a
     *         service request directly using an HTTP client. It is generated automatically if you use an Amazon Web
     *         Services SDK or the Amazon Web Services CLI.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The type of accessor.
     * </p>
     * <note>
     * <p>
     * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessorType} will
     * return {@link AccessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessorTypeAsString}.
     * </p>
     * 
     * @return The type of accessor.</p> <note>
     *         <p>
     *         Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     *         </p>
     * @see AccessorType
     */
    public final AccessorType accessorType() {
        return AccessorType.fromValue(accessorType);
    }

    /**
     * <p>
     * The type of accessor.
     * </p>
     * <note>
     * <p>
     * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessorType} will
     * return {@link AccessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessorTypeAsString}.
     * </p>
     * 
     * @return The type of accessor.</p> <note>
     *         <p>
     *         Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
     *         </p>
     * @see AccessorType
     */
    public final String accessorTypeAsString() {
        return accessorType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to assign to the Accessor.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request
     * with an overall maximum of 50 tags allowed per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the Accessor.</p>
     *         <p>
     *         Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single
     *         request with an overall maximum of 50 tags allowed per resource.
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     *         Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
     *         "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     *         >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessorRequest)) {
            return false;
        }
        CreateAccessorRequest other = (CreateAccessorRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(accessorTypeAsString(), other.accessorTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessorRequest").add("ClientRequestToken", clientRequestToken())
                .add("AccessorType", accessorTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "AccessorType":
            return Optional.ofNullable(clazz.cast(accessorTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessorRequest, T> g) {
        return obj -> g.apply((CreateAccessorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessorRequest> {
        /**
         * <p>
         * This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than once. This identifier is required only if you make a service
         * request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or
         * the Amazon Web Services CLI.
         * </p>
         * 
         * @param clientRequestToken
         *        This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the
         *        operation. An idempotent operation completes no more than once. This identifier is required only if
         *        you make a service request directly using an HTTP client. It is generated automatically if you use an
         *        Amazon Web Services SDK or the Amazon Web Services CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The type of accessor.
         * </p>
         * <note>
         * <p>
         * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         * </p>
         * </note>
         * 
         * @param accessorType
         *        The type of accessor.</p> <note>
         *        <p>
         *        Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         *        </p>
         * @see AccessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorType
         */
        Builder accessorType(String accessorType);

        /**
         * <p>
         * The type of accessor.
         * </p>
         * <note>
         * <p>
         * Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         * </p>
         * </note>
         * 
         * @param accessorType
         *        The type of accessor.</p> <note>
         *        <p>
         *        Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.
         *        </p>
         * @see AccessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorType
         */
        Builder accessorType(AccessorType accessorType);

        /**
         * <p>
         * Tags to assign to the Accessor.
         * </p>
         * <p>
         * Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single
         * request with an overall maximum of 50 tags allowed per resource.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
         * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the Accessor.</p>
         *        <p>
         *        Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single
         *        request with an overall maximum of 50 tags allowed per resource.
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
         *        "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String accessorType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessorRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            accessorType(model.accessorType);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getAccessorType() {
            return accessorType;
        }

        public final void setAccessorType(String accessorType) {
            this.accessorType = accessorType;
        }

        @Override
        public final Builder accessorType(String accessorType) {
            this.accessorType = accessorType;
            return this;
        }

        @Override
        public final Builder accessorType(AccessorType accessorType) {
            this.accessorType(accessorType == null ? null : accessorType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessorRequest build() {
            return new CreateAccessorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
