/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie.MacieAsyncClient;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse;

public class ListMemberAccountsPublisher
implements SdkPublisher<ListMemberAccountsResponse> {
    private final MacieAsyncClient client;
    private final ListMemberAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMemberAccountsPublisher(MacieAsyncClient client, ListMemberAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMemberAccountsPublisher(MacieAsyncClient client, ListMemberAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMemberAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMemberAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMemberAccountsResponseFetcher
    implements AsyncPageFetcher<ListMemberAccountsResponse> {
        private ListMemberAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemberAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMemberAccountsResponse> nextPage(ListMemberAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListMemberAccountsPublisher.this.client.listMemberAccounts(ListMemberAccountsPublisher.this.firstRequest);
            }
            return ListMemberAccountsPublisher.this.client.listMemberAccounts((ListMemberAccountsRequest)((Object)ListMemberAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

