/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie.model.MacieResponse;
import software.amazon.awssdk.services.macie.model.S3ResourceClassification;
import software.amazon.awssdk.services.macie.model.S3ResourcesClassificationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListS3ResourcesResponse
extends MacieResponse
implements ToCopyableBuilder<Builder, ListS3ResourcesResponse> {
    private static final SdkField<List<S3ResourceClassification>> S3_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Resources").getter(ListS3ResourcesResponse.getter(ListS3ResourcesResponse::s3Resources)).setter(ListS3ResourcesResponse.setter(Builder::s3Resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3ResourceClassification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListS3ResourcesResponse.getter(ListS3ResourcesResponse::nextToken)).setter(ListS3ResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<S3ResourceClassification> s3Resources;
    private final String nextToken;

    private ListS3ResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.s3Resources = builder.s3Resources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasS3Resources() {
        return this.s3Resources != null && !(this.s3Resources instanceof SdkAutoConstructList);
    }

    public final List<S3ResourceClassification> s3Resources() {
        return this.s3Resources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Resources() ? this.s3Resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3ResourcesResponse)) {
            return false;
        }
        ListS3ResourcesResponse other = (ListS3ResourcesResponse)((Object)obj);
        return this.hasS3Resources() == other.hasS3Resources() && Objects.equals(this.s3Resources(), other.s3Resources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListS3ResourcesResponse").add("S3Resources", this.hasS3Resources() ? this.s3Resources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Resources": {
                return Optional.ofNullable(clazz.cast(this.s3Resources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListS3ResourcesResponse, T> g) {
        return obj -> g.apply((ListS3ResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MacieResponse.BuilderImpl
    implements Builder {
        private List<S3ResourceClassification> s3Resources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListS3ResourcesResponse model) {
            super(model);
            this.s3Resources(model.s3Resources);
            this.nextToken(model.nextToken);
        }

        public final List<S3ResourceClassification.Builder> getS3Resources() {
            List<S3ResourceClassification.Builder> result = S3ResourcesClassificationCopier.copyToBuilder(this.s3Resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Resources(Collection<S3ResourceClassification.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copyFromBuilder(s3Resources);
        }

        @Override
        public final Builder s3Resources(Collection<S3ResourceClassification> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3ResourceClassification ... s3Resources) {
            this.s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3ResourceClassification.Builder> ... s3Resources) {
            this.s3Resources(Stream.of(s3Resources).map(c -> (S3ResourceClassification)((S3ResourceClassification.Builder)S3ResourceClassification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListS3ResourcesResponse build() {
            return new ListS3ResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MacieResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListS3ResourcesResponse> {
        public Builder s3Resources(Collection<S3ResourceClassification> var1);

        public Builder s3Resources(S3ResourceClassification ... var1);

        public Builder s3Resources(Consumer<S3ResourceClassification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

