/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiskSnapshotState {
    PENDING("pending"),
    COMPLETED("completed"),
    ERROR("error"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiskSnapshotState> VALUE_MAP;
    private final String value;

    private DiskSnapshotState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiskSnapshotState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiskSnapshotState> knownValues() {
        EnumSet<DiskSnapshotState> knownValues = EnumSet.allOf(DiskSnapshotState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiskSnapshotState.class, DiskSnapshotState::toString);
    }
}

