/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisionedConcurrencyConfigsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListProvisionedConcurrencyConfigsResponse.Builder, ListProvisionedConcurrencyConfigsResponse> {
    private static final SdkField<List<ProvisionedConcurrencyConfigListItem>> PROVISIONED_CONCURRENCY_CONFIGS_FIELD = SdkField
            .<List<ProvisionedConcurrencyConfigListItem>> builder(MarshallingType.LIST)
            .memberName("ProvisionedConcurrencyConfigs")
            .getter(getter(ListProvisionedConcurrencyConfigsResponse::provisionedConcurrencyConfigs))
            .setter(setter(Builder::provisionedConcurrencyConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedConcurrencyConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisionedConcurrencyConfigListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisionedConcurrencyConfigListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListProvisionedConcurrencyConfigsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONED_CONCURRENCY_CONFIGS_FIELD, NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs;

    private final String nextMarker;

    private ListProvisionedConcurrencyConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedConcurrencyConfigs = builder.provisionedConcurrencyConfigs;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedConcurrencyConfigs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisionedConcurrencyConfigs() {
        return provisionedConcurrencyConfigs != null && !(provisionedConcurrencyConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of provisioned concurrency configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedConcurrencyConfigs} method.
     * </p>
     * 
     * @return A list of provisioned concurrency configurations.
     */
    public final List<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs() {
        return provisionedConcurrencyConfigs;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedConcurrencyConfigs() ? provisionedConcurrencyConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedConcurrencyConfigsResponse)) {
            return false;
        }
        ListProvisionedConcurrencyConfigsResponse other = (ListProvisionedConcurrencyConfigsResponse) obj;
        return hasProvisionedConcurrencyConfigs() == other.hasProvisionedConcurrencyConfigs()
                && Objects.equals(provisionedConcurrencyConfigs(), other.provisionedConcurrencyConfigs())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListProvisionedConcurrencyConfigsResponse")
                .add("ProvisionedConcurrencyConfigs", hasProvisionedConcurrencyConfigs() ? provisionedConcurrencyConfigs() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedConcurrencyConfigs":
            return Optional.ofNullable(clazz.cast(provisionedConcurrencyConfigs()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProvisionedConcurrencyConfigs", PROVISIONED_CONCURRENCY_CONFIGS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedConcurrencyConfigsResponse, T> g) {
        return obj -> g.apply((ListProvisionedConcurrencyConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisionedConcurrencyConfigsResponse> {
        /**
         * <p>
         * A list of provisioned concurrency configurations.
         * </p>
         * 
         * @param provisionedConcurrencyConfigs
         *        A list of provisioned concurrency configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedConcurrencyConfigs(Collection<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs);

        /**
         * <p>
         * A list of provisioned concurrency configurations.
         * </p>
         * 
         * @param provisionedConcurrencyConfigs
         *        A list of provisioned concurrency configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedConcurrencyConfigs(ProvisionedConcurrencyConfigListItem... provisionedConcurrencyConfigs);

        /**
         * <p>
         * A list of provisioned concurrency configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisionedConcurrencyConfigs(List<ProvisionedConcurrencyConfigListItem>)}.
         * 
         * @param provisionedConcurrencyConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedConcurrencyConfigs(java.util.Collection<ProvisionedConcurrencyConfigListItem>)
         */
        Builder provisionedConcurrencyConfigs(
                Consumer<ProvisionedConcurrencyConfigListItem.Builder>... provisionedConcurrencyConfigs);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private List<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs = DefaultSdkAutoConstructList
                .getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedConcurrencyConfigsResponse model) {
            super(model);
            provisionedConcurrencyConfigs(model.provisionedConcurrencyConfigs);
            nextMarker(model.nextMarker);
        }

        public final List<ProvisionedConcurrencyConfigListItem.Builder> getProvisionedConcurrencyConfigs() {
            List<ProvisionedConcurrencyConfigListItem.Builder> result = ProvisionedConcurrencyConfigListCopier
                    .copyToBuilder(this.provisionedConcurrencyConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedConcurrencyConfigs(
                Collection<ProvisionedConcurrencyConfigListItem.BuilderImpl> provisionedConcurrencyConfigs) {
            this.provisionedConcurrencyConfigs = ProvisionedConcurrencyConfigListCopier
                    .copyFromBuilder(provisionedConcurrencyConfigs);
        }

        @Override
        public final Builder provisionedConcurrencyConfigs(
                Collection<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs) {
            this.provisionedConcurrencyConfigs = ProvisionedConcurrencyConfigListCopier.copy(provisionedConcurrencyConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedConcurrencyConfigs(ProvisionedConcurrencyConfigListItem... provisionedConcurrencyConfigs) {
            provisionedConcurrencyConfigs(Arrays.asList(provisionedConcurrencyConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedConcurrencyConfigs(
                Consumer<ProvisionedConcurrencyConfigListItem.Builder>... provisionedConcurrencyConfigs) {
            provisionedConcurrencyConfigs(Stream.of(provisionedConcurrencyConfigs)
                    .map(c -> ProvisionedConcurrencyConfigListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListProvisionedConcurrencyConfigsResponse build() {
            return new ListProvisionedConcurrencyConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
