/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionUrlConfigsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListFunctionUrlConfigsResponse.Builder, ListFunctionUrlConfigsResponse> {
    private static final SdkField<List<FunctionUrlConfig>> FUNCTION_URL_CONFIGS_FIELD = SdkField
            .<List<FunctionUrlConfig>> builder(MarshallingType.LIST)
            .memberName("FunctionUrlConfigs")
            .getter(getter(ListFunctionUrlConfigsResponse::functionUrlConfigs))
            .setter(setter(Builder::functionUrlConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionUrlConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FunctionUrlConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionUrlConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListFunctionUrlConfigsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_URL_CONFIGS_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FunctionUrlConfig> functionUrlConfigs;

    private final String nextMarker;

    private ListFunctionUrlConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.functionUrlConfigs = builder.functionUrlConfigs;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionUrlConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionUrlConfigs() {
        return functionUrlConfigs != null && !(functionUrlConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of function URL configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionUrlConfigs} method.
     * </p>
     * 
     * @return A list of function URL configurations.
     */
    public final List<FunctionUrlConfig> functionUrlConfigs() {
        return functionUrlConfigs;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionUrlConfigs() ? functionUrlConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionUrlConfigsResponse)) {
            return false;
        }
        ListFunctionUrlConfigsResponse other = (ListFunctionUrlConfigsResponse) obj;
        return hasFunctionUrlConfigs() == other.hasFunctionUrlConfigs()
                && Objects.equals(functionUrlConfigs(), other.functionUrlConfigs())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFunctionUrlConfigsResponse")
                .add("FunctionUrlConfigs", hasFunctionUrlConfigs() ? functionUrlConfigs() : null).add("NextMarker", nextMarker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionUrlConfigs":
            return Optional.ofNullable(clazz.cast(functionUrlConfigs()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionUrlConfigs", FUNCTION_URL_CONFIGS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionUrlConfigsResponse, T> g) {
        return obj -> g.apply((ListFunctionUrlConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFunctionUrlConfigsResponse> {
        /**
         * <p>
         * A list of function URL configurations.
         * </p>
         * 
         * @param functionUrlConfigs
         *        A list of function URL configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionUrlConfigs(Collection<FunctionUrlConfig> functionUrlConfigs);

        /**
         * <p>
         * A list of function URL configurations.
         * </p>
         * 
         * @param functionUrlConfigs
         *        A list of function URL configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionUrlConfigs(FunctionUrlConfig... functionUrlConfigs);

        /**
         * <p>
         * A list of function URL configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.FunctionUrlConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lambda.model.FunctionUrlConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.FunctionUrlConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #functionUrlConfigs(List<FunctionUrlConfig>)}.
         * 
         * @param functionUrlConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.FunctionUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionUrlConfigs(java.util.Collection<FunctionUrlConfig>)
         */
        Builder functionUrlConfigs(Consumer<FunctionUrlConfig.Builder>... functionUrlConfigs);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private List<FunctionUrlConfig> functionUrlConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionUrlConfigsResponse model) {
            super(model);
            functionUrlConfigs(model.functionUrlConfigs);
            nextMarker(model.nextMarker);
        }

        public final List<FunctionUrlConfig.Builder> getFunctionUrlConfigs() {
            List<FunctionUrlConfig.Builder> result = FunctionUrlConfigListCopier.copyToBuilder(this.functionUrlConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionUrlConfigs(Collection<FunctionUrlConfig.BuilderImpl> functionUrlConfigs) {
            this.functionUrlConfigs = FunctionUrlConfigListCopier.copyFromBuilder(functionUrlConfigs);
        }

        @Override
        public final Builder functionUrlConfigs(Collection<FunctionUrlConfig> functionUrlConfigs) {
            this.functionUrlConfigs = FunctionUrlConfigListCopier.copy(functionUrlConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionUrlConfigs(FunctionUrlConfig... functionUrlConfigs) {
            functionUrlConfigs(Arrays.asList(functionUrlConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionUrlConfigs(Consumer<FunctionUrlConfig.Builder>... functionUrlConfigs) {
            functionUrlConfigs(Stream.of(functionUrlConfigs).map(c -> FunctionUrlConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListFunctionUrlConfigsResponse build() {
            return new ListFunctionUrlConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
