/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.Architecture;
import software.amazon.awssdk.services.lambda.model.ArchitecturesListCopier;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.EnvironmentResponse;
import software.amazon.awssdk.services.lambda.model.EphemeralStorage;
import software.amazon.awssdk.services.lambda.model.FileSystemConfig;
import software.amazon.awssdk.services.lambda.model.FileSystemConfigListCopier;
import software.amazon.awssdk.services.lambda.model.ImageConfigResponse;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.LastUpdateStatus;
import software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode;
import software.amazon.awssdk.services.lambda.model.Layer;
import software.amazon.awssdk.services.lambda.model.LayersReferenceListCopier;
import software.amazon.awssdk.services.lambda.model.LoggingConfig;
import software.amazon.awssdk.services.lambda.model.PackageType;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.RuntimeVersionConfig;
import software.amazon.awssdk.services.lambda.model.SnapStartResponse;
import software.amazon.awssdk.services.lambda.model.State;
import software.amazon.awssdk.services.lambda.model.StateReasonCode;
import software.amazon.awssdk.services.lambda.model.TracingConfigResponse;
import software.amazon.awssdk.services.lambda.model.VpcConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFunctionResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, CreateFunctionResponse> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(CreateFunctionResponse.getter(CreateFunctionResponse::functionName)).setter(CreateFunctionResponse.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(CreateFunctionResponse.getter(CreateFunctionResponse::functionArn)).setter(CreateFunctionResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Runtime").getter(CreateFunctionResponse.getter(CreateFunctionResponse::runtimeAsString)).setter(CreateFunctionResponse.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateFunctionResponse.getter(CreateFunctionResponse::role)).setter(CreateFunctionResponse.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(CreateFunctionResponse.getter(CreateFunctionResponse::handler)).setter(CreateFunctionResponse.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeSize").getter(CreateFunctionResponse.getter(CreateFunctionResponse::codeSize)).setter(CreateFunctionResponse.setter(Builder::codeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFunctionResponse.getter(CreateFunctionResponse::description)).setter(CreateFunctionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(CreateFunctionResponse.getter(CreateFunctionResponse::timeout)).setter(CreateFunctionResponse.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySize").getter(CreateFunctionResponse.getter(CreateFunctionResponse::memorySize)).setter(CreateFunctionResponse.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(CreateFunctionResponse.getter(CreateFunctionResponse::lastModified)).setter(CreateFunctionResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSha256").getter(CreateFunctionResponse.getter(CreateFunctionResponse::codeSha256)).setter(CreateFunctionResponse.setter(Builder::codeSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(CreateFunctionResponse.getter(CreateFunctionResponse::version)).setter(CreateFunctionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<VpcConfigResponse> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateFunctionResponse.getter(CreateFunctionResponse::vpcConfig)).setter(CreateFunctionResponse.setter(Builder::vpcConfig)).constructor(VpcConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(CreateFunctionResponse.getter(CreateFunctionResponse::deadLetterConfig)).setter(CreateFunctionResponse.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<EnvironmentResponse> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(CreateFunctionResponse.getter(CreateFunctionResponse::environment)).setter(CreateFunctionResponse.setter(Builder::environment)).constructor(EnvironmentResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyArn").getter(CreateFunctionResponse.getter(CreateFunctionResponse::kmsKeyArn)).setter(CreateFunctionResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final SdkField<TracingConfigResponse> TRACING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TracingConfig").getter(CreateFunctionResponse.getter(CreateFunctionResponse::tracingConfig)).setter(CreateFunctionResponse.setter(Builder::tracingConfig)).constructor(TracingConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()}).build();
    private static final SdkField<String> MASTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterArn").getter(CreateFunctionResponse.getter(CreateFunctionResponse::masterArn)).setter(CreateFunctionResponse.setter(Builder::masterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterArn").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(CreateFunctionResponse.getter(CreateFunctionResponse::revisionId)).setter(CreateFunctionResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layers").getter(CreateFunctionResponse.getter(CreateFunctionResponse::layers)).setter(CreateFunctionResponse.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Layer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateFunctionResponse.getter(CreateFunctionResponse::stateAsString)).setter(CreateFunctionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(CreateFunctionResponse.getter(CreateFunctionResponse::stateReason)).setter(CreateFunctionResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> STATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReasonCode").getter(CreateFunctionResponse.getter(CreateFunctionResponse::stateReasonCodeAsString)).setter(CreateFunctionResponse.setter(Builder::stateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonCode").build()}).build();
    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdateStatus").getter(CreateFunctionResponse.getter(CreateFunctionResponse::lastUpdateStatusAsString)).setter(CreateFunctionResponse.setter(Builder::lastUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()}).build();
    private static final SdkField<String> LAST_UPDATE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdateStatusReason").getter(CreateFunctionResponse.getter(CreateFunctionResponse::lastUpdateStatusReason)).setter(CreateFunctionResponse.setter(Builder::lastUpdateStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatusReason").build()}).build();
    private static final SdkField<String> LAST_UPDATE_STATUS_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdateStatusReasonCode").getter(CreateFunctionResponse.getter(CreateFunctionResponse::lastUpdateStatusReasonCodeAsString)).setter(CreateFunctionResponse.setter(Builder::lastUpdateStatusReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatusReasonCode").build()}).build();
    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemConfigs").getter(CreateFunctionResponse.getter(CreateFunctionResponse::fileSystemConfigs)).setter(CreateFunctionResponse.setter(Builder::fileSystemConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(CreateFunctionResponse.getter(CreateFunctionResponse::packageTypeAsString)).setter(CreateFunctionResponse.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<ImageConfigResponse> IMAGE_CONFIG_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfigResponse").getter(CreateFunctionResponse.getter(CreateFunctionResponse::imageConfigResponse)).setter(CreateFunctionResponse.setter(Builder::imageConfigResponse)).constructor(ImageConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfigResponse").build()}).build();
    private static final SdkField<String> SIGNING_PROFILE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningProfileVersionArn").getter(CreateFunctionResponse.getter(CreateFunctionResponse::signingProfileVersionArn)).setter(CreateFunctionResponse.setter(Builder::signingProfileVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProfileVersionArn").build()}).build();
    private static final SdkField<String> SIGNING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningJobArn").getter(CreateFunctionResponse.getter(CreateFunctionResponse::signingJobArn)).setter(CreateFunctionResponse.setter(Builder::signingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningJobArn").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Architectures").getter(CreateFunctionResponse.getter(CreateFunctionResponse::architecturesAsStrings)).setter(CreateFunctionResponse.setter(Builder::architecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EphemeralStorage").getter(CreateFunctionResponse.getter(CreateFunctionResponse::ephemeralStorage)).setter(CreateFunctionResponse.setter(Builder::ephemeralStorage)).constructor(EphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").build()}).build();
    private static final SdkField<SnapStartResponse> SNAP_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapStart").getter(CreateFunctionResponse.getter(CreateFunctionResponse::snapStart)).setter(CreateFunctionResponse.setter(Builder::snapStart)).constructor(SnapStartResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapStart").build()}).build();
    private static final SdkField<RuntimeVersionConfig> RUNTIME_VERSION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeVersionConfig").getter(CreateFunctionResponse.getter(CreateFunctionResponse::runtimeVersionConfig)).setter(CreateFunctionResponse.setter(Builder::runtimeVersionConfig)).constructor(RuntimeVersionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionConfig").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfig").getter(CreateFunctionResponse.getter(CreateFunctionResponse::loggingConfig)).setter(CreateFunctionResponse.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, FUNCTION_ARN_FIELD, RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_SIZE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD, LAST_MODIFIED_FIELD, CODE_SHA256_FIELD, VERSION_FIELD, VPC_CONFIG_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, MASTER_ARN_FIELD, REVISION_ID_FIELD, LAYERS_FIELD, STATE_FIELD, STATE_REASON_FIELD, STATE_REASON_CODE_FIELD, LAST_UPDATE_STATUS_FIELD, LAST_UPDATE_STATUS_REASON_FIELD, LAST_UPDATE_STATUS_REASON_CODE_FIELD, FILE_SYSTEM_CONFIGS_FIELD, PACKAGE_TYPE_FIELD, IMAGE_CONFIG_RESPONSE_FIELD, SIGNING_PROFILE_VERSION_ARN_FIELD, SIGNING_JOB_ARN_FIELD, ARCHITECTURES_FIELD, EPHEMERAL_STORAGE_FIELD, SNAP_START_FIELD, RUNTIME_VERSION_CONFIG_FIELD, LOGGING_CONFIG_FIELD));
    private final String functionName;
    private final String functionArn;
    private final String runtime;
    private final String role;
    private final String handler;
    private final Long codeSize;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final String lastModified;
    private final String codeSha256;
    private final String version;
    private final VpcConfigResponse vpcConfig;
    private final DeadLetterConfig deadLetterConfig;
    private final EnvironmentResponse environment;
    private final String kmsKeyArn;
    private final TracingConfigResponse tracingConfig;
    private final String masterArn;
    private final String revisionId;
    private final List<Layer> layers;
    private final String state;
    private final String stateReason;
    private final String stateReasonCode;
    private final String lastUpdateStatus;
    private final String lastUpdateStatusReason;
    private final String lastUpdateStatusReasonCode;
    private final List<FileSystemConfig> fileSystemConfigs;
    private final String packageType;
    private final ImageConfigResponse imageConfigResponse;
    private final String signingProfileVersionArn;
    private final String signingJobArn;
    private final List<String> architectures;
    private final EphemeralStorage ephemeralStorage;
    private final SnapStartResponse snapStart;
    private final RuntimeVersionConfig runtimeVersionConfig;
    private final LoggingConfig loggingConfig;

    private CreateFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.functionArn = builder.functionArn;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.codeSize = builder.codeSize;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.lastModified = builder.lastModified;
        this.codeSha256 = builder.codeSha256;
        this.version = builder.version;
        this.vpcConfig = builder.vpcConfig;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.masterArn = builder.masterArn;
        this.revisionId = builder.revisionId;
        this.layers = builder.layers;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.stateReasonCode = builder.stateReasonCode;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.lastUpdateStatusReason = builder.lastUpdateStatusReason;
        this.lastUpdateStatusReasonCode = builder.lastUpdateStatusReasonCode;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.packageType = builder.packageType;
        this.imageConfigResponse = builder.imageConfigResponse;
        this.signingProfileVersionArn = builder.signingProfileVersionArn;
        this.signingJobArn = builder.signingJobArn;
        this.architectures = builder.architectures;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.snapStart = builder.snapStart;
        this.runtimeVersionConfig = builder.runtimeVersionConfig;
        this.loggingConfig = builder.loggingConfig;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String role() {
        return this.role;
    }

    public final String handler() {
        return this.handler;
    }

    public final Long codeSize() {
        return this.codeSize;
    }

    public final String description() {
        return this.description;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer memorySize() {
        return this.memorySize;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public final String codeSha256() {
        return this.codeSha256;
    }

    public final String version() {
        return this.version;
    }

    public final VpcConfigResponse vpcConfig() {
        return this.vpcConfig;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final EnvironmentResponse environment() {
        return this.environment;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final TracingConfigResponse tracingConfig() {
        return this.tracingConfig;
    }

    public final String masterArn() {
        return this.masterArn;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<Layer> layers() {
        return this.layers;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final StateReasonCode stateReasonCode() {
        return StateReasonCode.fromValue(this.stateReasonCode);
    }

    public final String stateReasonCodeAsString() {
        return this.stateReasonCode;
    }

    public final LastUpdateStatus lastUpdateStatus() {
        return LastUpdateStatus.fromValue(this.lastUpdateStatus);
    }

    public final String lastUpdateStatusAsString() {
        return this.lastUpdateStatus;
    }

    public final String lastUpdateStatusReason() {
        return this.lastUpdateStatusReason;
    }

    public final LastUpdateStatusReasonCode lastUpdateStatusReasonCode() {
        return LastUpdateStatusReasonCode.fromValue(this.lastUpdateStatusReasonCode);
    }

    public final String lastUpdateStatusReasonCodeAsString() {
        return this.lastUpdateStatusReasonCode;
    }

    public final boolean hasFileSystemConfigs() {
        return this.fileSystemConfigs != null && !(this.fileSystemConfigs instanceof SdkAutoConstructList);
    }

    public final List<FileSystemConfig> fileSystemConfigs() {
        return this.fileSystemConfigs;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final ImageConfigResponse imageConfigResponse() {
        return this.imageConfigResponse;
    }

    public final String signingProfileVersionArn() {
        return this.signingProfileVersionArn;
    }

    public final String signingJobArn() {
        return this.signingJobArn;
    }

    public final List<Architecture> architectures() {
        return ArchitecturesListCopier.copyStringToEnum(this.architectures);
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architecturesAsStrings() {
        return this.architectures;
    }

    public final EphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final SnapStartResponse snapStart() {
        return this.snapStart;
    }

    public final RuntimeVersionConfig runtimeVersionConfig() {
        return this.runtimeVersionConfig;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatusReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfigResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingProfileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionResponse)) {
            return false;
        }
        CreateFunctionResponse other = (CreateFunctionResponse)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.codeSize(), other.codeSize()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && Objects.equals(this.masterArn(), other.masterArn()) && Objects.equals(this.revisionId(), other.revisionId()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateReasonCodeAsString(), other.stateReasonCodeAsString()) && Objects.equals(this.lastUpdateStatusAsString(), other.lastUpdateStatusAsString()) && Objects.equals(this.lastUpdateStatusReason(), other.lastUpdateStatusReason()) && Objects.equals(this.lastUpdateStatusReasonCodeAsString(), other.lastUpdateStatusReasonCodeAsString()) && this.hasFileSystemConfigs() == other.hasFileSystemConfigs() && Objects.equals(this.fileSystemConfigs(), other.fileSystemConfigs()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.imageConfigResponse(), other.imageConfigResponse()) && Objects.equals(this.signingProfileVersionArn(), other.signingProfileVersionArn()) && Objects.equals(this.signingJobArn(), other.signingJobArn()) && this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architecturesAsStrings(), other.architecturesAsStrings()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.snapStart(), other.snapStart()) && Objects.equals(this.runtimeVersionConfig(), other.runtimeVersionConfig()) && Objects.equals(this.loggingConfig(), other.loggingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFunctionResponse").add("FunctionName", (Object)this.functionName()).add("FunctionArn", (Object)this.functionArn()).add("Runtime", (Object)this.runtimeAsString()).add("Role", (Object)this.role()).add("Handler", (Object)this.handler()).add("CodeSize", (Object)this.codeSize()).add("Description", (Object)this.description()).add("Timeout", (Object)this.timeout()).add("MemorySize", (Object)this.memorySize()).add("LastModified", (Object)this.lastModified()).add("CodeSha256", (Object)this.codeSha256()).add("Version", (Object)this.version()).add("VpcConfig", (Object)this.vpcConfig()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("Environment", (Object)this.environment()).add("KMSKeyArn", (Object)this.kmsKeyArn()).add("TracingConfig", (Object)this.tracingConfig()).add("MasterArn", (Object)this.masterArn()).add("RevisionId", (Object)this.revisionId()).add("Layers", this.hasLayers() ? this.layers() : null).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("StateReasonCode", (Object)this.stateReasonCodeAsString()).add("LastUpdateStatus", (Object)this.lastUpdateStatusAsString()).add("LastUpdateStatusReason", (Object)this.lastUpdateStatusReason()).add("LastUpdateStatusReasonCode", (Object)this.lastUpdateStatusReasonCodeAsString()).add("FileSystemConfigs", this.hasFileSystemConfigs() ? this.fileSystemConfigs() : null).add("PackageType", (Object)this.packageTypeAsString()).add("ImageConfigResponse", (Object)this.imageConfigResponse()).add("SigningProfileVersionArn", (Object)this.signingProfileVersionArn()).add("SigningJobArn", (Object)this.signingJobArn()).add("Architectures", this.hasArchitectures() ? this.architecturesAsStrings() : null).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("SnapStart", (Object)this.snapStart()).add("RuntimeVersionConfig", (Object)this.runtimeVersionConfig()).add("LoggingConfig", (Object)this.loggingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "CodeSize": {
                return Optional.ofNullable(clazz.cast(this.codeSize()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "CodeSha256": {
                return Optional.ofNullable(clazz.cast(this.codeSha256()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.ofNullable(clazz.cast(this.tracingConfig()));
            }
            case "MasterArn": {
                return Optional.ofNullable(clazz.cast(this.masterArn()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "StateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.stateReasonCodeAsString()));
            }
            case "LastUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatusAsString()));
            }
            case "LastUpdateStatusReason": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatusReason()));
            }
            case "LastUpdateStatusReasonCode": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatusReasonCodeAsString()));
            }
            case "FileSystemConfigs": {
                return Optional.ofNullable(clazz.cast(this.fileSystemConfigs()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "ImageConfigResponse": {
                return Optional.ofNullable(clazz.cast(this.imageConfigResponse()));
            }
            case "SigningProfileVersionArn": {
                return Optional.ofNullable(clazz.cast(this.signingProfileVersionArn()));
            }
            case "SigningJobArn": {
                return Optional.ofNullable(clazz.cast(this.signingJobArn()));
            }
            case "Architectures": {
                return Optional.ofNullable(clazz.cast(this.architecturesAsStrings()));
            }
            case "EphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "SnapStart": {
                return Optional.ofNullable(clazz.cast(this.snapStart()));
            }
            case "RuntimeVersionConfig": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersionConfig()));
            }
            case "LoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionResponse, T> g) {
        return obj -> g.apply((CreateFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String functionName;
        private String functionArn;
        private String runtime;
        private String role;
        private String handler;
        private Long codeSize;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private String lastModified;
        private String codeSha256;
        private String version;
        private VpcConfigResponse vpcConfig;
        private DeadLetterConfig deadLetterConfig;
        private EnvironmentResponse environment;
        private String kmsKeyArn;
        private TracingConfigResponse tracingConfig;
        private String masterArn;
        private String revisionId;
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private String stateReason;
        private String stateReasonCode;
        private String lastUpdateStatus;
        private String lastUpdateStatusReason;
        private String lastUpdateStatusReasonCode;
        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();
        private String packageType;
        private ImageConfigResponse imageConfigResponse;
        private String signingProfileVersionArn;
        private String signingJobArn;
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private EphemeralStorage ephemeralStorage;
        private SnapStartResponse snapStart;
        private RuntimeVersionConfig runtimeVersionConfig;
        private LoggingConfig loggingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionResponse model) {
            super(model);
            this.functionName(model.functionName);
            this.functionArn(model.functionArn);
            this.runtime(model.runtime);
            this.role(model.role);
            this.handler(model.handler);
            this.codeSize(model.codeSize);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.lastModified(model.lastModified);
            this.codeSha256(model.codeSha256);
            this.version(model.version);
            this.vpcConfig(model.vpcConfig);
            this.deadLetterConfig(model.deadLetterConfig);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
            this.masterArn(model.masterArn);
            this.revisionId(model.revisionId);
            this.layers(model.layers);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.stateReasonCode(model.stateReasonCode);
            this.lastUpdateStatus(model.lastUpdateStatus);
            this.lastUpdateStatusReason(model.lastUpdateStatusReason);
            this.lastUpdateStatusReasonCode(model.lastUpdateStatusReasonCode);
            this.fileSystemConfigs(model.fileSystemConfigs);
            this.packageType(model.packageType);
            this.imageConfigResponse(model.imageConfigResponse);
            this.signingProfileVersionArn(model.signingProfileVersionArn);
            this.signingJobArn(model.signingJobArn);
            this.architecturesWithStrings(model.architectures);
            this.ephemeralStorage(model.ephemeralStorage);
            this.snapStart(model.snapStart);
            this.runtimeVersionConfig(model.runtimeVersionConfig);
            this.loggingConfig(model.loggingConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getHandler() {
            return this.handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final VpcConfigResponse.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final EnvironmentResponse.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(EnvironmentResponse.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(EnvironmentResponse environment) {
            this.environment = environment;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final TracingConfigResponse.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        public final void setTracingConfig(TracingConfigResponse.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfigResponse tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final String getMasterArn() {
            return this.masterArn;
        }

        public final void setMasterArn(String masterArn) {
            this.masterArn = masterArn;
        }

        @Override
        public final Builder masterArn(String masterArn) {
            this.masterArn = masterArn;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final List<Layer.Builder> getLayers() {
            List<Layer.Builder> result = LayersReferenceListCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersReferenceListCopier.copyFromBuilder(layers);
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersReferenceListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (Layer)((Layer.Builder)Layer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonCode() {
            return this.stateReasonCode;
        }

        public final void setStateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
        }

        @Override
        public final Builder stateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
            return this;
        }

        @Override
        public final Builder stateReasonCode(StateReasonCode stateReasonCode) {
            this.stateReasonCode(stateReasonCode == null ? null : stateReasonCode.toString());
            return this;
        }

        public final String getLastUpdateStatus() {
            return this.lastUpdateStatus;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        @Override
        public final Builder lastUpdateStatus(LastUpdateStatus lastUpdateStatus) {
            this.lastUpdateStatus(lastUpdateStatus == null ? null : lastUpdateStatus.toString());
            return this;
        }

        public final String getLastUpdateStatusReason() {
            return this.lastUpdateStatusReason;
        }

        public final void setLastUpdateStatusReason(String lastUpdateStatusReason) {
            this.lastUpdateStatusReason = lastUpdateStatusReason;
        }

        @Override
        public final Builder lastUpdateStatusReason(String lastUpdateStatusReason) {
            this.lastUpdateStatusReason = lastUpdateStatusReason;
            return this;
        }

        public final String getLastUpdateStatusReasonCode() {
            return this.lastUpdateStatusReasonCode;
        }

        public final void setLastUpdateStatusReasonCode(String lastUpdateStatusReasonCode) {
            this.lastUpdateStatusReasonCode = lastUpdateStatusReasonCode;
        }

        @Override
        public final Builder lastUpdateStatusReasonCode(String lastUpdateStatusReasonCode) {
            this.lastUpdateStatusReasonCode = lastUpdateStatusReasonCode;
            return this;
        }

        @Override
        public final Builder lastUpdateStatusReasonCode(LastUpdateStatusReasonCode lastUpdateStatusReasonCode) {
            this.lastUpdateStatusReasonCode(lastUpdateStatusReasonCode == null ? null : lastUpdateStatusReasonCode.toString());
            return this;
        }

        public final List<FileSystemConfig.Builder> getFileSystemConfigs() {
            List<FileSystemConfig.Builder> result = FileSystemConfigListCopier.copyToBuilder(this.fileSystemConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig ... fileSystemConfigs) {
            this.fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... fileSystemConfigs) {
            this.fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> (FileSystemConfig)((FileSystemConfig.Builder)FileSystemConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final ImageConfigResponse.Builder getImageConfigResponse() {
            return this.imageConfigResponse != null ? this.imageConfigResponse.toBuilder() : null;
        }

        public final void setImageConfigResponse(ImageConfigResponse.BuilderImpl imageConfigResponse) {
            this.imageConfigResponse = imageConfigResponse != null ? imageConfigResponse.build() : null;
        }

        @Override
        public final Builder imageConfigResponse(ImageConfigResponse imageConfigResponse) {
            this.imageConfigResponse = imageConfigResponse;
            return this;
        }

        public final String getSigningProfileVersionArn() {
            return this.signingProfileVersionArn;
        }

        public final void setSigningProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
        }

        @Override
        public final Builder signingProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
            return this;
        }

        public final String getSigningJobArn() {
            return this.signingJobArn;
        }

        public final void setSigningJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
        }

        @Override
        public final Builder signingJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
        }

        @Override
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecturesWithStrings(String ... architectures) {
            this.architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitecturesListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Architecture ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final SnapStartResponse.Builder getSnapStart() {
            return this.snapStart != null ? this.snapStart.toBuilder() : null;
        }

        public final void setSnapStart(SnapStartResponse.BuilderImpl snapStart) {
            this.snapStart = snapStart != null ? snapStart.build() : null;
        }

        @Override
        public final Builder snapStart(SnapStartResponse snapStart) {
            this.snapStart = snapStart;
            return this;
        }

        public final RuntimeVersionConfig.Builder getRuntimeVersionConfig() {
            return this.runtimeVersionConfig != null ? this.runtimeVersionConfig.toBuilder() : null;
        }

        public final void setRuntimeVersionConfig(RuntimeVersionConfig.BuilderImpl runtimeVersionConfig) {
            this.runtimeVersionConfig = runtimeVersionConfig != null ? runtimeVersionConfig.build() : null;
        }

        @Override
        public final Builder runtimeVersionConfig(RuntimeVersionConfig runtimeVersionConfig) {
            this.runtimeVersionConfig = runtimeVersionConfig;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        @Override
        public CreateFunctionResponse build() {
            return new CreateFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFunctionResponse> {
        public Builder functionName(String var1);

        public Builder functionArn(String var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder codeSize(Long var1);

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder lastModified(String var1);

        public Builder codeSha256(String var1);

        public Builder version(String var1);

        public Builder vpcConfig(VpcConfigResponse var1);

        default public Builder vpcConfig(Consumer<VpcConfigResponse.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigResponse)((VpcConfigResponse.Builder)VpcConfigResponse.builder().applyMutation(vpcConfig)).build());
        }

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder environment(EnvironmentResponse var1);

        default public Builder environment(Consumer<EnvironmentResponse.Builder> environment) {
            return this.environment((EnvironmentResponse)((EnvironmentResponse.Builder)EnvironmentResponse.builder().applyMutation(environment)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfigResponse var1);

        default public Builder tracingConfig(Consumer<TracingConfigResponse.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfigResponse)((TracingConfigResponse.Builder)TracingConfigResponse.builder().applyMutation(tracingConfig)).build());
        }

        public Builder masterArn(String var1);

        public Builder revisionId(String var1);

        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder layers(Consumer<Layer.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder stateReason(String var1);

        public Builder stateReasonCode(String var1);

        public Builder stateReasonCode(StateReasonCode var1);

        public Builder lastUpdateStatus(String var1);

        public Builder lastUpdateStatus(LastUpdateStatus var1);

        public Builder lastUpdateStatusReason(String var1);

        public Builder lastUpdateStatusReasonCode(String var1);

        public Builder lastUpdateStatusReasonCode(LastUpdateStatusReasonCode var1);

        public Builder fileSystemConfigs(Collection<FileSystemConfig> var1);

        public Builder fileSystemConfigs(FileSystemConfig ... var1);

        public Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder> ... var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder imageConfigResponse(ImageConfigResponse var1);

        default public Builder imageConfigResponse(Consumer<ImageConfigResponse.Builder> imageConfigResponse) {
            return this.imageConfigResponse((ImageConfigResponse)((ImageConfigResponse.Builder)ImageConfigResponse.builder().applyMutation(imageConfigResponse)).build());
        }

        public Builder signingProfileVersionArn(String var1);

        public Builder signingJobArn(String var1);

        public Builder architecturesWithStrings(Collection<String> var1);

        public Builder architecturesWithStrings(String ... var1);

        public Builder architectures(Collection<Architecture> var1);

        public Builder architectures(Architecture ... var1);

        public Builder ephemeralStorage(EphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EphemeralStorage)((EphemeralStorage.Builder)EphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }

        public Builder snapStart(SnapStartResponse var1);

        default public Builder snapStart(Consumer<SnapStartResponse.Builder> snapStart) {
            return this.snapStart((SnapStartResponse)((SnapStartResponse.Builder)SnapStartResponse.builder().applyMutation(snapStart)).build());
        }

        public Builder runtimeVersionConfig(RuntimeVersionConfig var1);

        default public Builder runtimeVersionConfig(Consumer<RuntimeVersionConfig.Builder> runtimeVersionConfig) {
            return this.runtimeVersionConfig((RuntimeVersionConfig)((RuntimeVersionConfig.Builder)RuntimeVersionConfig.builder().applyMutation(runtimeVersionConfig)).build());
        }

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }
    }
}

