/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VPC security groups and subnets that are attached to a Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigResponse.Builder, VpcConfigResponse> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(VpcConfigResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(VpcConfigResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcConfigResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Boolean> IPV6_ALLOWED_FOR_DUAL_STACK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("Ipv6AllowedForDualStack")
            .getter(getter(VpcConfigResponse::ipv6AllowedForDualStack)).setter(setter(Builder::ipv6AllowedForDualStack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AllowedForDualStack").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD, IPV6_ALLOWED_FOR_DUAL_STACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String vpcId;

    private final Boolean ipv6AllowedForDualStack;

    private VpcConfigResponse(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
        this.ipv6AllowedForDualStack = builder.ipv6AllowedForDualStack;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC subnet IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of VPC subnet IDs.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security group IDs.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
     * </p>
     * 
     * @return Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
     */
    public final Boolean ipv6AllowedForDualStack() {
        return ipv6AllowedForDualStack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AllowedForDualStack());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigResponse)) {
            return false;
        }
        VpcConfigResponse other = (VpcConfigResponse) obj;
        return hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ipv6AllowedForDualStack(), other.ipv6AllowedForDualStack());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfigResponse").add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("VpcId", vpcId())
                .add("Ipv6AllowedForDualStack", ipv6AllowedForDualStack()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Ipv6AllowedForDualStack":
            return Optional.ofNullable(clazz.cast(ipv6AllowedForDualStack()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigResponse, T> g) {
        return obj -> g.apply((VpcConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigResponse> {
        /**
         * <p>
         * A list of VPC subnet IDs.
         * </p>
         * 
         * @param subnetIds
         *        A list of VPC subnet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of VPC subnet IDs.
         * </p>
         * 
         * @param subnetIds
         *        A list of VPC subnet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of VPC security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of VPC security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
         * </p>
         * 
         * @param ipv6AllowedForDualStack
         *        Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AllowedForDualStack(Boolean ipv6AllowedForDualStack);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private Boolean ipv6AllowedForDualStack;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigResponse model) {
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            vpcId(model.vpcId);
            ipv6AllowedForDualStack(model.ipv6AllowedForDualStack);
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getIpv6AllowedForDualStack() {
            return ipv6AllowedForDualStack;
        }

        public final void setIpv6AllowedForDualStack(Boolean ipv6AllowedForDualStack) {
            this.ipv6AllowedForDualStack = ipv6AllowedForDualStack;
        }

        @Override
        public final Builder ipv6AllowedForDualStack(Boolean ipv6AllowedForDualStack) {
            this.ipv6AllowedForDualStack = ipv6AllowedForDualStack;
            return this;
        }

        @Override
        public VpcConfigResponse build() {
            return new VpcConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
