/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.ApplicationLogLevel;
import software.amazon.awssdk.services.lambda.model.LogFormat;
import software.amazon.awssdk.services.lambda.model.SystemLogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfig> {
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFormat").getter(LoggingConfig.getter(LoggingConfig::logFormatAsString)).setter(LoggingConfig.setter(Builder::logFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()}).build();
    private static final SdkField<String> APPLICATION_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationLogLevel").getter(LoggingConfig.getter(LoggingConfig::applicationLogLevelAsString)).setter(LoggingConfig.setter(Builder::applicationLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogLevel").build()}).build();
    private static final SdkField<String> SYSTEM_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SystemLogLevel").getter(LoggingConfig.getter(LoggingConfig::systemLogLevelAsString)).setter(LoggingConfig.setter(Builder::systemLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemLogLevel").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroup").getter(LoggingConfig.getter(LoggingConfig::logGroup)).setter(LoggingConfig.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FORMAT_FIELD, APPLICATION_LOG_LEVEL_FIELD, SYSTEM_LOG_LEVEL_FIELD, LOG_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logFormat;
    private final String applicationLogLevel;
    private final String systemLogLevel;
    private final String logGroup;

    private LoggingConfig(BuilderImpl builder) {
        this.logFormat = builder.logFormat;
        this.applicationLogLevel = builder.applicationLogLevel;
        this.systemLogLevel = builder.systemLogLevel;
        this.logGroup = builder.logGroup;
    }

    public final LogFormat logFormat() {
        return LogFormat.fromValue(this.logFormat);
    }

    public final String logFormatAsString() {
        return this.logFormat;
    }

    public final ApplicationLogLevel applicationLogLevel() {
        return ApplicationLogLevel.fromValue(this.applicationLogLevel);
    }

    public final String applicationLogLevelAsString() {
        return this.applicationLogLevel;
    }

    public final SystemLogLevel systemLogLevel() {
        return SystemLogLevel.fromValue(this.systemLogLevel);
    }

    public final String systemLogLevelAsString() {
        return this.systemLogLevel;
    }

    public final String logGroup() {
        return this.logGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig)obj;
        return Objects.equals(this.logFormatAsString(), other.logFormatAsString()) && Objects.equals(this.applicationLogLevelAsString(), other.applicationLogLevelAsString()) && Objects.equals(this.systemLogLevelAsString(), other.systemLogLevelAsString()) && Objects.equals(this.logGroup(), other.logGroup());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingConfig").add("LogFormat", (Object)this.logFormatAsString()).add("ApplicationLogLevel", (Object)this.applicationLogLevelAsString()).add("SystemLogLevel", (Object)this.systemLogLevelAsString()).add("LogGroup", (Object)this.logGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogFormat": {
                return Optional.ofNullable(clazz.cast(this.logFormatAsString()));
            }
            case "ApplicationLogLevel": {
                return Optional.ofNullable(clazz.cast(this.applicationLogLevelAsString()));
            }
            case "SystemLogLevel": {
                return Optional.ofNullable(clazz.cast(this.systemLogLevelAsString()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logFormat;
        private String applicationLogLevel;
        private String systemLogLevel;
        private String logGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            this.logFormat(model.logFormat);
            this.applicationLogLevel(model.applicationLogLevel);
            this.systemLogLevel(model.systemLogLevel);
            this.logGroup(model.logGroup);
        }

        public final String getLogFormat() {
            return this.logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormat logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        public final String getApplicationLogLevel() {
            return this.applicationLogLevel;
        }

        public final void setApplicationLogLevel(String applicationLogLevel) {
            this.applicationLogLevel = applicationLogLevel;
        }

        @Override
        public final Builder applicationLogLevel(String applicationLogLevel) {
            this.applicationLogLevel = applicationLogLevel;
            return this;
        }

        @Override
        public final Builder applicationLogLevel(ApplicationLogLevel applicationLogLevel) {
            this.applicationLogLevel(applicationLogLevel == null ? null : applicationLogLevel.toString());
            return this;
        }

        public final String getSystemLogLevel() {
            return this.systemLogLevel;
        }

        public final void setSystemLogLevel(String systemLogLevel) {
            this.systemLogLevel = systemLogLevel;
        }

        @Override
        public final Builder systemLogLevel(String systemLogLevel) {
            this.systemLogLevel = systemLogLevel;
            return this;
        }

        @Override
        public final Builder systemLogLevel(SystemLogLevel systemLogLevel) {
            this.systemLogLevel(systemLogLevel == null ? null : systemLogLevel.toString());
            return this;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfig> {
        public Builder logFormat(String var1);

        public Builder logFormat(LogFormat var1);

        public Builder applicationLogLevel(String var1);

        public Builder applicationLogLevel(ApplicationLogLevel var1);

        public Builder systemLogLevel(String var1);

        public Builder systemLogLevel(SystemLogLevel var1);

        public Builder logGroup(String var1);
    }
}

