/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CodeSigningConfigNotFoundException;
import software.amazon.awssdk.services.lambda.model.CodeStorageExceededException;
import software.amazon.awssdk.services.lambda.model.CodeVerificationFailedException;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.Ec2AccessDeniedException;
import software.amazon.awssdk.services.lambda.model.Ec2ThrottledException;
import software.amazon.awssdk.services.lambda.model.Ec2UnexpectedException;
import software.amazon.awssdk.services.lambda.model.EfsMountConnectivityException;
import software.amazon.awssdk.services.lambda.model.EfsMountFailureException;
import software.amazon.awssdk.services.lambda.model.EfsMountTimeoutException;
import software.amazon.awssdk.services.lambda.model.EfsioException;
import software.amazon.awssdk.services.lambda.model.EniLimitReachedException;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse;
import software.amazon.awssdk.services.lambda.model.InvalidCodeSignatureException;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvalidRequestContentException;
import software.amazon.awssdk.services.lambda.model.InvalidRuntimeException;
import software.amazon.awssdk.services.lambda.model.InvalidSecurityGroupIdException;
import software.amazon.awssdk.services.lambda.model.InvalidSubnetIdException;
import software.amazon.awssdk.services.lambda.model.InvalidZipFileException;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.lambda.model.KmsDisabledException;
import software.amazon.awssdk.services.lambda.model.KmsInvalidStateException;
import software.amazon.awssdk.services.lambda.model.KmsNotFoundException;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.lambda.model.PreconditionFailedException;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigNotFoundException;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse;
import software.amazon.awssdk.services.lambda.model.RecursiveInvocationException;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.RequestTooLargeException;
import software.amazon.awssdk.services.lambda.model.ResourceConflictException;
import software.amazon.awssdk.services.lambda.model.ResourceInUseException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.SnapStartException;
import software.amazon.awssdk.services.lambda.model.SnapStartNotReadyException;
import software.amazon.awssdk.services.lambda.model.SnapStartTimeoutException;
import software.amazon.awssdk.services.lambda.model.SubnetIpAddressLimitReachedException;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.awssdk.services.lambda.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListLayersIterable;
import software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable;
import software.amazon.awssdk.services.lambda.waiters.LambdaWaiter;

/**
 * Service client for accessing AWS Lambda. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Lambda</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * Lambda is a compute service that lets you run code without provisioning or managing servers. Lambda runs your code on
 * a high-availability compute infrastructure and performs all of the administration of the compute resources, including
 * server and operating system maintenance, capacity provisioning and automatic scaling, code monitoring and logging.
 * With Lambda, you can run code for virtually any type of application or backend service. For more information about
 * the Lambda service, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is Lambda</a> in the
 * <b>Lambda Developer Guide</b>.
 * </p>
 * <p>
 * The <i>Lambda API Reference</i> provides information about each of the API methods, including details about the
 * parameters in each API request and response.
 * </p>
 * <p/>
 * <p>
 * You can use Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line
 * tools to access the API. For installation instructions, see <a href="http://aws.amazon.com/tools/">Tools for Amazon
 * Web Services</a>.
 * </p>
 * <p>
 * For a list of Region-specific endpoints that Lambda supports, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/lambda-service.html/">Lambda endpoints and quotas </a> in the
 * <i>Amazon Web Services General Reference.</i>.
 * </p>
 * <p>
 * When making the API calls, you will need to authenticate your request by providing a signature. Lambda supports
 * signature version 4. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a>
 * in the <i>Amazon Web Services General Reference.</i>.
 * </p>
 * <p>
 * <b>CA certificates</b>
 * </p>
 * <p>
 * Because Amazon Web Services SDKs use the CA certificates from your computer, changes to the certificates on the
 * Amazon Web Services servers can cause connection failures when you attempt to use an SDK. You can prevent these
 * failures by keeping your computer's CA certificates and operating system up-to-date. If you encounter this issue in a
 * corporate environment and do not manage your own computer, you might need to ask an administrator to assist with the
 * update process. The following list shows minimum operating system and Java versions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Microsoft Windows versions that have updates from January 2005 or later installed contain at least one of the
 * required CAs in their trust list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Mac OS X 10.4 with Java for Mac OS X 10.4 Release 5 (February 2007), Mac OS X 10.5 (October 2007), and later versions
 * contain at least one of the required CAs in their trust list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Red Hat Enterprise Linux 5 (March 2007), 6, and 7 and CentOS 5, 6, and 7 all contain at least one of the required CAs
 * in their default trusted CA list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Java 1.4.2_12 (May 2006), 5 Update 2 (March 2005), and all later versions, including Java 6 (December 2006), 7, and
 * 8, contain at least one of the required CAs in their default trusted CA list.
 * </p>
 * </li>
 * </ul>
 * <p>
 * When accessing the Lambda management console or Lambda API endpoints, whether through browsers or programmatically,
 * you will need to ensure your client machines support any of the following CAs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon Root CA 1
 * </p>
 * </li>
 * <li>
 * <p>
 * Starfield Services Root Certificate Authority - G2
 * </p>
 * </li>
 * <li>
 * <p>
 * Starfield Class 2 Certification Authority
 * </p>
 * </li>
 * </ul>
 * <p>
 * Root certificates from the first two authorities are available from <a
 * href="https://www.amazontrust.com/repository/">Amazon trust services</a>, but keeping your computer up-to-date is the
 * more straightforward solution. To learn more about ACM-provided certificates, see <a
 * href="http://aws.amazon.com/certificate-manager/faqs/#certificates">Amazon Web Services Certificate Manager FAQs.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LambdaClient extends AwsClient {
    String SERVICE_NAME = "lambda";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lambda";

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action
     * to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in
     * an organization, or all Amazon Web Services accounts.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return Result of the AddLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default AddLayerVersionPermissionResponse addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, InvalidParameterValueException,
            PolicyLengthExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action
     * to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in
     * an organization, or all Amazon Web Services accounts.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddLayerVersionPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link AddLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest.Builder} to create a
     *        request.
     * @return Result of the AddLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default AddLayerVersionPermissionResponse addLayerVersionPermission(
            Consumer<AddLayerVersionPermissionRequest.Builder> addLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, InvalidParameterValueException,
            PolicyLengthExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return addLayerVersionPermission(AddLayerVersionPermissionRequest.builder()
                .applyMutation(addLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Grants an Amazon Web Service, Amazon Web Services account, or Amazon Web Services organization permission to use
     * a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single
     * version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that
     * version or alias to invoke the function. Note: Lambda does not support adding policies to version &#36LATEST.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. To grant permission
     * to an organization defined in Organizations, specify the organization ID as the <code>PrincipalOrgID</code>. For
     * Amazon Web Services, the principal is a domain-style identifier that the service defines, such as
     * <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services, you can also specify
     * the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service principal
     * without specifying the source, other accounts could potentially configure resources in their account to invoke
     * your Lambda function.
     * </p>
     * <p>
     * This operation adds a statement to a resource-based permissions policy for the function. For more information
     * about function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Using resource-based
     * policies for Lambda</a>.
     * </p>
     *
     * @param addPermissionRequest
     * @return Result of the AddPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, PolicyLengthExceededException,
            TooManyRequestsException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants an Amazon Web Service, Amazon Web Services account, or Amazon Web Services organization permission to use
     * a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single
     * version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that
     * version or alias to invoke the function. Note: Lambda does not support adding policies to version &#36LATEST.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. To grant permission
     * to an organization defined in Organizations, specify the organization ID as the <code>PrincipalOrgID</code>. For
     * Amazon Web Services, the principal is a domain-style identifier that the service defines, such as
     * <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services, you can also specify
     * the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service principal
     * without specifying the source, other accounts could potentially configure resources in their account to invoke
     * your Lambda function.
     * </p>
     * <p>
     * This operation adds a statement to a resource-based permissions policy for the function. For more information
     * about function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Using resource-based
     * policies for Lambda</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link AddPermissionRequest#builder()}
     * </p>
     *
     * @param addPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.AddPermissionRequest.Builder} to create a request.
     * @return Result of the AddPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default AddPermissionResponse addPermission(Consumer<AddPermissionRequest.Builder> addPermissionRequest)
            throws ServiceException, ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException,
            PolicyLengthExceededException, TooManyRequestsException, PreconditionFailedException, AwsServiceException,
            SdkClientException, LambdaException {
        return addPermission(AddPermissionRequest.builder().applyMutation(addPermissionRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a> for a
     * Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke
     * a different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a> for a
     * Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke
     * a different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateAliasRequest.Builder} to create a request.
     * @return Result of the CreateAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates a code signing configuration. A <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">code signing configuration</a>
     * defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if
     * deployment validation checks fail).
     * </p>
     *
     * @param createCodeSigningConfigRequest
     * @return Result of the CreateCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeSigningConfigResponse createCodeSigningConfig(CreateCodeSigningConfigRequest createCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a code signing configuration. A <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">code signing configuration</a>
     * defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if
     * deployment validation checks fail).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeSigningConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param createCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeSigningConfigResponse createCodeSigningConfig(
            Consumer<CreateCodeSigningConfigRequest.Builder> createCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return createCodeSigningConfig(CreateCodeSigningConfigRequest.builder().applyMutation(createCodeSigningConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and
     * invokes the function.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return Result of the CreateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventSourceMappingResponse createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and
     * invokes the function.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param createEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventSourceMappingResponse createEventSourceMapping(
            Consumer<CreateEventSourceMappingRequest.Builder> createEventSourceMappingRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        return createEventSourceMapping(CreateEventSourceMappingRequest.builder().applyMutation(createEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package is a .zip file archive or container image that contains your function
     * code. The execution role grants the function permission to use Amazon Web Services, such as Amazon CloudWatch
     * Logs for log streaming and X-Ray for request tracing.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>, then you set the
     * package type to <code>Image</code>. For a container image, the code property must include the URI of a container
     * image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>, then you set the package type to <code>Zip</code>. For a .zip file archive, the code property
     * specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in
     * the deployment package must be compatible with the target instruction set architecture of the function (
     * <code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, then the default value is
     * <code>x86-64</code>.
     * </p>
     * <p>
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify
     * the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the
     * response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function
     * states</a>.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this
     * function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with
     * <a>UpdateFunctionCode</a>, Lambda checks that the code package has a valid signature from a trusted publisher.
     * The code-signing configuration includes set of signing profiles, which define the trusted publishers for this
     * function.
     * </p>
     * <p>
     * If another Amazon Web Services account or an Amazon Web Service invokes your function, use <a>AddPermission</a>
     * to grant permission by creating a resource-based Identity and Access Management (IAM) policy. You can grant
     * permissions at the function level, on a version, or on an alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other
     * Amazon Web Services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function
     * trigger in the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Lambda functions</a>.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException, TooManyRequestsException,
            CodeStorageExceededException, CodeVerificationFailedException, InvalidCodeSignatureException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package is a .zip file archive or container image that contains your function
     * code. The execution role grants the function permission to use Amazon Web Services, such as Amazon CloudWatch
     * Logs for log streaming and X-Ray for request tracing.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>, then you set the
     * package type to <code>Image</code>. For a container image, the code property must include the URI of a container
     * image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>, then you set the package type to <code>Zip</code>. For a .zip file archive, the code property
     * specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in
     * the deployment package must be compatible with the target instruction set architecture of the function (
     * <code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, then the default value is
     * <code>x86-64</code>.
     * </p>
     * <p>
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify
     * the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the
     * response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function
     * states</a>.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this
     * function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with
     * <a>UpdateFunctionCode</a>, Lambda checks that the code package has a valid signature from a trusted publisher.
     * The code-signing configuration includes set of signing profiles, which define the trusted publishers for this
     * function.
     * </p>
     * <p>
     * If another Amazon Web Services account or an Amazon Web Service invokes your function, use <a>AddPermission</a>
     * to grant permission by creating a resource-based Identity and Access Management (IAM) policy. You can grant
     * permissions at the function level, on a version, or on an alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other
     * Amazon Web Services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function
     * trigger in the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Lambda functions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateFunctionRequest.Builder} to create a request.
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException,
            TooManyRequestsException, CodeStorageExceededException, CodeVerificationFailedException,
            InvalidCodeSignatureException, CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException,
            LambdaException {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S)
     * endpoint that you can use to invoke your function.
     * </p>
     *
     * @param createFunctionUrlConfigRequest
     * @return Result of the CreateFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFunctionUrlConfigResponse createFunctionUrlConfig(CreateFunctionUrlConfigRequest createFunctionUrlConfigRequest)
            throws ResourceConflictException, ResourceNotFoundException, InvalidParameterValueException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S)
     * endpoint that you can use to invoke your function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionUrlConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param createFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFunctionUrlConfigResponse createFunctionUrlConfig(
            Consumer<CreateFunctionUrlConfigRequest.Builder> createFunctionUrlConfigRequest) throws ResourceConflictException,
            ResourceNotFoundException, InvalidParameterValueException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return createFunctionUrlConfig(CreateFunctionUrlConfigRequest.builder().applyMutation(createFunctionUrlConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteAliasRequest.Builder} to create a request.
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is
     * using it.
     * </p>
     *
     * @param deleteCodeSigningConfigRequest
     * @return Result of the DeleteCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeSigningConfigResponse deleteCodeSigningConfig(DeleteCodeSigningConfigRequest deleteCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is
     * using it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeSigningConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param deleteCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeSigningConfigResponse deleteCodeSigningConfig(
            Consumer<DeleteCodeSigningConfigRequest.Builder> deleteCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException, AwsServiceException,
            SdkClientException, LambdaException {
        return deleteCodeSigningConfig(DeleteCodeSigningConfigRequest.builder().applyMutation(deleteCodeSigningConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <p>
     * When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
     * deleted for several seconds.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return Result of the DeleteEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you tried to update an event
     *         source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventSourceMappingResponse deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, ResourceInUseException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <p>
     * When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
     * deleted for several seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you tried to update an event
     *         source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventSourceMappingResponse deleteEventSourceMapping(
            Consumer<DeleteEventSourceMappingRequest.Builder> deleteEventSourceMappingRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            ResourceInUseException, AwsServiceException, SdkClientException, LambdaException {
        return deleteEventSourceMapping(DeleteEventSourceMappingRequest.builder().applyMutation(deleteEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted. This doesn't require the user to have explicit permissions for
     * <a>DeleteAlias</a>.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For Amazon
     * Web Services and resources that invoke your function directly, delete the trigger in the service where you
     * originally configured it.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted. This doesn't require the user to have explicit permissions for
     * <a>DeleteAlias</a>.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For Amazon
     * Web Services and resources that invoke your function directly, delete the trigger in the service where you
     * originally configured it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest.Builder} to create a request.
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Removes the code signing configuration from the function.
     * </p>
     *
     * @param deleteFunctionCodeSigningConfigRequest
     * @return Result of the DeleteFunctionCodeSigningConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionCodeSigningConfigResponse deleteFunctionCodeSigningConfig(
            DeleteFunctionCodeSigningConfigRequest deleteFunctionCodeSigningConfigRequest) throws InvalidParameterValueException,
            CodeSigningConfigNotFoundException, ResourceNotFoundException, ServiceException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the code signing configuration from the function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFunctionCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param deleteFunctionCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFunctionCodeSigningConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionCodeSigningConfigResponse deleteFunctionCodeSigningConfig(
            Consumer<DeleteFunctionCodeSigningConfigRequest.Builder> deleteFunctionCodeSigningConfigRequest)
            throws InvalidParameterValueException, CodeSigningConfigNotFoundException, ResourceNotFoundException,
            ServiceException, TooManyRequestsException, ResourceConflictException, AwsServiceException, SdkClientException,
            LambdaException {
        return deleteFunctionCodeSigningConfig(DeleteFunctionCodeSigningConfigRequest.builder()
                .applyMutation(deleteFunctionCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return Result of the DeleteFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionConcurrencyResponse deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionConcurrencyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionConcurrencyResponse deleteFunctionConcurrency(
            Consumer<DeleteFunctionConcurrencyRequest.Builder> deleteFunctionConcurrencyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        return deleteFunctionConcurrency(DeleteFunctionConcurrencyRequest.builder()
                .applyMutation(deleteFunctionConcurrencyRequest).build());
    }

    /**
     * <p>
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param deleteFunctionEventInvokeConfigRequest
     * @return Result of the DeleteFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionEventInvokeConfigResponse deleteFunctionEventInvokeConfig(
            DeleteFunctionEventInvokeConfigRequest deleteFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param deleteFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionEventInvokeConfigResponse deleteFunctionEventInvokeConfig(
            Consumer<DeleteFunctionEventInvokeConfigRequest.Builder> deleteFunctionEventInvokeConfigRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        return deleteFunctionEventInvokeConfig(DeleteFunctionEventInvokeConfigRequest.builder()
                .applyMutation(deleteFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL
     * results in a different URL address.
     * </p>
     *
     * @param deleteFunctionUrlConfigRequest
     * @return Result of the DeleteFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionUrlConfigResponse deleteFunctionUrlConfig(DeleteFunctionUrlConfigRequest deleteFunctionUrlConfigRequest)
            throws ResourceConflictException, ResourceNotFoundException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL
     * results in a different URL address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionUrlConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param deleteFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionUrlConfigResponse deleteFunctionUrlConfig(
            Consumer<DeleteFunctionUrlConfigRequest.Builder> deleteFunctionUrlConfigRequest) throws ResourceConflictException,
            ResourceNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException,
            LambdaException {
        return deleteFunctionUrlConfig(DeleteFunctionUrlConfigRequest.builder().applyMutation(deleteFunctionUrlConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of
     * the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return Result of the DeleteLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLayerVersionResponse deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest)
            throws ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of
     * the version remains in Lambda until no functions refer to it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLayerVersionRequest#builder()}
     * </p>
     *
     * @param deleteLayerVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLayerVersionResponse deleteLayerVersion(Consumer<DeleteLayerVersionRequest.Builder> deleteLayerVersionRequest)
            throws ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return deleteLayerVersion(DeleteLayerVersionRequest.builder().applyMutation(deleteLayerVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the provisioned concurrency configuration for a function.
     * </p>
     *
     * @param deleteProvisionedConcurrencyConfigRequest
     * @return Result of the DeleteProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisionedConcurrencyConfigResponse deleteProvisionedConcurrencyConfig(
            DeleteProvisionedConcurrencyConfigRequest deleteProvisionedConcurrencyConfigRequest)
            throws InvalidParameterValueException, ResourceConflictException, ResourceNotFoundException,
            TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the provisioned concurrency configuration for a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisionedConcurrencyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisionedConcurrencyConfigRequest#builder()}
     * </p>
     *
     * @param deleteProvisionedConcurrencyConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisionedConcurrencyConfigResponse deleteProvisionedConcurrencyConfig(
            Consumer<DeleteProvisionedConcurrencyConfigRequest.Builder> deleteProvisionedConcurrencyConfigRequest)
            throws InvalidParameterValueException, ResourceConflictException, ResourceNotFoundException,
            TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        return deleteProvisionedConcurrencyConfig(DeleteProvisionedConcurrencyConfigRequest.builder()
                .applyMutation(deleteProvisionedConcurrencyConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest)
            throws TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     *
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see #getAccountSettings(GetAccountSettingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings() throws TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return getAccountSettings(GetAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     *
     * @param getAliasRequest
     * @return Result of the GetAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAliasResponse getAlias(GetAliasRequest getAliasRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAliasRequest.Builder} avoiding the need to
     * create one manually via {@link GetAliasRequest#builder()}
     * </p>
     *
     * @param getAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetAliasRequest.Builder} to create a request.
     * @return Result of the GetAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAliasResponse getAlias(Consumer<GetAliasRequest.Builder> getAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return getAlias(GetAliasRequest.builder().applyMutation(getAliasRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified code signing configuration.
     * </p>
     *
     * @param getCodeSigningConfigRequest
     * @return Result of the GetCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetCodeSigningConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCodeSigningConfigResponse getCodeSigningConfig(GetCodeSigningConfigRequest getCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified code signing configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeSigningConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param getCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetCodeSigningConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCodeSigningConfigResponse getCodeSigningConfig(
            Consumer<GetCodeSigningConfigRequest.Builder> getCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return getCodeSigningConfig(GetCodeSigningConfigRequest.builder().applyMutation(getCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return Result of the GetEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventSourceMappingResponse getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventSourceMappingRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param getEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the GetEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventSourceMappingResponse getEventSourceMapping(
            Consumer<GetEventSourceMappingRequest.Builder> getEventSourceMappingRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return getEventSourceMapping(GetEventSourceMappingRequest.builder().applyMutation(getEventSourceMappingRequest).build());
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionRequest.Builder} to create a request.
     * @return Result of the GetFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Returns the code signing configuration for the specified function.
     * </p>
     *
     * @param getFunctionCodeSigningConfigRequest
     * @return Result of the GetFunctionCodeSigningConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionCodeSigningConfigResponse getFunctionCodeSigningConfig(
            GetFunctionCodeSigningConfigRequest getFunctionCodeSigningConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException,
            LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the code signing configuration for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFunctionCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest.Builder} to create
     *        a request.
     * @return Result of the GetFunctionCodeSigningConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionCodeSigningConfigResponse getFunctionCodeSigningConfig(
            Consumer<GetFunctionCodeSigningConfigRequest.Builder> getFunctionCodeSigningConfigRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return getFunctionCodeSigningConfig(GetFunctionCodeSigningConfigRequest.builder()
                .applyMutation(getFunctionCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a
     * function, use <a>PutFunctionConcurrency</a>.
     * </p>
     *
     * @param getFunctionConcurrencyRequest
     * @return Result of the GetFunctionConcurrency operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFunctionConcurrencyResponse getFunctionConcurrency(GetFunctionConcurrencyRequest getFunctionConcurrencyRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a
     * function, use <a>PutFunctionConcurrency</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionConcurrencyRequest.Builder} avoiding the
     * need to create one manually via {@link GetFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param getFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return Result of the GetFunctionConcurrency operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFunctionConcurrencyResponse getFunctionConcurrency(
            Consumer<GetFunctionConcurrencyRequest.Builder> getFunctionConcurrencyRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        return getFunctionConcurrency(GetFunctionConcurrencyRequest.builder().applyMutation(getFunctionConcurrencyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return Result of the GetFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionConfigurationResponse getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param getFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionConfigurationResponse getFunctionConfiguration(
            Consumer<GetFunctionConfigurationRequest.Builder> getFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getFunctionConfiguration(GetFunctionConfigurationRequest.builder().applyMutation(getFunctionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param getFunctionEventInvokeConfigRequest
     * @return Result of the GetFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionEventInvokeConfigResponse getFunctionEventInvokeConfig(
            GetFunctionEventInvokeConfigRequest getFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest.Builder} to create
     *        a request.
     * @return Result of the GetFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionEventInvokeConfigResponse getFunctionEventInvokeConfig(
            Consumer<GetFunctionEventInvokeConfigRequest.Builder> getFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return getFunctionEventInvokeConfig(GetFunctionEventInvokeConfigRequest.builder()
                .applyMutation(getFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about a Lambda function URL.
     * </p>
     *
     * @param getFunctionUrlConfigRequest
     * @return Result of the GetFunctionUrlConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionUrlConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFunctionUrlConfigResponse getFunctionUrlConfig(GetFunctionUrlConfigRequest getFunctionUrlConfigRequest)
            throws InvalidParameterValueException, ServiceException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a Lambda function URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionUrlConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetFunctionUrlConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionUrlConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFunctionUrlConfigResponse getFunctionUrlConfig(
            Consumer<GetFunctionUrlConfigRequest.Builder> getFunctionUrlConfigRequest) throws InvalidParameterValueException,
            ServiceException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            LambdaException {
        return getFunctionUrlConfig(GetFunctionUrlConfigRequest.builder().applyMutation(getFunctionUrlConfigRequest).build());
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return Result of the GetLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLayerVersionResponse getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetLayerVersionRequest#builder()}
     * </p>
     *
     * @param getLayerVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest.Builder} to create a request.
     * @return Result of the GetLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLayerVersionResponse getLayerVersion(Consumer<GetLayerVersionRequest.Builder> getLayerVersionRequest)
            throws ServiceException, InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        return getLayerVersion(GetLayerVersionRequest.builder().applyMutation(getLayerVersionRequest).build());
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionByArnRequest
     * @return Result of the GetLayerVersionByArn operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionByArn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLayerVersionByArnResponse getLayerVersionByArn(GetLayerVersionByArnRequest getLayerVersionByArnRequest)
            throws ServiceException, InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionByArnRequest.Builder} avoiding the
     * need to create one manually via {@link GetLayerVersionByArnRequest#builder()}
     * </p>
     *
     * @param getLayerVersionByArnRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest.Builder} to create a
     *        request.
     * @return Result of the GetLayerVersionByArn operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionByArn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLayerVersionByArnResponse getLayerVersionByArn(
            Consumer<GetLayerVersionByArnRequest.Builder> getLayerVersionByArnRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        return getLayerVersionByArn(GetLayerVersionByArnRequest.builder().applyMutation(getLayerVersionByArnRequest).build());
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return Result of the GetLayerVersionPolicy operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLayerVersionPolicyResponse getLayerVersionPolicy(GetLayerVersionPolicyRequest getLayerVersionPolicyRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLayerVersionPolicyRequest#builder()}
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetLayerVersionPolicy operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLayerVersionPolicyResponse getLayerVersionPolicy(
            Consumer<GetLayerVersionPolicyRequest.Builder> getLayerVersionPolicyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getLayerVersionPolicy(GetLayerVersionPolicyRequest.builder().applyMutation(getLayerVersionPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetPolicyRequest.Builder} to create a request.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     * </p>
     *
     * @param getProvisionedConcurrencyConfigRequest
     * @return Result of the GetProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ProvisionedConcurrencyConfigNotFoundException
     *         The specified configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedConcurrencyConfigResponse getProvisionedConcurrencyConfig(
            GetProvisionedConcurrencyConfigRequest getProvisionedConcurrencyConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, ProvisionedConcurrencyConfigNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedConcurrencyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedConcurrencyConfigRequest#builder()}
     * </p>
     *
     * @param getProvisionedConcurrencyConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest.Builder} to
     *        create a request.
     * @return Result of the GetProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ProvisionedConcurrencyConfigNotFoundException
     *         The specified configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisionedConcurrencyConfigResponse getProvisionedConcurrencyConfig(
            Consumer<GetProvisionedConcurrencyConfigRequest.Builder> getProvisionedConcurrencyConfigRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            ProvisionedConcurrencyConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return getProvisionedConcurrencyConfig(GetProvisionedConcurrencyConfigRequest.builder()
                .applyMutation(getProvisionedConcurrencyConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves the runtime management configuration for a function's version. If the runtime update mode is
     * <b>Manual</b>, this includes the ARN of the runtime version and the runtime update mode. If the runtime update
     * mode is <b>Auto</b> or <b>Function update</b>, this includes the runtime update mode and <code>null</code> is
     * returned for the ARN. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     *
     * @param getRuntimeManagementConfigRequest
     * @return Result of the GetRuntimeManagementConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRuntimeManagementConfigResponse getRuntimeManagementConfig(
            GetRuntimeManagementConfigRequest getRuntimeManagementConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the runtime management configuration for a function's version. If the runtime update mode is
     * <b>Manual</b>, this includes the ARN of the runtime version and the runtime update mode. If the runtime update
     * mode is <b>Auto</b> or <b>Function update</b>, this includes the runtime update mode and <code>null</code> is
     * returned for the ARN. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuntimeManagementConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetRuntimeManagementConfigRequest#builder()}
     * </p>
     *
     * @param getRuntimeManagementConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetRuntimeManagementConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRuntimeManagementConfigResponse getRuntimeManagementConfig(
            Consumer<GetRuntimeManagementConfigRequest.Builder> getRuntimeManagementConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return getRuntimeManagementConfig(GetRuntimeManagementConfigRequest.builder()
                .applyMutation(getRuntimeManagementConfigRequest).build());
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
     * details about the function response, including errors, are included in the response body and headers. For either
     * invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.
     * </p>
     * <p>
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client,
     * event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error,
     * Lambda executes the function up to two more times. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html">Error handling and automatic retries
     * in Lambda</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
     * Lambda adds events to a queue before sending them to your function. If your function does not have enough
     * capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event
     * multiple times, even if no error occurs. To retain events that were not processed, configure your function with a
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">dead-letter
     * queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">quota</a> errors, or issues with
     * your function's code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if
     * running the function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for
     * a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections
     * with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     *
     * @param invokeRequest
     * @return Result of the Invoke operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidRequestContentException
     *         The request body could not be parsed as JSON.
     * @throws RequestTooLargeException
     *         The request payload exceeded the <code>Invoke</code> request body JSON input quota. For more information,
     *         see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws UnsupportedMediaTypeException
     *         The content type of the <code>Invoke</code> request body is not JSON.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws Ec2UnexpectedException
     *         Lambda received an unexpected Amazon EC2 client exception while setting up for the Lambda function.
     * @throws SubnetIpAddressLimitReachedException
     *         Lambda couldn't set up VPC access for the Lambda function because one or more configured subnets has no
     *         available IP addresses.
     * @throws EniLimitReachedException
     *         Lambda couldn't create an elastic network interface in the VPC, specified as part of Lambda function
     *         configuration, because the limit for network interfaces has been reached. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws EfsMountConnectivityException
     *         The Lambda function couldn't make a network connection to the configured file system.
     * @throws EfsMountFailureException
     *         The Lambda function couldn't mount the configured file system due to a permission or configuration issue.
     * @throws EfsMountTimeoutException
     *         The Lambda function made a network connection to the configured file system, but the mount operation
     *         timed out.
     * @throws EfsioException
     *         An error occurred when reading from or writing to a connected file system.
     * @throws SnapStartException
     *         The <code>afterRestore()</code> <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a>
     *         encountered an error. For more information, check the Amazon CloudWatch logs.
     * @throws SnapStartTimeoutException
     *         Lambda couldn't restore the snapshot within the timeout limit.
     * @throws SnapStartNotReadyException
     *         Lambda is initializing your function. You can invoke the function when the <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.
     * @throws Ec2ThrottledException
     *         Amazon EC2 throttled Lambda during Lambda function initialization using the execution role provided for
     *         the function.
     * @throws Ec2AccessDeniedException
     *         Need additional permissions to configure VPC settings.
     * @throws InvalidSubnetIdException
     *         The subnet ID provided in the Lambda function VPC configuration is not valid.
     * @throws InvalidSecurityGroupIdException
     *         The security group ID provided in the Lambda function VPC configuration is not valid.
     * @throws InvalidZipFileException
     *         Lambda could not unzip the deployment package.
     * @throws KmsDisabledException
     *         Lambda couldn't decrypt the environment variables because the KMS key used is disabled. Check the Lambda
     *         function's KMS key settings.
     * @throws KmsInvalidStateException
     *         Lambda couldn't decrypt the environment variables because the state of the KMS key used is not valid for
     *         Decrypt. Check the function's KMS key settings.
     * @throws KmsAccessDeniedException
     *         Lambda couldn't decrypt the environment variables because KMS access was denied. Check the Lambda
     *         function's KMS permissions.
     * @throws KmsNotFoundException
     *         Lambda couldn't decrypt the environment variables because the KMS key was not found. Check the function's
     *         KMS key settings.
     * @throws InvalidRuntimeException
     *         The runtime or runtime version specified is not supported.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotReadyException
     *         The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to
     *         reestablish and try again.
     * @throws RecursiveInvocationException
     *         Lambda has detected your function being invoked in a recursive loop with other Amazon Web Services
     *         resources and stopped your function's invocation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.Invoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default InvokeResponse invoke(InvokeRequest invokeRequest) throws ServiceException, ResourceNotFoundException,
            InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException, TooManyRequestsException,
            InvalidParameterValueException, Ec2UnexpectedException, SubnetIpAddressLimitReachedException,
            EniLimitReachedException, EfsMountConnectivityException, EfsMountFailureException, EfsMountTimeoutException,
            EfsioException, SnapStartException, SnapStartTimeoutException, SnapStartNotReadyException, Ec2ThrottledException,
            Ec2AccessDeniedException, InvalidSubnetIdException, InvalidSecurityGroupIdException, InvalidZipFileException,
            KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException,
            InvalidRuntimeException, ResourceConflictException, ResourceNotReadyException, RecursiveInvocationException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
     * details about the function response, including errors, are included in the response body and headers. For either
     * invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.
     * </p>
     * <p>
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client,
     * event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error,
     * Lambda executes the function up to two more times. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html">Error handling and automatic retries
     * in Lambda</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
     * Lambda adds events to a queue before sending them to your function. If your function does not have enough
     * capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event
     * multiple times, even if no error occurs. To retain events that were not processed, configure your function with a
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">dead-letter
     * queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">quota</a> errors, or issues with
     * your function's code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if
     * running the function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for
     * a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections
     * with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeRequest.Builder} avoiding the need to create
     * one manually via {@link InvokeRequest#builder()}
     * </p>
     *
     * @param invokeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.InvokeRequest.Builder} to create a request.
     * @return Result of the Invoke operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidRequestContentException
     *         The request body could not be parsed as JSON.
     * @throws RequestTooLargeException
     *         The request payload exceeded the <code>Invoke</code> request body JSON input quota. For more information,
     *         see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws UnsupportedMediaTypeException
     *         The content type of the <code>Invoke</code> request body is not JSON.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws Ec2UnexpectedException
     *         Lambda received an unexpected Amazon EC2 client exception while setting up for the Lambda function.
     * @throws SubnetIpAddressLimitReachedException
     *         Lambda couldn't set up VPC access for the Lambda function because one or more configured subnets has no
     *         available IP addresses.
     * @throws EniLimitReachedException
     *         Lambda couldn't create an elastic network interface in the VPC, specified as part of Lambda function
     *         configuration, because the limit for network interfaces has been reached. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws EfsMountConnectivityException
     *         The Lambda function couldn't make a network connection to the configured file system.
     * @throws EfsMountFailureException
     *         The Lambda function couldn't mount the configured file system due to a permission or configuration issue.
     * @throws EfsMountTimeoutException
     *         The Lambda function made a network connection to the configured file system, but the mount operation
     *         timed out.
     * @throws EfsioException
     *         An error occurred when reading from or writing to a connected file system.
     * @throws SnapStartException
     *         The <code>afterRestore()</code> <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a>
     *         encountered an error. For more information, check the Amazon CloudWatch logs.
     * @throws SnapStartTimeoutException
     *         Lambda couldn't restore the snapshot within the timeout limit.
     * @throws SnapStartNotReadyException
     *         Lambda is initializing your function. You can invoke the function when the <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.
     * @throws Ec2ThrottledException
     *         Amazon EC2 throttled Lambda during Lambda function initialization using the execution role provided for
     *         the function.
     * @throws Ec2AccessDeniedException
     *         Need additional permissions to configure VPC settings.
     * @throws InvalidSubnetIdException
     *         The subnet ID provided in the Lambda function VPC configuration is not valid.
     * @throws InvalidSecurityGroupIdException
     *         The security group ID provided in the Lambda function VPC configuration is not valid.
     * @throws InvalidZipFileException
     *         Lambda could not unzip the deployment package.
     * @throws KmsDisabledException
     *         Lambda couldn't decrypt the environment variables because the KMS key used is disabled. Check the Lambda
     *         function's KMS key settings.
     * @throws KmsInvalidStateException
     *         Lambda couldn't decrypt the environment variables because the state of the KMS key used is not valid for
     *         Decrypt. Check the function's KMS key settings.
     * @throws KmsAccessDeniedException
     *         Lambda couldn't decrypt the environment variables because KMS access was denied. Check the Lambda
     *         function's KMS permissions.
     * @throws KmsNotFoundException
     *         Lambda couldn't decrypt the environment variables because the KMS key was not found. Check the function's
     *         KMS key settings.
     * @throws InvalidRuntimeException
     *         The runtime or runtime version specified is not supported.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotReadyException
     *         The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to
     *         reestablish and try again.
     * @throws RecursiveInvocationException
     *         Lambda has detected your function being invoked in a recursive loop with other Amazon Web Services
     *         resources and stopped your function's invocation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.Invoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default InvokeResponse invoke(Consumer<InvokeRequest.Builder> invokeRequest) throws ServiceException,
            ResourceNotFoundException, InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException,
            TooManyRequestsException, InvalidParameterValueException, Ec2UnexpectedException,
            SubnetIpAddressLimitReachedException, EniLimitReachedException, EfsMountConnectivityException,
            EfsMountFailureException, EfsMountTimeoutException, EfsioException, SnapStartException, SnapStartTimeoutException,
            SnapStartNotReadyException, Ec2ThrottledException, Ec2AccessDeniedException, InvalidSubnetIdException,
            InvalidSecurityGroupIdException, InvalidZipFileException, KmsDisabledException, KmsInvalidStateException,
            KmsAccessDeniedException, KmsNotFoundException, InvalidRuntimeException, ResourceConflictException,
            ResourceNotReadyException, RecursiveInvocationException, AwsServiceException, SdkClientException, LambdaException {
        return invoke(InvokeRequest.builder().applyMutation(invokeRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
     * for a Lambda function.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
     * for a Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListAliasesRequest.Builder} to create a request.
     * @return Result of the ListAliases operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
     * for a Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return new ListAliasesIterable(this, listAliasesRequest);
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
     * for a Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListAliasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     * @return Result of the ListCodeSigningConfigs operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeSigningConfigsResponse listCodeSigningConfigs(ListCodeSigningConfigsRequest listCodeSigningConfigsRequest)
            throws ServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeSigningConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeSigningConfigsRequest#builder()}
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCodeSigningConfigs operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeSigningConfigsResponse listCodeSigningConfigs(
            Consumer<ListCodeSigningConfigsRequest.Builder> listCodeSigningConfigsRequest) throws ServiceException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return listCodeSigningConfigs(ListCodeSigningConfigsRequest.builder().applyMutation(listCodeSigningConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client.listCodeSigningConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client
     *             .listCodeSigningConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client.listCodeSigningConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeSigningConfigsIterable listCodeSigningConfigsPaginator(
            ListCodeSigningConfigsRequest listCodeSigningConfigsRequest) throws ServiceException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListCodeSigningConfigsIterable(this, listCodeSigningConfigsRequest);
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client.listCodeSigningConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client
     *             .listCodeSigningConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client.listCodeSigningConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeSigningConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeSigningConfigsRequest#builder()}
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeSigningConfigsIterable listCodeSigningConfigsPaginator(
            Consumer<ListCodeSigningConfigsRequest.Builder> listCodeSigningConfigsRequest) throws ServiceException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return listCodeSigningConfigsPaginator(ListCodeSigningConfigsRequest.builder()
                .applyMutation(listCodeSigningConfigsRequest).build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsResponse listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsResponse listEventSourceMappings(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().applyMutation(listEventSourceMappingsRequest)
                .build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     *
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see #listEventSourceMappings(ListEventSourceMappingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsResponse listEventSourceMappings() throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see #listEventSourceMappingsPaginator(ListEventSourceMappingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsIterable listEventSourceMappingsPaginator() throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsIterable listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListEventSourceMappingsIterable(this, listEventSourceMappingsRequest);
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsIterable listEventSourceMappingsPaginator(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder()
                .applyMutation(listEventSourceMappingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return Result of the ListFunctionEventInvokeConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionEventInvokeConfigsResponse listFunctionEventInvokeConfigs(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionEventInvokeConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionEventInvokeConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFunctionEventInvokeConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionEventInvokeConfigsResponse listFunctionEventInvokeConfigs(
            Consumer<ListFunctionEventInvokeConfigsRequest.Builder> listFunctionEventInvokeConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return listFunctionEventInvokeConfigs(ListFunctionEventInvokeConfigsRequest.builder()
                .applyMutation(listFunctionEventInvokeConfigsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client
     *             .listFunctionEventInvokeConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionEventInvokeConfigsIterable listFunctionEventInvokeConfigsPaginator(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        return new ListFunctionEventInvokeConfigsIterable(this, listFunctionEventInvokeConfigsRequest);
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client
     *             .listFunctionEventInvokeConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionEventInvokeConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionEventInvokeConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionEventInvokeConfigsIterable listFunctionEventInvokeConfigsPaginator(
            Consumer<ListFunctionEventInvokeConfigsRequest.Builder> listFunctionEventInvokeConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return listFunctionEventInvokeConfigsPaginator(ListFunctionEventInvokeConfigsRequest.builder()
                .applyMutation(listFunctionEventInvokeConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     * @return Result of the ListFunctionUrlConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFunctionUrlConfigsResponse listFunctionUrlConfigs(ListFunctionUrlConfigsRequest listFunctionUrlConfigsRequest)
            throws InvalidParameterValueException, ServiceException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionUrlConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFunctionUrlConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFunctionUrlConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFunctionUrlConfigsResponse listFunctionUrlConfigs(
            Consumer<ListFunctionUrlConfigsRequest.Builder> listFunctionUrlConfigsRequest) throws InvalidParameterValueException,
            ServiceException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            LambdaException {
        return listFunctionUrlConfigs(ListFunctionUrlConfigsRequest.builder().applyMutation(listFunctionUrlConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client.listFunctionUrlConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client
     *             .listFunctionUrlConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client.listFunctionUrlConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFunctionUrlConfigsIterable listFunctionUrlConfigsPaginator(
            ListFunctionUrlConfigsRequest listFunctionUrlConfigsRequest) throws InvalidParameterValueException, ServiceException,
            ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionUrlConfigsIterable(this, listFunctionUrlConfigsRequest);
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client.listFunctionUrlConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client
     *             .listFunctionUrlConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client.listFunctionUrlConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionUrlConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFunctionUrlConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFunctionUrlConfigsIterable listFunctionUrlConfigsPaginator(
            Consumer<ListFunctionUrlConfigsRequest.Builder> listFunctionUrlConfigsRequest) throws InvalidParameterValueException,
            ServiceException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            LambdaException {
        return listFunctionUrlConfigsPaginator(ListFunctionUrlConfigsRequest.builder()
                .applyMutation(listFunctionUrlConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsRequest.Builder} to create a request.
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws ServiceException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note>
     *
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see #listFunctions(ListFunctionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions() throws ServiceException, TooManyRequestsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return listFunctions(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see #listFunctionsPaginator(ListFunctionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator() throws ServiceException, TooManyRequestsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return listFunctionsPaginator(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionsIterable(this, listFunctionsRequest);
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws ServiceException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return listFunctionsPaginator(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     * @return Result of the ListFunctionsByCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionsByCodeSigningConfigResponse listFunctionsByCodeSigningConfig(
            ListFunctionsByCodeSigningConfigRequest listFunctionsByCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsByCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionsByCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest.Builder} to
     *        create a request.
     * @return Result of the ListFunctionsByCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionsByCodeSigningConfigResponse listFunctionsByCodeSigningConfig(
            Consumer<ListFunctionsByCodeSigningConfigRequest.Builder> listFunctionsByCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        return listFunctionsByCodeSigningConfig(ListFunctionsByCodeSigningConfigRequest.builder()
                .applyMutation(listFunctionsByCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client.listFunctionsByCodeSigningConfigPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client
     *             .listFunctionsByCodeSigningConfigPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client.listFunctionsByCodeSigningConfigPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionsByCodeSigningConfigIterable listFunctionsByCodeSigningConfigPaginator(
            ListFunctionsByCodeSigningConfigRequest listFunctionsByCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionsByCodeSigningConfigIterable(this, listFunctionsByCodeSigningConfigRequest);
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client.listFunctionsByCodeSigningConfigPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client
     *             .listFunctionsByCodeSigningConfigPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client.listFunctionsByCodeSigningConfigPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsByCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionsByCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionsByCodeSigningConfigIterable listFunctionsByCodeSigningConfigPaginator(
            Consumer<ListFunctionsByCodeSigningConfigRequest.Builder> listFunctionsByCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        return listFunctionsByCodeSigningConfigPaginator(ListFunctionsByCodeSigningConfigRequest.builder()
                .applyMutation(listFunctionsByCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return Result of the ListLayerVersions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsResponse listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayerVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLayerVersionsRequest#builder()}
     * </p>
     *
     * @param listLayerVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest.Builder} to create a request.
     * @return Result of the ListLayerVersions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsResponse listLayerVersions(Consumer<ListLayerVersionsRequest.Builder> listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return listLayerVersions(ListLayerVersionsRequest.builder().applyMutation(listLayerVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client
     *             .listLayerVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsIterable listLayerVersionsPaginator(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListLayerVersionsIterable(this, listLayerVersionsRequest);
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client
     *             .listLayerVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayerVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLayerVersionsRequest#builder()}
     * </p>
     *
     * @param listLayerVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsIterable listLayerVersionsPaginator(
            Consumer<ListLayerVersionsRequest.Builder> listLayerVersionsRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listLayerVersionsPaginator(ListLayerVersionsRequest.builder().applyMutation(listLayerVersionsRequest).build());
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     *
     * @param listLayersRequest
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersResponse listLayers(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayersRequest#builder()}
     * </p>
     *
     * @param listLayersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayersRequest.Builder} to create a request.
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersResponse listLayers(Consumer<ListLayersRequest.Builder> listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return listLayers(ListLayersRequest.builder().applyMutation(listLayersRequest).build());
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     *
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see #listLayers(ListLayersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersResponse listLayers() throws ServiceException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return listLayers(ListLayersRequest.builder().build());
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see #listLayersPaginator(ListLayersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersIterable listLayersPaginator() throws ServiceException, InvalidParameterValueException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return listLayersPaginator(ListLayersRequest.builder().build());
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     *
     * @param listLayersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersIterable listLayersPaginator(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListLayersIterable(this, listLayersRequest);
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayersRequest#builder()}
     * </p>
     *
     * @param listLayersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersIterable listLayersPaginator(Consumer<ListLayersRequest.Builder> listLayersRequest)
            throws ServiceException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listLayersPaginator(ListLayersRequest.builder().applyMutation(listLayersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return Result of the ListProvisionedConcurrencyConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedConcurrencyConfigsResponse listProvisionedConcurrencyConfigs(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedConcurrencyConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedConcurrencyConfigsRequest#builder()}
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest.Builder} to
     *        create a request.
     * @return Result of the ListProvisionedConcurrencyConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedConcurrencyConfigsResponse listProvisionedConcurrencyConfigs(
            Consumer<ListProvisionedConcurrencyConfigsRequest.Builder> listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return listProvisionedConcurrencyConfigs(ListProvisionedConcurrencyConfigsRequest.builder()
                .applyMutation(listProvisionedConcurrencyConfigsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client
     *             .listProvisionedConcurrencyConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedConcurrencyConfigsIterable listProvisionedConcurrencyConfigsPaginator(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListProvisionedConcurrencyConfigsIterable(this, listProvisionedConcurrencyConfigsRequest);
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client
     *             .listProvisionedConcurrencyConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedConcurrencyConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedConcurrencyConfigsRequest#builder()}
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedConcurrencyConfigsIterable listProvisionedConcurrencyConfigsPaginator(
            Consumer<ListProvisionedConcurrencyConfigsRequest.Builder> listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return listProvisionedConcurrencyConfigsPaginator(ListProvisionedConcurrencyConfigsRequest.builder()
                .applyMutation(listProvisionedConcurrencyConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return Result of the ListVersionsByFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionResponse listVersionsByFunction(ListVersionsByFunctionRequest listVersionsByFunctionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsByFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link ListVersionsByFunctionRequest#builder()}
     * </p>
     *
     * @param listVersionsByFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the ListVersionsByFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionResponse listVersionsByFunction(
            Consumer<ListVersionsByFunctionRequest.Builder> listVersionsByFunctionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listVersionsByFunction(ListVersionsByFunctionRequest.builder().applyMutation(listVersionsByFunctionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client
     *             .listVersionsByFunctionPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionIterable listVersionsByFunctionPaginator(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListVersionsByFunctionIterable(this, listVersionsByFunctionRequest);
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client
     *             .listVersionsByFunctionPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsByFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link ListVersionsByFunctionRequest#builder()}
     * </p>
     *
     * @param listVersionsByFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionIterable listVersionsByFunctionPaginator(
            Consumer<ListVersionsByFunctionRequest.Builder> listVersionsByFunctionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listVersionsByFunctionPaginator(ListVersionsByFunctionRequest.builder()
                .applyMutation(listVersionsByFunctionRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from
     * a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is
     * created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return Result of the PublishLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default PublishLayerVersionResponse publishLayerVersion(PublishLayerVersionRequest publishLayerVersionRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from
     * a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is
     * created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link PublishLayerVersionRequest#builder()}
     * </p>
     *
     * @param publishLayerVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest.Builder} to create a
     *        request.
     * @return Result of the PublishLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default PublishLayerVersionResponse publishLayerVersion(
            Consumer<PublishLayerVersionRequest.Builder> publishLayerVersionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, CodeStorageExceededException,
            AwsServiceException, SdkClientException, LambdaException {
        return publishLayerVersion(PublishLayerVersionRequest.builder().applyMutation(publishLayerVersionRequest).build());
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version.
     * Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before publishing a
     * version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return Result of the PublishVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishVersionResponse publishVersion(PublishVersionRequest publishVersionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, CodeStorageExceededException,
            PreconditionFailedException, ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version.
     * Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before publishing a
     * version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishVersionRequest.Builder} avoiding the need to
     * create one manually via {@link PublishVersionRequest#builder()}
     * </p>
     *
     * @param publishVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PublishVersionRequest.Builder} to create a request.
     * @return Result of the PublishVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishVersionResponse publishVersion(Consumer<PublishVersionRequest.Builder> publishVersionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, ResourceConflictException, AwsServiceException,
            SdkClientException, LambdaException {
        return publishVersion(PublishVersionRequest.builder().applyMutation(publishVersionRequest).build());
    }

    /**
     * <p>
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the
     * next time a user tries to deploy a code package to the function.
     * </p>
     *
     * @param putFunctionCodeSigningConfigRequest
     * @return Result of the PutFunctionCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFunctionCodeSigningConfigResponse putFunctionCodeSigningConfig(
            PutFunctionCodeSigningConfigRequest putFunctionCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ResourceConflictException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the
     * next time a user tries to deploy a code package to the function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link PutFunctionCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param putFunctionCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest.Builder} to create
     *        a request.
     * @return Result of the PutFunctionCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFunctionCodeSigningConfigResponse putFunctionCodeSigningConfig(
            Consumer<PutFunctionCodeSigningConfigRequest.Builder> putFunctionCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ResourceConflictException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return putFunctionCodeSigningConfig(PutFunctionCodeSigningConfigRequest.builder()
                .applyMutation(putFunctionCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html">Lambda function scaling</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return Result of the PutFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default PutFunctionConcurrencyResponse putFunctionConcurrency(PutFunctionConcurrencyRequest putFunctionConcurrencyRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html">Lambda function scaling</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionConcurrencyRequest.Builder} avoiding the
     * need to create one manually via {@link PutFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return Result of the PutFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default PutFunctionConcurrencyResponse putFunctionConcurrency(
            Consumer<PutFunctionConcurrencyRequest.Builder> putFunctionConcurrencyRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        return putFunctionConcurrency(PutFunctionConcurrencyRequest.builder().applyMutation(putFunctionConcurrencyRequest)
                .build());
    }

    /**
     * <p>
     * Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
     * invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or
     * alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without
     * affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.
     * </p>
     * <p>
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events
     * in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
     * invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
     * <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To send an invocation record to a queue, topic, function, or event bus, specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations"
     * >destination</a>. You can configure separate destinations for successful invocations (on-success) and events that
     * fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a
     * dead-letter queue.
     * </p>
     *
     * @param putFunctionEventInvokeConfigRequest
     * @return Result of the PutFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFunctionEventInvokeConfigResponse putFunctionEventInvokeConfig(
            PutFunctionEventInvokeConfigRequest putFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
     * invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or
     * alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without
     * affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.
     * </p>
     * <p>
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events
     * in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
     * invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
     * <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To send an invocation record to a queue, topic, function, or event bus, specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations"
     * >destination</a>. You can configure separate destinations for successful invocations (on-success) and events that
     * fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a
     * dead-letter queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link PutFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param putFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest.Builder} to create
     *        a request.
     * @return Result of the PutFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFunctionEventInvokeConfigResponse putFunctionEventInvokeConfig(
            Consumer<PutFunctionEventInvokeConfigRequest.Builder> putFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        return putFunctionEventInvokeConfig(PutFunctionEventInvokeConfigRequest.builder()
                .applyMutation(putFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Adds a provisioned concurrency configuration to a function's alias or version.
     * </p>
     *
     * @param putProvisionedConcurrencyConfigRequest
     * @return Result of the PutProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProvisionedConcurrencyConfigResponse putProvisionedConcurrencyConfig(
            PutProvisionedConcurrencyConfigRequest putProvisionedConcurrencyConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a provisioned concurrency configuration to a function's alias or version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProvisionedConcurrencyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link PutProvisionedConcurrencyConfigRequest#builder()}
     * </p>
     *
     * @param putProvisionedConcurrencyConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest.Builder} to
     *        create a request.
     * @return Result of the PutProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProvisionedConcurrencyConfigResponse putProvisionedConcurrencyConfig(
            Consumer<PutProvisionedConcurrencyConfigRequest.Builder> putProvisionedConcurrencyConfigRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException,
            TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        return putProvisionedConcurrencyConfig(PutProvisionedConcurrencyConfigRequest.builder()
                .applyMutation(putProvisionedConcurrencyConfigRequest).build());
    }

    /**
     * <p>
     * Sets the runtime management configuration for a function's version. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     *
     * @param putRuntimeManagementConfigRequest
     * @return Result of the PutRuntimeManagementConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRuntimeManagementConfigResponse putRuntimeManagementConfig(
            PutRuntimeManagementConfigRequest putRuntimeManagementConfigRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the runtime management configuration for a function's version. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuntimeManagementConfigRequest.Builder} avoiding
     * the need to create one manually via {@link PutRuntimeManagementConfigRequest#builder()}
     * </p>
     *
     * @param putRuntimeManagementConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest.Builder} to create a
     *        request.
     * @return Result of the PutRuntimeManagementConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRuntimeManagementConfigResponse putRuntimeManagementConfig(
            Consumer<PutRuntimeManagementConfigRequest.Builder> putRuntimeManagementConfigRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return putRuntimeManagementConfig(PutRuntimeManagementConfigRequest.builder()
                .applyMutation(putRuntimeManagementConfigRequest).build());
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return Result of the RemoveLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemoveLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveLayerVersionPermissionResponse removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveLayerVersionPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemoveLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveLayerVersionPermissionResponse removeLayerVersionPermission(
            Consumer<RemoveLayerVersionPermissionRequest.Builder> removeLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        return removeLayerVersionPermission(RemoveLayerVersionPermissionRequest.builder()
                .applyMutation(removeLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Revokes function-use permission from an Amazon Web Service or another Amazon Web Services account. You can get
     * the ID of the statement from the output of <a>GetPolicy</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes function-use permission from an Amazon Web Service or another Amazon Web Services account. You can get
     * the ID of the statement from the output of <a>GetPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.RemovePermissionRequest.Builder} to create a request.
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default RemovePermissionResponse removePermission(Consumer<RemovePermissionRequest.Builder> removePermissionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     *
     * @param updateAliasRequest
     * @return Result of the UpdateAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAliasRequest#builder()}
     * </p>
     *
     * @param updateAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateAliasRequest.Builder} to create a request.
     * @return Result of the UpdateAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAliasResponse updateAlias(Consumer<UpdateAliasRequest.Builder> updateAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        return updateAlias(UpdateAliasRequest.builder().applyMutation(updateAliasRequest).build());
    }

    /**
     * <p>
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user
     * tries to deploy a code package to the function.
     * </p>
     *
     * @param updateCodeSigningConfigRequest
     * @return Result of the UpdateCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCodeSigningConfigResponse updateCodeSigningConfig(UpdateCodeSigningConfigRequest updateCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user
     * tries to deploy a code package to the function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCodeSigningConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param updateCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCodeSigningConfigResponse updateCodeSigningConfig(
            Consumer<UpdateCodeSigningConfigRequest.Builder> updateCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return updateCodeSigningConfig(UpdateCodeSigningConfigRequest.builder().applyMutation(updateCodeSigningConfigRequest)
                .build());
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume
     * later from the same location.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateEventSourceMappingRequest
     * @return Result of the UpdateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you tried to update an event
     *         source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventSourceMappingResponse updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, ResourceInUseException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume
     * later from the same location.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param updateEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you tried to update an event
     *         source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventSourceMappingResponse updateEventSourceMapping(
            Consumer<UpdateEventSourceMappingRequest.Builder> updateEventSourceMappingRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            ResourceInUseException, AwsServiceException, SdkClientException, LambdaException {
        return updateEventSourceMapping(UpdateEventSourceMappingRequest.builder().applyMutation(updateEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by
     * a trusted publisher. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Configuring code signing for
     * Lambda</a>.
     * </p>
     * <p>
     * If the function's package type is <code>Image</code>, then you must specify the code package in
     * <code>ImageUri</code> as the URI of a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR
     * registry.
     * </p>
     * <p>
     * If the function's package type is <code>Zip</code>, then you must specify the deployment package as a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>. Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the
     * function code inline using the <code>ZipFile</code> field.
     * </p>
     * <p>
     * The code in the deployment package must be compatible with the target instruction set architecture of the
     * function (<code>x86-64</code> or <code>arm64</code>).
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     * <note>
     * <p>
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if
     * you update the image tag to a new image, Lambda does not automatically update the function.
     * </p>
     * </note>
     *
     * @param updateFunctionCodeRequest
     * @return Result of the UpdateFunctionCode operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionCodeResponse updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, ResourceConflictException,
            CodeVerificationFailedException, InvalidCodeSignatureException, CodeSigningConfigNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by
     * a trusted publisher. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Configuring code signing for
     * Lambda</a>.
     * </p>
     * <p>
     * If the function's package type is <code>Image</code>, then you must specify the code package in
     * <code>ImageUri</code> as the URI of a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR
     * registry.
     * </p>
     * <p>
     * If the function's package type is <code>Zip</code>, then you must specify the deployment package as a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>. Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the
     * function code inline using the <code>ZipFile</code> field.
     * </p>
     * <p>
     * The code in the deployment package must be compatible with the target instruction set architecture of the
     * function (<code>x86-64</code> or <code>arm64</code>).
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     * <note>
     * <p>
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if
     * you update the image tag to a new image, Lambda does not automatically update the function.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionCodeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFunctionCodeRequest#builder()}
     * </p>
     *
     * @param updateFunctionCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFunctionCode operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionCodeResponse updateFunctionCode(Consumer<UpdateFunctionCodeRequest.Builder> updateFunctionCodeRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, ResourceConflictException,
            CodeVerificationFailedException, InvalidCodeSignatureException, CodeSigningConfigNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        return updateFunctionCode(UpdateFunctionCodeRequest.builder().applyMutation(updateFunctionCodeRequest).build());
    }

    /**
     * <p>
     * Modify the version-specific settings of a Lambda function.
     * </p>
     * <p>
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but
     * you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
     * <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when
     * the update is complete and the function is processing events with the new configuration. For more information,
     * see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an Amazon
     * Web Services account or Amazon Web Service, use <a>AddPermission</a>.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return Result of the UpdateFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionConfigurationResponse updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            PreconditionFailedException, CodeVerificationFailedException, InvalidCodeSignatureException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify the version-specific settings of a Lambda function.
     * </p>
     * <p>
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but
     * you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
     * <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when
     * the update is complete and the function is processing events with the new configuration. For more information,
     * see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an Amazon
     * Web Services account or Amazon Web Service, use <a>AddPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionConfigurationResponse updateFunctionConfiguration(
            Consumer<UpdateFunctionConfigurationRequest.Builder> updateFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            PreconditionFailedException, CodeVerificationFailedException, InvalidCodeSignatureException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return updateFunctionConfiguration(UpdateFunctionConfigurationRequest.builder()
                .applyMutation(updateFunctionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param updateFunctionEventInvokeConfigRequest
     * @return Result of the UpdateFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionEventInvokeConfigResponse updateFunctionEventInvokeConfig(
            UpdateFunctionEventInvokeConfigRequest updateFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param updateFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionEventInvokeConfigResponse updateFunctionEventInvokeConfig(
            Consumer<UpdateFunctionEventInvokeConfigRequest.Builder> updateFunctionEventInvokeConfigRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        return updateFunctionEventInvokeConfig(UpdateFunctionEventInvokeConfigRequest.builder()
                .applyMutation(updateFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for a Lambda function URL.
     * </p>
     *
     * @param updateFunctionUrlConfigRequest
     * @return Result of the UpdateFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionUrlConfigResponse updateFunctionUrlConfig(UpdateFunctionUrlConfigRequest updateFunctionUrlConfigRequest)
            throws ResourceConflictException, ResourceNotFoundException, InvalidParameterValueException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a Lambda function URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionUrlConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param updateFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionUrlConfigResponse updateFunctionUrlConfig(
            Consumer<UpdateFunctionUrlConfigRequest.Builder> updateFunctionUrlConfigRequest) throws ResourceConflictException,
            ResourceNotFoundException, InvalidParameterValueException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return updateFunctionUrlConfig(UpdateFunctionUrlConfigRequest.builder().applyMutation(updateFunctionUrlConfigRequest)
                .build());
    }

    /**
     * Create an instance of {@link LambdaWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link LambdaWaiter}
     */
    default LambdaWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link LambdaClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LambdaClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LambdaClient}.
     */
    static LambdaClientBuilder builder() {
        return new DefaultLambdaClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LambdaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
