/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType;
import software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceChatterFeedConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceChatterFeedConfiguration> {
    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentDataFieldName").getter(SalesforceChatterFeedConfiguration.getter(SalesforceChatterFeedConfiguration::documentDataFieldName)).setter(SalesforceChatterFeedConfiguration.setter(Builder::documentDataFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentTitleFieldName").getter(SalesforceChatterFeedConfiguration.getter(SalesforceChatterFeedConfiguration::documentTitleFieldName)).setter(SalesforceChatterFeedConfiguration.setter(Builder::documentTitleFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(SalesforceChatterFeedConfiguration.getter(SalesforceChatterFeedConfiguration::fieldMappings)).setter(SalesforceChatterFeedConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_FILTER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeFilterTypes").getter(SalesforceChatterFeedConfiguration.getter(SalesforceChatterFeedConfiguration::includeFilterTypesAsStrings)).setter(SalesforceChatterFeedConfiguration.setter(Builder::includeFilterTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFilterTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD, INCLUDE_FILTER_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentDataFieldName;
    private final String documentTitleFieldName;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;
    private final List<String> includeFilterTypes;

    private SalesforceChatterFeedConfiguration(BuilderImpl builder) {
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
        this.includeFilterTypes = builder.includeFilterTypes;
    }

    public final String documentDataFieldName() {
        return this.documentDataFieldName;
    }

    public final String documentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public final List<SalesforceChatterFeedIncludeFilterType> includeFilterTypes() {
        return SalesforceChatterFeedIncludeFilterTypesCopier.copyStringToEnum(this.includeFilterTypes);
    }

    public final boolean hasIncludeFilterTypes() {
        return this.includeFilterTypes != null && !(this.includeFilterTypes instanceof SdkAutoConstructList);
    }

    public final List<String> includeFilterTypesAsStrings() {
        return this.includeFilterTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeFilterTypes() ? this.includeFilterTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceChatterFeedConfiguration)) {
            return false;
        }
        SalesforceChatterFeedConfiguration other = (SalesforceChatterFeedConfiguration)obj;
        return Objects.equals(this.documentDataFieldName(), other.documentDataFieldName()) && Objects.equals(this.documentTitleFieldName(), other.documentTitleFieldName()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings()) && this.hasIncludeFilterTypes() == other.hasIncludeFilterTypes() && Objects.equals(this.includeFilterTypesAsStrings(), other.includeFilterTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceChatterFeedConfiguration").add("DocumentDataFieldName", (Object)this.documentDataFieldName()).add("DocumentTitleFieldName", (Object)this.documentTitleFieldName()).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).add("IncludeFilterTypes", this.hasIncludeFilterTypes() ? this.includeFilterTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentDataFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentDataFieldName()));
            }
            case "DocumentTitleFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentTitleFieldName()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
            case "IncludeFilterTypes": {
                return Optional.ofNullable(clazz.cast(this.includeFilterTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceChatterFeedConfiguration, T> g) {
        return obj -> g.apply((SalesforceChatterFeedConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentDataFieldName;
        private String documentTitleFieldName;
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> includeFilterTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceChatterFeedConfiguration model) {
            this.documentDataFieldName(model.documentDataFieldName);
            this.documentTitleFieldName(model.documentTitleFieldName);
            this.fieldMappings(model.fieldMappings);
            this.includeFilterTypesWithStrings(model.includeFilterTypes);
        }

        public final String getDocumentDataFieldName() {
            return this.documentDataFieldName;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        @Override
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final String getDocumentTitleFieldName() {
            return this.documentTitleFieldName;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getIncludeFilterTypes() {
            if (this.includeFilterTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeFilterTypes;
        }

        public final void setIncludeFilterTypes(Collection<String> includeFilterTypes) {
            this.includeFilterTypes = SalesforceChatterFeedIncludeFilterTypesCopier.copy(includeFilterTypes);
        }

        @Override
        public final Builder includeFilterTypesWithStrings(Collection<String> includeFilterTypes) {
            this.includeFilterTypes = SalesforceChatterFeedIncludeFilterTypesCopier.copy(includeFilterTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilterTypesWithStrings(String ... includeFilterTypes) {
            this.includeFilterTypesWithStrings(Arrays.asList(includeFilterTypes));
            return this;
        }

        @Override
        public final Builder includeFilterTypes(Collection<SalesforceChatterFeedIncludeFilterType> includeFilterTypes) {
            this.includeFilterTypes = SalesforceChatterFeedIncludeFilterTypesCopier.copyEnumToString(includeFilterTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilterTypes(SalesforceChatterFeedIncludeFilterType ... includeFilterTypes) {
            this.includeFilterTypes(Arrays.asList(includeFilterTypes));
            return this;
        }

        public SalesforceChatterFeedConfiguration build() {
            return new SalesforceChatterFeedConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceChatterFeedConfiguration> {
        public Builder documentDataFieldName(String var1);

        public Builder documentTitleFieldName(String var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder includeFilterTypesWithStrings(Collection<String> var1);

        public Builder includeFilterTypesWithStrings(String ... var1);

        public Builder includeFilterTypes(Collection<SalesforceChatterFeedIncludeFilterType> var1);

        public Builder includeFilterTypes(SalesforceChatterFeedIncludeFilterType ... var1);
    }
}

