/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.endpoints.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class RuleResult {
    private static final RuleResult CARRY_ON = new RuleResult();
    private final String error;
    private final Endpoint endpoint;

    private RuleResult() {
        this.error = null;
        this.endpoint = null;
    }

    private RuleResult(String error) {
        this.error = (String)Validate.paramNotNull((Object)error, (String)"error");
        this.endpoint = null;
    }

    private RuleResult(Endpoint endpoint) {
        this.error = null;
        this.endpoint = (Endpoint)Validate.paramNotNull((Object)endpoint, (String)"endpoint");
    }

    public boolean canContinue() {
        return this.error == null && this.endpoint == null;
    }

    public boolean isResolved() {
        return !this.isUnresolved();
    }

    public boolean isUnresolved() {
        return this.error == null && this.endpoint == null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isEndpoint() {
        return this.endpoint != null;
    }

    public String error() {
        return this.error;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public static RuleResult error(String error) {
        return new RuleResult(error);
    }

    public static RuleResult carryOn() {
        return CARRY_ON;
    }

    public static RuleResult endpoint(Endpoint endpoint) {
        return new RuleResult(endpoint);
    }
}

