/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivschat.model.IvschatResponse;
import software.amazon.awssdk.services.ivschat.model.LoggingConfigurationIdentifierListCopier;
import software.amazon.awssdk.services.ivschat.model.MessageReviewHandler;
import software.amazon.awssdk.services.ivschat.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRoomResponse
extends IvschatResponse
implements ToCopyableBuilder<Builder, GetRoomResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetRoomResponse.getter(GetRoomResponse::arn)).setter(GetRoomResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetRoomResponse.getter(GetRoomResponse::id)).setter(GetRoomResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRoomResponse.getter(GetRoomResponse::name)).setter(GetRoomResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetRoomResponse.getter(GetRoomResponse::createTime)).setter(GetRoomResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetRoomResponse.getter(GetRoomResponse::updateTime)).setter(GetRoomResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMessageRatePerSecond").getter(GetRoomResponse.getter(GetRoomResponse::maximumMessageRatePerSecond)).setter(GetRoomResponse.setter(Builder::maximumMessageRatePerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageRatePerSecond").build()}).build();
    private static final SdkField<Integer> MAXIMUM_MESSAGE_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMessageLength").getter(GetRoomResponse.getter(GetRoomResponse::maximumMessageLength)).setter(GetRoomResponse.setter(Builder::maximumMessageLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageLength").build()}).build();
    private static final SdkField<MessageReviewHandler> MESSAGE_REVIEW_HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageReviewHandler").getter(GetRoomResponse.getter(GetRoomResponse::messageReviewHandler)).setter(GetRoomResponse.setter(Builder::messageReviewHandler)).constructor(MessageReviewHandler::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandler").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetRoomResponse.getter(GetRoomResponse::tags)).setter(GetRoomResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOGGING_CONFIGURATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loggingConfigurationIdentifiers").getter(GetRoomResponse.getter(GetRoomResponse::loggingConfigurationIdentifiers)).setter(GetRoomResponse.setter(Builder::loggingConfigurationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfigurationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD, MAXIMUM_MESSAGE_LENGTH_FIELD, MESSAGE_REVIEW_HANDLER_FIELD, TAGS_FIELD, LOGGING_CONFIGURATION_IDENTIFIERS_FIELD));
    private final String arn;
    private final String id;
    private final String name;
    private final Instant createTime;
    private final Instant updateTime;
    private final Integer maximumMessageRatePerSecond;
    private final Integer maximumMessageLength;
    private final MessageReviewHandler messageReviewHandler;
    private final Map<String, String> tags;
    private final List<String> loggingConfigurationIdentifiers;

    private GetRoomResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.maximumMessageRatePerSecond = builder.maximumMessageRatePerSecond;
        this.maximumMessageLength = builder.maximumMessageLength;
        this.messageReviewHandler = builder.messageReviewHandler;
        this.tags = builder.tags;
        this.loggingConfigurationIdentifiers = builder.loggingConfigurationIdentifiers;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final Integer maximumMessageRatePerSecond() {
        return this.maximumMessageRatePerSecond;
    }

    public final Integer maximumMessageLength() {
        return this.maximumMessageLength;
    }

    public final MessageReviewHandler messageReviewHandler() {
        return this.messageReviewHandler;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasLoggingConfigurationIdentifiers() {
        return this.loggingConfigurationIdentifiers != null && !(this.loggingConfigurationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> loggingConfigurationIdentifiers() {
        return this.loggingConfigurationIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMessageRatePerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMessageLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageReviewHandler());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingConfigurationIdentifiers() ? this.loggingConfigurationIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoomResponse)) {
            return false;
        }
        GetRoomResponse other = (GetRoomResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.maximumMessageRatePerSecond(), other.maximumMessageRatePerSecond()) && Objects.equals(this.maximumMessageLength(), other.maximumMessageLength()) && Objects.equals(this.messageReviewHandler(), other.messageReviewHandler()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasLoggingConfigurationIdentifiers() == other.hasLoggingConfigurationIdentifiers() && Objects.equals(this.loggingConfigurationIdentifiers(), other.loggingConfigurationIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"GetRoomResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("MaximumMessageRatePerSecond", (Object)this.maximumMessageRatePerSecond()).add("MaximumMessageLength", (Object)this.maximumMessageLength()).add("MessageReviewHandler", (Object)this.messageReviewHandler()).add("Tags", this.hasTags() ? this.tags() : null).add("LoggingConfigurationIdentifiers", this.hasLoggingConfigurationIdentifiers() ? this.loggingConfigurationIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "maximumMessageRatePerSecond": {
                return Optional.ofNullable(clazz.cast(this.maximumMessageRatePerSecond()));
            }
            case "maximumMessageLength": {
                return Optional.ofNullable(clazz.cast(this.maximumMessageLength()));
            }
            case "messageReviewHandler": {
                return Optional.ofNullable(clazz.cast(this.messageReviewHandler()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "loggingConfigurationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.loggingConfigurationIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRoomResponse, T> g) {
        return obj -> g.apply((GetRoomResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private Instant createTime;
        private Instant updateTime;
        private Integer maximumMessageRatePerSecond;
        private Integer maximumMessageLength;
        private MessageReviewHandler messageReviewHandler;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> loggingConfigurationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoomResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.maximumMessageRatePerSecond(model.maximumMessageRatePerSecond);
            this.maximumMessageLength(model.maximumMessageLength);
            this.messageReviewHandler(model.messageReviewHandler);
            this.tags(model.tags);
            this.loggingConfigurationIdentifiers(model.loggingConfigurationIdentifiers);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Integer getMaximumMessageRatePerSecond() {
            return this.maximumMessageRatePerSecond;
        }

        public final void setMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
        }

        @Override
        public final Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
            return this;
        }

        public final Integer getMaximumMessageLength() {
            return this.maximumMessageLength;
        }

        public final void setMaximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
        }

        @Override
        public final Builder maximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
            return this;
        }

        public final MessageReviewHandler.Builder getMessageReviewHandler() {
            return this.messageReviewHandler != null ? this.messageReviewHandler.toBuilder() : null;
        }

        public final void setMessageReviewHandler(MessageReviewHandler.BuilderImpl messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler != null ? messageReviewHandler.build() : null;
        }

        @Override
        public final Builder messageReviewHandler(MessageReviewHandler messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Collection<String> getLoggingConfigurationIdentifiers() {
            if (this.loggingConfigurationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loggingConfigurationIdentifiers;
        }

        public final void setLoggingConfigurationIdentifiers(Collection<String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = LoggingConfigurationIdentifierListCopier.copy(loggingConfigurationIdentifiers);
        }

        @Override
        public final Builder loggingConfigurationIdentifiers(Collection<String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = LoggingConfigurationIdentifierListCopier.copy(loggingConfigurationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurationIdentifiers(String ... loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers(Arrays.asList(loggingConfigurationIdentifiers));
            return this;
        }

        @Override
        public GetRoomResponse build() {
            return new GetRoomResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvschatResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRoomResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder maximumMessageRatePerSecond(Integer var1);

        public Builder maximumMessageLength(Integer var1);

        public Builder messageReviewHandler(MessageReviewHandler var1);

        default public Builder messageReviewHandler(Consumer<MessageReviewHandler.Builder> messageReviewHandler) {
            return this.messageReviewHandler((MessageReviewHandler)((MessageReviewHandler.Builder)MessageReviewHandler.builder().applyMutation(messageReviewHandler)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder loggingConfigurationIdentifiers(Collection<String> var1);

        public Builder loggingConfigurationIdentifiers(String ... var1);
    }
}

