/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum FlowExecutionEventType {
    EXECUTION_STARTED("EXECUTION_STARTED"),

    EXECUTION_FAILED("EXECUTION_FAILED"),

    EXECUTION_ABORTED("EXECUTION_ABORTED"),

    EXECUTION_SUCCEEDED("EXECUTION_SUCCEEDED"),

    STEP_STARTED("STEP_STARTED"),

    STEP_FAILED("STEP_FAILED"),

    STEP_SUCCEEDED("STEP_SUCCEEDED"),

    ACTIVITY_SCHEDULED("ACTIVITY_SCHEDULED"),

    ACTIVITY_STARTED("ACTIVITY_STARTED"),

    ACTIVITY_FAILED("ACTIVITY_FAILED"),

    ACTIVITY_SUCCEEDED("ACTIVITY_SUCCEEDED"),

    START_FLOW_EXECUTION_TASK("START_FLOW_EXECUTION_TASK"),

    SCHEDULE_NEXT_READY_STEPS_TASK("SCHEDULE_NEXT_READY_STEPS_TASK"),

    THING_ACTION_TASK("THING_ACTION_TASK"),

    THING_ACTION_TASK_FAILED("THING_ACTION_TASK_FAILED"),

    THING_ACTION_TASK_SUCCEEDED("THING_ACTION_TASK_SUCCEEDED"),

    ACKNOWLEDGE_TASK_MESSAGE("ACKNOWLEDGE_TASK_MESSAGE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FlowExecutionEventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return FlowExecutionEventType corresponding to the value
     */
    public static FlowExecutionEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FlowExecutionEventType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link FlowExecutionEventType}s
     */
    public static Set<FlowExecutionEventType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
