/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerAsyncClient;
import software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse;
import software.amazon.awssdk.services.iotroborunner.model.Site;

public class ListSitesPublisher
implements SdkPublisher<ListSitesResponse> {
    private final IotRoboRunnerAsyncClient client;
    private final ListSitesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSitesPublisher(IotRoboRunnerAsyncClient client, ListSitesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSitesPublisher(IotRoboRunnerAsyncClient client, ListSitesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSitesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSitesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Site> sites() {
        Function<ListSitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sites() != null) {
                return response.sites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSitesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSitesResponseFetcher
    implements AsyncPageFetcher<ListSitesResponse> {
        private ListSitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSitesResponse> nextPage(ListSitesResponse previousPage) {
            if (previousPage == null) {
                return ListSitesPublisher.this.client.listSites(ListSitesPublisher.this.firstRequest);
            }
            return ListSitesPublisher.this.client.listSites((ListSitesRequest)((Object)ListSitesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

