/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.UsageTotal;

public class ListUsageTotalsIterable
implements SdkIterable<ListUsageTotalsResponse> {
    private final Inspector2Client client;
    private final ListUsageTotalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsageTotalsIterable(Inspector2Client client, ListUsageTotalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUsageTotalsResponseFetcher();
    }

    public Iterator<ListUsageTotalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsageTotal> totals() {
        Function<ListUsageTotalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.totals() != null) {
                return response.totals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUsageTotalsResponseFetcher
    implements SyncPageFetcher<ListUsageTotalsResponse> {
        private ListUsageTotalsResponseFetcher() {
        }

        public boolean hasNextPage(ListUsageTotalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsageTotalsResponse nextPage(ListUsageTotalsResponse previousPage) {
            if (previousPage == null) {
                return ListUsageTotalsIterable.this.client.listUsageTotals(ListUsageTotalsIterable.this.firstRequest);
            }
            return ListUsageTotalsIterable.this.client.listUsageTotals((ListUsageTotalsRequest)((Object)ListUsageTotalsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

