/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;

public class ListInstanceProfilesIterable
implements SdkIterable<ListInstanceProfilesResponse> {
    private final IamClient client;
    private final ListInstanceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceProfilesIterable(IamClient client, ListInstanceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstanceProfilesResponseFetcher();
    }

    public Iterator<ListInstanceProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProfiles() != null) {
                return response.instanceProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstanceProfilesResponseFetcher
    implements SyncPageFetcher<ListInstanceProfilesResponse> {
        private ListInstanceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListInstanceProfilesResponse nextPage(ListInstanceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesIterable.this.client.listInstanceProfiles(ListInstanceProfilesIterable.this.firstRequest);
            }
            return ListInstanceProfilesIterable.this.client.listInstanceProfiles((ListInstanceProfilesRequest)((Object)ListInstanceProfilesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

