/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;

public class ListInstanceProfilesForRoleIterable
implements SdkIterable<ListInstanceProfilesForRoleResponse> {
    private final IamClient client;
    private final ListInstanceProfilesForRoleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceProfilesForRoleIterable(IamClient client, ListInstanceProfilesForRoleRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstanceProfilesForRoleResponseFetcher();
    }

    public Iterator<ListInstanceProfilesForRoleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesForRoleResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProfiles() != null) {
                return response.instanceProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstanceProfilesForRoleResponseFetcher
    implements SyncPageFetcher<ListInstanceProfilesForRoleResponse> {
        private ListInstanceProfilesForRoleResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesForRoleResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListInstanceProfilesForRoleResponse nextPage(ListInstanceProfilesForRoleResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesForRoleIterable.this.client.listInstanceProfilesForRole(ListInstanceProfilesForRoleIterable.this.firstRequest);
            }
            return ListInstanceProfilesForRoleIterable.this.client.listInstanceProfilesForRole((ListInstanceProfilesForRoleRequest)((Object)ListInstanceProfilesForRoleIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

