/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.LambdaContainerParams;
import software.amazon.awssdk.services.greengrassv2.model.LambdaIsolationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaLinuxProcessParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaLinuxProcessParams> {
    private static final SdkField<String> ISOLATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("isolationMode").getter(LambdaLinuxProcessParams.getter(LambdaLinuxProcessParams::isolationModeAsString)).setter(LambdaLinuxProcessParams.setter(Builder::isolationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isolationMode").build()}).build();
    private static final SdkField<LambdaContainerParams> CONTAINER_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerParams").getter(LambdaLinuxProcessParams.getter(LambdaLinuxProcessParams::containerParams)).setter(LambdaLinuxProcessParams.setter(Builder::containerParams)).constructor(LambdaContainerParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISOLATION_MODE_FIELD, CONTAINER_PARAMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String isolationMode;
    private final LambdaContainerParams containerParams;

    private LambdaLinuxProcessParams(BuilderImpl builder) {
        this.isolationMode = builder.isolationMode;
        this.containerParams = builder.containerParams;
    }

    public final LambdaIsolationMode isolationMode() {
        return LambdaIsolationMode.fromValue(this.isolationMode);
    }

    public final String isolationModeAsString() {
        return this.isolationMode;
    }

    public final LambdaContainerParams containerParams() {
        return this.containerParams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isolationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaLinuxProcessParams)) {
            return false;
        }
        LambdaLinuxProcessParams other = (LambdaLinuxProcessParams)obj;
        return Objects.equals(this.isolationModeAsString(), other.isolationModeAsString()) && Objects.equals(this.containerParams(), other.containerParams());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaLinuxProcessParams").add("IsolationMode", (Object)this.isolationModeAsString()).add("ContainerParams", (Object)this.containerParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isolationMode": {
                return Optional.ofNullable(clazz.cast(this.isolationModeAsString()));
            }
            case "containerParams": {
                return Optional.ofNullable(clazz.cast(this.containerParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaLinuxProcessParams, T> g) {
        return obj -> g.apply((LambdaLinuxProcessParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String isolationMode;
        private LambdaContainerParams containerParams;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaLinuxProcessParams model) {
            this.isolationMode(model.isolationMode);
            this.containerParams(model.containerParams);
        }

        public final String getIsolationMode() {
            return this.isolationMode;
        }

        public final void setIsolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
        }

        @Override
        public final Builder isolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
            return this;
        }

        @Override
        public final Builder isolationMode(LambdaIsolationMode isolationMode) {
            this.isolationMode(isolationMode == null ? null : isolationMode.toString());
            return this;
        }

        public final LambdaContainerParams.Builder getContainerParams() {
            return this.containerParams != null ? this.containerParams.toBuilder() : null;
        }

        public final void setContainerParams(LambdaContainerParams.BuilderImpl containerParams) {
            this.containerParams = containerParams != null ? containerParams.build() : null;
        }

        @Override
        public final Builder containerParams(LambdaContainerParams containerParams) {
            this.containerParams = containerParams;
            return this;
        }

        public LambdaLinuxProcessParams build() {
            return new LambdaLinuxProcessParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaLinuxProcessParams> {
        public Builder isolationMode(String var1);

        public Builder isolationMode(LambdaIsolationMode var1);

        public Builder containerParams(LambdaContainerParams var1);

        default public Builder containerParams(Consumer<LambdaContainerParams.Builder> containerParams) {
            return this.containerParams((LambdaContainerParams)((LambdaContainerParams.Builder)LambdaContainerParams.builder().applyMutation(containerParams)).build());
        }
    }
}

