/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Segment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPartitionsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetPartitionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetPartitionsRequest.getter(GetPartitionsRequest::catalogId)).setter(GetPartitionsRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetPartitionsRequest.getter(GetPartitionsRequest::databaseName)).setter(GetPartitionsRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetPartitionsRequest.getter(GetPartitionsRequest::tableName)).setter(GetPartitionsRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(GetPartitionsRequest.getter(GetPartitionsRequest::expression)).setter(GetPartitionsRequest.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetPartitionsRequest.getter(GetPartitionsRequest::nextToken)).setter(GetPartitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Segment").getter(GetPartitionsRequest.getter(GetPartitionsRequest::segment)).setter(GetPartitionsRequest.setter(Builder::segment)).constructor(Segment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetPartitionsRequest.getter(GetPartitionsRequest::maxResults)).setter(GetPartitionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_COLUMN_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeColumnSchema").getter(GetPartitionsRequest.getter(GetPartitionsRequest::excludeColumnSchema)).setter(GetPartitionsRequest.setter(Builder::excludeColumnSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeColumnSchema").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(GetPartitionsRequest.getter(GetPartitionsRequest::transactionId)).setter(GetPartitionsRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueryAsOfTime").getter(GetPartitionsRequest.getter(GetPartitionsRequest::queryAsOfTime)).setter(GetPartitionsRequest.setter(Builder::queryAsOfTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, EXPRESSION_FIELD, NEXT_TOKEN_FIELD, SEGMENT_FIELD, MAX_RESULTS_FIELD, EXCLUDE_COLUMN_SCHEMA_FIELD, TRANSACTION_ID_FIELD, QUERY_AS_OF_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPartitionsRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final String expression;
    private final String nextToken;
    private final Segment segment;
    private final Integer maxResults;
    private final Boolean excludeColumnSchema;
    private final String transactionId;
    private final Instant queryAsOfTime;

    private GetPartitionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.expression = builder.expression;
        this.nextToken = builder.nextToken;
        this.segment = builder.segment;
        this.maxResults = builder.maxResults;
        this.excludeColumnSchema = builder.excludeColumnSchema;
        this.transactionId = builder.transactionId;
        this.queryAsOfTime = builder.queryAsOfTime;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String expression() {
        return this.expression;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Segment segment() {
        return this.segment;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean excludeColumnSchema() {
        return this.excludeColumnSchema;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final Instant queryAsOfTime() {
        return this.queryAsOfTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeColumnSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAsOfTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionsRequest)) {
            return false;
        }
        GetPartitionsRequest other = (GetPartitionsRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.excludeColumnSchema(), other.excludeColumnSchema()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.queryAsOfTime(), other.queryAsOfTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetPartitionsRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("Expression", (Object)this.expression()).add("NextToken", (Object)this.nextToken()).add("Segment", (Object)this.segment()).add("MaxResults", (Object)this.maxResults()).add("ExcludeColumnSchema", (Object)this.excludeColumnSchema()).add("TransactionId", (Object)this.transactionId()).add("QueryAsOfTime", (Object)this.queryAsOfTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ExcludeColumnSchema": {
                return Optional.ofNullable(clazz.cast(this.excludeColumnSchema()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "QueryAsOfTime": {
                return Optional.ofNullable(clazz.cast(this.queryAsOfTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Segment", SEGMENT_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ExcludeColumnSchema", EXCLUDE_COLUMN_SCHEMA_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("QueryAsOfTime", QUERY_AS_OF_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPartitionsRequest, T> g) {
        return obj -> g.apply((GetPartitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private String expression;
        private String nextToken;
        private Segment segment;
        private Integer maxResults;
        private Boolean excludeColumnSchema;
        private String transactionId;
        private Instant queryAsOfTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartitionsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.expression(model.expression);
            this.nextToken(model.nextToken);
            this.segment(model.segment);
            this.maxResults(model.maxResults);
            this.excludeColumnSchema(model.excludeColumnSchema);
            this.transactionId(model.transactionId);
            this.queryAsOfTime(model.queryAsOfTime);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Segment.Builder getSegment() {
            return this.segment != null ? this.segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getExcludeColumnSchema() {
            return this.excludeColumnSchema;
        }

        public final void setExcludeColumnSchema(Boolean excludeColumnSchema) {
            this.excludeColumnSchema = excludeColumnSchema;
        }

        @Override
        public final Builder excludeColumnSchema(Boolean excludeColumnSchema) {
            this.excludeColumnSchema = excludeColumnSchema;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return this.queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPartitionsRequest build() {
            return new GetPartitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPartitionsRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder expression(String var1);

        public Builder nextToken(String var1);

        public Builder segment(Segment var1);

        default public Builder segment(Consumer<Segment.Builder> segment) {
            return this.segment((Segment)((Segment.Builder)Segment.builder().applyMutation(segment)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder excludeColumnSchema(Boolean var1);

        public Builder transactionId(String var1);

        public Builder queryAsOfTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

