/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TestConnectionInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestConnectionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, TestConnectionRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(TestConnectionRequest.getter(TestConnectionRequest::connectionName)).setter(TestConnectionRequest.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(TestConnectionRequest.getter(TestConnectionRequest::catalogId)).setter(TestConnectionRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<TestConnectionInput> TEST_CONNECTION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TestConnectionInput").getter(TestConnectionRequest.getter(TestConnectionRequest::testConnectionInput)).setter(TestConnectionRequest.setter(Builder::testConnectionInput)).constructor(TestConnectionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestConnectionInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, CATALOG_ID_FIELD, TEST_CONNECTION_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestConnectionRequest.memberNameToFieldInitializer();
    private final String connectionName;
    private final String catalogId;
    private final TestConnectionInput testConnectionInput;

    private TestConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.catalogId = builder.catalogId;
        this.testConnectionInput = builder.testConnectionInput;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final TestConnectionInput testConnectionInput() {
        return this.testConnectionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConnectionInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionRequest)) {
            return false;
        }
        TestConnectionRequest other = (TestConnectionRequest)((Object)obj);
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.testConnectionInput(), other.testConnectionInput());
    }

    public final String toString() {
        return ToString.builder((String)"TestConnectionRequest").add("ConnectionName", (Object)this.connectionName()).add("CatalogId", (Object)this.catalogId()).add("TestConnectionInput", (Object)this.testConnectionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "TestConnectionInput": {
                return Optional.ofNullable(clazz.cast(this.testConnectionInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("TestConnectionInput", TEST_CONNECTION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestConnectionRequest, T> g) {
        return obj -> g.apply((TestConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String connectionName;
        private String catalogId;
        private TestConnectionInput testConnectionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionRequest model) {
            super(model);
            this.connectionName(model.connectionName);
            this.catalogId(model.catalogId);
            this.testConnectionInput(model.testConnectionInput);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final TestConnectionInput.Builder getTestConnectionInput() {
            return this.testConnectionInput != null ? this.testConnectionInput.toBuilder() : null;
        }

        public final void setTestConnectionInput(TestConnectionInput.BuilderImpl testConnectionInput) {
            this.testConnectionInput = testConnectionInput != null ? testConnectionInput.build() : null;
        }

        @Override
        public final Builder testConnectionInput(TestConnectionInput testConnectionInput) {
            this.testConnectionInput = testConnectionInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestConnectionRequest build() {
            return new TestConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestConnectionRequest> {
        public Builder connectionName(String var1);

        public Builder catalogId(String var1);

        public Builder testConnectionInput(TestConnectionInput var1);

        default public Builder testConnectionInput(Consumer<TestConnectionInput.Builder> testConnectionInput) {
            return this.testConnectionInput((TestConnectionInput)((TestConnectionInput.Builder)TestConnectionInput.builder().applyMutation(testConnectionInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

