/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PrimaryKeyListCopier;
import software.amazon.awssdk.services.glue.model.SourceTableFieldsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceTableConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceTableConfig> {
    private static final SdkField<List<String>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(SourceTableConfig.getter(SourceTableConfig::fields)).setter(SourceTableConfig.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILTER_PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterPredicate").getter(SourceTableConfig.getter(SourceTableConfig::filterPredicate)).setter(SourceTableConfig.setter(Builder::filterPredicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPredicate").build()}).build();
    private static final SdkField<List<String>> PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryKey").getter(SourceTableConfig.getter(SourceTableConfig::primaryKey)).setter(SourceTableConfig.setter(Builder::primaryKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKey").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECORD_UPDATE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordUpdateField").getter(SourceTableConfig.getter(SourceTableConfig::recordUpdateField)).setter(SourceTableConfig.setter(Builder::recordUpdateField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordUpdateField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, FILTER_PREDICATE_FIELD, PRIMARY_KEY_FIELD, RECORD_UPDATE_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceTableConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> fields;
    private final String filterPredicate;
    private final List<String> primaryKey;
    private final String recordUpdateField;

    private SourceTableConfig(BuilderImpl builder) {
        this.fields = builder.fields;
        this.filterPredicate = builder.filterPredicate;
        this.primaryKey = builder.primaryKey;
        this.recordUpdateField = builder.recordUpdateField;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final String filterPredicate() {
        return this.filterPredicate;
    }

    public final boolean hasPrimaryKey() {
        return this.primaryKey != null && !(this.primaryKey instanceof SdkAutoConstructList);
    }

    public final List<String> primaryKey() {
        return this.primaryKey;
    }

    public final String recordUpdateField() {
        return this.recordUpdateField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryKey() ? this.primaryKey() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordUpdateField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableConfig)) {
            return false;
        }
        SourceTableConfig other = (SourceTableConfig)obj;
        return this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.filterPredicate(), other.filterPredicate()) && this.hasPrimaryKey() == other.hasPrimaryKey() && Objects.equals(this.primaryKey(), other.primaryKey()) && Objects.equals(this.recordUpdateField(), other.recordUpdateField());
    }

    public final String toString() {
        return ToString.builder((String)"SourceTableConfig").add("Fields", this.hasFields() ? this.fields() : null).add("FilterPredicate", (Object)this.filterPredicate()).add("PrimaryKey", this.hasPrimaryKey() ? this.primaryKey() : null).add("RecordUpdateField", (Object)this.recordUpdateField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "FilterPredicate": {
                return Optional.ofNullable(clazz.cast(this.filterPredicate()));
            }
            case "PrimaryKey": {
                return Optional.ofNullable(clazz.cast(this.primaryKey()));
            }
            case "RecordUpdateField": {
                return Optional.ofNullable(clazz.cast(this.recordUpdateField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Fields", FIELDS_FIELD);
        map.put("FilterPredicate", FILTER_PREDICATE_FIELD);
        map.put("PrimaryKey", PRIMARY_KEY_FIELD);
        map.put("RecordUpdateField", RECORD_UPDATE_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceTableConfig, T> g) {
        return obj -> g.apply((SourceTableConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> fields = DefaultSdkAutoConstructList.getInstance();
        private String filterPredicate;
        private List<String> primaryKey = DefaultSdkAutoConstructList.getInstance();
        private String recordUpdateField;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableConfig model) {
            this.fields(model.fields);
            this.filterPredicate(model.filterPredicate);
            this.primaryKey(model.primaryKey);
            this.recordUpdateField(model.recordUpdateField);
        }

        public final Collection<String> getFields() {
            if (this.fields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fields;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = SourceTableFieldsListCopier.copy(fields);
        }

        @Override
        public final Builder fields(Collection<String> fields) {
            this.fields = SourceTableFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(String ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        public final String getFilterPredicate() {
            return this.filterPredicate;
        }

        public final void setFilterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        @Override
        public final Builder filterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
            return this;
        }

        public final Collection<String> getPrimaryKey() {
            if (this.primaryKey instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryKey;
        }

        public final void setPrimaryKey(Collection<String> primaryKey) {
            this.primaryKey = PrimaryKeyListCopier.copy(primaryKey);
        }

        @Override
        public final Builder primaryKey(Collection<String> primaryKey) {
            this.primaryKey = PrimaryKeyListCopier.copy(primaryKey);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryKey(String ... primaryKey) {
            this.primaryKey(Arrays.asList(primaryKey));
            return this;
        }

        public final String getRecordUpdateField() {
            return this.recordUpdateField;
        }

        public final void setRecordUpdateField(String recordUpdateField) {
            this.recordUpdateField = recordUpdateField;
        }

        @Override
        public final Builder recordUpdateField(String recordUpdateField) {
            this.recordUpdateField = recordUpdateField;
            return this;
        }

        public SourceTableConfig build() {
            return new SourceTableConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceTableConfig> {
        public Builder fields(Collection<String> var1);

        public Builder fields(String ... var1);

        public Builder filterPredicate(String var1);

        public Builder primaryKey(Collection<String> var1);

        public Builder primaryKey(String ... var1);

        public Builder recordUpdateField(String var1);
    }
}

