/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RedshiftSource.getter(RedshiftSource::name)).setter(RedshiftSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(RedshiftSource.getter(RedshiftSource::database)).setter(RedshiftSource.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(RedshiftSource.getter(RedshiftSource::table)).setter(RedshiftSource.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> REDSHIFT_TMP_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftTmpDir").getter(RedshiftSource.getter(RedshiftSource::redshiftTmpDir)).setter(RedshiftSource.setter(Builder::redshiftTmpDir)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTmpDir").build()}).build();
    private static final SdkField<String> TMP_DIR_IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TmpDirIAMRole").getter(RedshiftSource.getter(RedshiftSource::tmpDirIAMRole)).setter(RedshiftSource.setter(Builder::tmpDirIAMRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TmpDirIAMRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD, TABLE_FIELD, REDSHIFT_TMP_DIR_FIELD, TMP_DIR_IAM_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String database;
    private final String table;
    private final String redshiftTmpDir;
    private final String tmpDirIAMRole;

    private RedshiftSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.redshiftTmpDir = builder.redshiftTmpDir;
        this.tmpDirIAMRole = builder.tmpDirIAMRole;
    }

    public final String name() {
        return this.name;
    }

    public final String database() {
        return this.database;
    }

    public final String table() {
        return this.table;
    }

    public final String redshiftTmpDir() {
        return this.redshiftTmpDir;
    }

    public final String tmpDirIAMRole() {
        return this.tmpDirIAMRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftTmpDir());
        hashCode = 31 * hashCode + Objects.hashCode(this.tmpDirIAMRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSource)) {
            return false;
        }
        RedshiftSource other = (RedshiftSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.redshiftTmpDir(), other.redshiftTmpDir()) && Objects.equals(this.tmpDirIAMRole(), other.tmpDirIAMRole());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftSource").add("Name", (Object)this.name()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("RedshiftTmpDir", (Object)this.redshiftTmpDir()).add("TmpDirIAMRole", (Object)this.tmpDirIAMRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "RedshiftTmpDir": {
                return Optional.ofNullable(clazz.cast(this.redshiftTmpDir()));
            }
            case "TmpDirIAMRole": {
                return Optional.ofNullable(clazz.cast(this.tmpDirIAMRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("RedshiftTmpDir", REDSHIFT_TMP_DIR_FIELD);
        map.put("TmpDirIAMRole", TMP_DIR_IAM_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSource, T> g) {
        return obj -> g.apply((RedshiftSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String database;
        private String table;
        private String redshiftTmpDir;
        private String tmpDirIAMRole;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSource model) {
            this.name(model.name);
            this.database(model.database);
            this.table(model.table);
            this.redshiftTmpDir(model.redshiftTmpDir);
            this.tmpDirIAMRole(model.tmpDirIAMRole);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getRedshiftTmpDir() {
            return this.redshiftTmpDir;
        }

        public final void setRedshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
        }

        @Override
        public final Builder redshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
            return this;
        }

        public final String getTmpDirIAMRole() {
            return this.tmpDirIAMRole;
        }

        public final void setTmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
        }

        @Override
        public final Builder tmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
            return this;
        }

        public RedshiftSource build() {
            return new RedshiftSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftSource> {
        public Builder name(String var1);

        public Builder database(String var1);

        public Builder table(String var1);

        public Builder redshiftTmpDir(String var1);

        public Builder tmpDirIAMRole(String var1);
    }
}

