/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueStudioPathListCopier;
import software.amazon.awssdk.services.glue.model.TwoInputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Merge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Merge> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Merge.getter(Merge::name)).setter(Merge.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(Merge.getter(Merge::inputs)).setter(Merge.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Merge.getter(Merge::source)).setter(Merge.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<List<String>>> PRIMARY_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryKeys").getter(Merge.getter(Merge::primaryKeys)).setter(Merge.setter(Builder::primaryKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, SOURCE_FIELD, PRIMARY_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Merge.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String source;
    private final List<List<String>> primaryKeys;

    private Merge(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.source = builder.source;
        this.primaryKeys = builder.primaryKeys;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasPrimaryKeys() {
        return this.primaryKeys != null && !(this.primaryKeys instanceof SdkAutoConstructList);
    }

    public final List<List<String>> primaryKeys() {
        return this.primaryKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryKeys() ? this.primaryKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Merge)) {
            return false;
        }
        Merge other = (Merge)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.source(), other.source()) && this.hasPrimaryKeys() == other.hasPrimaryKeys() && Objects.equals(this.primaryKeys(), other.primaryKeys());
    }

    public final String toString() {
        return ToString.builder((String)"Merge").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Source", (Object)this.source()).add("PrimaryKeys", this.hasPrimaryKeys() ? this.primaryKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "PrimaryKeys": {
                return Optional.ofNullable(clazz.cast(this.primaryKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("PrimaryKeys", PRIMARY_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Merge, T> g) {
        return obj -> g.apply((Merge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String source;
        private List<List<String>> primaryKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Merge model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.source(model.source);
            this.primaryKeys(model.primaryKeys);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = TwoInputsCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = TwoInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Collection<? extends Collection<String>> getPrimaryKeys() {
            if (this.primaryKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryKeys;
        }

        public final void setPrimaryKeys(Collection<? extends Collection<String>> primaryKeys) {
            this.primaryKeys = GlueStudioPathListCopier.copy(primaryKeys);
        }

        @Override
        public final Builder primaryKeys(Collection<? extends Collection<String>> primaryKeys) {
            this.primaryKeys = GlueStudioPathListCopier.copy(primaryKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryKeys(Collection<String> ... primaryKeys) {
            this.primaryKeys((Collection<? extends Collection<String>>)Arrays.asList(primaryKeys));
            return this;
        }

        public Merge build() {
            return new Merge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Merge> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder source(String var1);

        public Builder primaryKeys(Collection<? extends Collection<String>> var1);

        public Builder primaryKeys(Collection<String> ... var1);
    }
}

