/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionAttempt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionAttempt> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExecutionAttempt.getter(ExecutionAttempt::statusAsString)).setter(ExecutionAttempt.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> COLUMN_STATISTICS_TASK_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnStatisticsTaskRunId").getter(ExecutionAttempt.getter(ExecutionAttempt::columnStatisticsTaskRunId)).setter(ExecutionAttempt.setter(Builder::columnStatisticsTaskRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunId").build()}).build();
    private static final SdkField<Instant> EXECUTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionTimestamp").getter(ExecutionAttempt.getter(ExecutionAttempt::executionTimestamp)).setter(ExecutionAttempt.setter(Builder::executionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimestamp").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ExecutionAttempt.getter(ExecutionAttempt::errorMessage)).setter(ExecutionAttempt.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, COLUMN_STATISTICS_TASK_RUN_ID_FIELD, EXECUTION_TIMESTAMP_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionAttempt.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String columnStatisticsTaskRunId;
    private final Instant executionTimestamp;
    private final String errorMessage;

    private ExecutionAttempt(BuilderImpl builder) {
        this.status = builder.status;
        this.columnStatisticsTaskRunId = builder.columnStatisticsTaskRunId;
        this.executionTimestamp = builder.executionTimestamp;
        this.errorMessage = builder.errorMessage;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String columnStatisticsTaskRunId() {
        return this.columnStatisticsTaskRunId;
    }

    public final Instant executionTimestamp() {
        return this.executionTimestamp;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnStatisticsTaskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionAttempt)) {
            return false;
        }
        ExecutionAttempt other = (ExecutionAttempt)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.columnStatisticsTaskRunId(), other.columnStatisticsTaskRunId()) && Objects.equals(this.executionTimestamp(), other.executionTimestamp()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionAttempt").add("Status", (Object)this.statusAsString()).add("ColumnStatisticsTaskRunId", (Object)this.columnStatisticsTaskRunId()).add("ExecutionTimestamp", (Object)this.executionTimestamp()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ColumnStatisticsTaskRunId": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsTaskRunId()));
            }
            case "ExecutionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.executionTimestamp()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("ColumnStatisticsTaskRunId", COLUMN_STATISTICS_TASK_RUN_ID_FIELD);
        map.put("ExecutionTimestamp", EXECUTION_TIMESTAMP_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionAttempt, T> g) {
        return obj -> g.apply((ExecutionAttempt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String columnStatisticsTaskRunId;
        private Instant executionTimestamp;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionAttempt model) {
            this.status(model.status);
            this.columnStatisticsTaskRunId(model.columnStatisticsTaskRunId);
            this.executionTimestamp(model.executionTimestamp);
            this.errorMessage(model.errorMessage);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getColumnStatisticsTaskRunId() {
            return this.columnStatisticsTaskRunId;
        }

        public final void setColumnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
        }

        @Override
        public final Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
            return this;
        }

        public final Instant getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        public final void setExecutionTimestamp(Instant executionTimestamp) {
            this.executionTimestamp = executionTimestamp;
        }

        @Override
        public final Builder executionTimestamp(Instant executionTimestamp) {
            this.executionTimestamp = executionTimestamp;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ExecutionAttempt build() {
            return new ExecutionAttempt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionAttempt> {
        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder columnStatisticsTaskRunId(String var1);

        public Builder executionTimestamp(Instant var1);

        public Builder errorMessage(String var1);
    }
}

