/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalOptionKeys;
import software.amazon.awssdk.services.glue.model.DQAdditionalOptionsCopier;
import software.amazon.awssdk.services.glue.model.DQDLAliasesCopier;
import software.amazon.awssdk.services.glue.model.DQResultsPublishingOptions;
import software.amazon.awssdk.services.glue.model.DQStopJobOnFailureOptions;
import software.amazon.awssdk.services.glue.model.ManyInputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateDataQualityMultiFrame
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluateDataQualityMultiFrame> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::name)).setter(EvaluateDataQualityMultiFrame.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::inputs)).setter(EvaluateDataQualityMultiFrame.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalDataSources").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::additionalDataSources)).setter(EvaluateDataQualityMultiFrame.setter(Builder::additionalDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDataSources").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RULESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ruleset").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::ruleset)).setter(EvaluateDataQualityMultiFrame.setter(Builder::ruleset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()}).build();
    private static final SdkField<DQResultsPublishingOptions> PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublishingOptions").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::publishingOptions)).setter(EvaluateDataQualityMultiFrame.setter(Builder::publishingOptions)).constructor(DQResultsPublishingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishingOptions").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalOptions").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::additionalOptionsAsStrings)).setter(EvaluateDataQualityMultiFrame.setter(Builder::additionalOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DQStopJobOnFailureOptions> STOP_JOB_ON_FAILURE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StopJobOnFailureOptions").getter(EvaluateDataQualityMultiFrame.getter(EvaluateDataQualityMultiFrame::stopJobOnFailureOptions)).setter(EvaluateDataQualityMultiFrame.setter(Builder::stopJobOnFailureOptions)).constructor(DQStopJobOnFailureOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopJobOnFailureOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, ADDITIONAL_DATA_SOURCES_FIELD, RULESET_FIELD, PUBLISHING_OPTIONS_FIELD, ADDITIONAL_OPTIONS_FIELD, STOP_JOB_ON_FAILURE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateDataQualityMultiFrame.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final Map<String, String> additionalDataSources;
    private final String ruleset;
    private final DQResultsPublishingOptions publishingOptions;
    private final Map<String, String> additionalOptions;
    private final DQStopJobOnFailureOptions stopJobOnFailureOptions;

    private EvaluateDataQualityMultiFrame(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.additionalDataSources = builder.additionalDataSources;
        this.ruleset = builder.ruleset;
        this.publishingOptions = builder.publishingOptions;
        this.additionalOptions = builder.additionalOptions;
        this.stopJobOnFailureOptions = builder.stopJobOnFailureOptions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final boolean hasAdditionalDataSources() {
        return this.additionalDataSources != null && !(this.additionalDataSources instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalDataSources() {
        return this.additionalDataSources;
    }

    public final String ruleset() {
        return this.ruleset;
    }

    public final DQResultsPublishingOptions publishingOptions() {
        return this.publishingOptions;
    }

    public final Map<AdditionalOptionKeys, String> additionalOptions() {
        return DQAdditionalOptionsCopier.copyStringToEnum(this.additionalOptions);
    }

    public final boolean hasAdditionalOptions() {
        return this.additionalOptions != null && !(this.additionalOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalOptionsAsStrings() {
        return this.additionalOptions;
    }

    public final DQStopJobOnFailureOptions stopJobOnFailureOptions() {
        return this.stopJobOnFailureOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDataSources() ? this.additionalDataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalOptions() ? this.additionalOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stopJobOnFailureOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataQualityMultiFrame)) {
            return false;
        }
        EvaluateDataQualityMultiFrame other = (EvaluateDataQualityMultiFrame)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasAdditionalDataSources() == other.hasAdditionalDataSources() && Objects.equals(this.additionalDataSources(), other.additionalDataSources()) && Objects.equals(this.ruleset(), other.ruleset()) && Objects.equals(this.publishingOptions(), other.publishingOptions()) && this.hasAdditionalOptions() == other.hasAdditionalOptions() && Objects.equals(this.additionalOptionsAsStrings(), other.additionalOptionsAsStrings()) && Objects.equals(this.stopJobOnFailureOptions(), other.stopJobOnFailureOptions());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateDataQualityMultiFrame").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("AdditionalDataSources", this.hasAdditionalDataSources() ? this.additionalDataSources() : null).add("Ruleset", (Object)this.ruleset()).add("PublishingOptions", (Object)this.publishingOptions()).add("AdditionalOptions", this.hasAdditionalOptions() ? this.additionalOptionsAsStrings() : null).add("StopJobOnFailureOptions", (Object)this.stopJobOnFailureOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "AdditionalDataSources": {
                return Optional.ofNullable(clazz.cast(this.additionalDataSources()));
            }
            case "Ruleset": {
                return Optional.ofNullable(clazz.cast(this.ruleset()));
            }
            case "PublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.publishingOptions()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptionsAsStrings()));
            }
            case "StopJobOnFailureOptions": {
                return Optional.ofNullable(clazz.cast(this.stopJobOnFailureOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("AdditionalDataSources", ADDITIONAL_DATA_SOURCES_FIELD);
        map.put("Ruleset", RULESET_FIELD);
        map.put("PublishingOptions", PUBLISHING_OPTIONS_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("StopJobOnFailureOptions", STOP_JOB_ON_FAILURE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataQualityMultiFrame, T> g) {
        return obj -> g.apply((EvaluateDataQualityMultiFrame)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> additionalDataSources = DefaultSdkAutoConstructMap.getInstance();
        private String ruleset;
        private DQResultsPublishingOptions publishingOptions;
        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();
        private DQStopJobOnFailureOptions stopJobOnFailureOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataQualityMultiFrame model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.additionalDataSources(model.additionalDataSources);
            this.ruleset(model.ruleset);
            this.publishingOptions(model.publishingOptions);
            this.additionalOptionsWithStrings(model.additionalOptions);
            this.stopJobOnFailureOptions(model.stopJobOnFailureOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final Map<String, String> getAdditionalDataSources() {
            if (this.additionalDataSources instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalDataSources;
        }

        public final void setAdditionalDataSources(Map<String, String> additionalDataSources) {
            this.additionalDataSources = DQDLAliasesCopier.copy(additionalDataSources);
        }

        @Override
        public final Builder additionalDataSources(Map<String, String> additionalDataSources) {
            this.additionalDataSources = DQDLAliasesCopier.copy(additionalDataSources);
            return this;
        }

        public final String getRuleset() {
            return this.ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final DQResultsPublishingOptions.Builder getPublishingOptions() {
            return this.publishingOptions != null ? this.publishingOptions.toBuilder() : null;
        }

        public final void setPublishingOptions(DQResultsPublishingOptions.BuilderImpl publishingOptions) {
            this.publishingOptions = publishingOptions != null ? publishingOptions.build() : null;
        }

        @Override
        public final Builder publishingOptions(DQResultsPublishingOptions publishingOptions) {
            this.publishingOptions = publishingOptions;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (this.additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = DQAdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptionsWithStrings(Map<String, String> additionalOptions) {
            this.additionalOptions = DQAdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        @Override
        public final Builder additionalOptions(Map<AdditionalOptionKeys, String> additionalOptions) {
            this.additionalOptions = DQAdditionalOptionsCopier.copyEnumToString(additionalOptions);
            return this;
        }

        public final DQStopJobOnFailureOptions.Builder getStopJobOnFailureOptions() {
            return this.stopJobOnFailureOptions != null ? this.stopJobOnFailureOptions.toBuilder() : null;
        }

        public final void setStopJobOnFailureOptions(DQStopJobOnFailureOptions.BuilderImpl stopJobOnFailureOptions) {
            this.stopJobOnFailureOptions = stopJobOnFailureOptions != null ? stopJobOnFailureOptions.build() : null;
        }

        @Override
        public final Builder stopJobOnFailureOptions(DQStopJobOnFailureOptions stopJobOnFailureOptions) {
            this.stopJobOnFailureOptions = stopJobOnFailureOptions;
            return this;
        }

        public EvaluateDataQualityMultiFrame build() {
            return new EvaluateDataQualityMultiFrame(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluateDataQualityMultiFrame> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder additionalDataSources(Map<String, String> var1);

        public Builder ruleset(String var1);

        public Builder publishingOptions(DQResultsPublishingOptions var1);

        default public Builder publishingOptions(Consumer<DQResultsPublishingOptions.Builder> publishingOptions) {
            return this.publishingOptions((DQResultsPublishingOptions)((DQResultsPublishingOptions.Builder)DQResultsPublishingOptions.builder().applyMutation(publishingOptions)).build());
        }

        public Builder additionalOptionsWithStrings(Map<String, String> var1);

        public Builder additionalOptions(Map<AdditionalOptionKeys, String> var1);

        public Builder stopJobOnFailureOptions(DQStopJobOnFailureOptions var1);

        default public Builder stopJobOnFailureOptions(Consumer<DQStopJobOnFailureOptions.Builder> stopJobOnFailureOptions) {
            return this.stopJobOnFailureOptions((DQStopJobOnFailureOptions)((DQStopJobOnFailureOptions.Builder)DQStopJobOnFailureOptions.builder().applyMutation(stopJobOnFailureOptions)).build());
        }
    }
}

