/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionType {
    JDBC("JDBC"),
    SFTP("SFTP"),
    MONGODB("MONGODB"),
    KAFKA("KAFKA"),
    NETWORK("NETWORK"),
    MARKETPLACE("MARKETPLACE"),
    CUSTOM("CUSTOM"),
    SALESFORCE("SALESFORCE"),
    VIEW_VALIDATION_REDSHIFT("VIEW_VALIDATION_REDSHIFT"),
    VIEW_VALIDATION_ATHENA("VIEW_VALIDATION_ATHENA"),
    GOOGLEADS("GOOGLEADS"),
    GOOGLESHEETS("GOOGLESHEETS"),
    GOOGLEANALYTICS4("GOOGLEANALYTICS4"),
    SERVICENOW("SERVICENOW"),
    MARKETO("MARKETO"),
    SAPODATA("SAPODATA"),
    ZENDESK("ZENDESK"),
    JIRACLOUD("JIRACLOUD"),
    NETSUITEERP("NETSUITEERP"),
    HUBSPOT("HUBSPOT"),
    FACEBOOKADS("FACEBOOKADS"),
    INSTAGRAMADS("INSTAGRAMADS"),
    ZOHOCRM("ZOHOCRM"),
    SALESFORCEPARDOT("SALESFORCEPARDOT"),
    SALESFORCEMARKETINGCLOUD("SALESFORCEMARKETINGCLOUD"),
    SLACK("SLACK"),
    STRIPE("STRIPE"),
    INTERCOM("INTERCOM"),
    SNAPCHATADS("SNAPCHATADS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionType> VALUE_MAP;
    private final String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionType> knownValues() {
        EnumSet<ConnectionType> knownValues = EnumSet.allOf(ConnectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionType.class, ConnectionType::toString);
    }
}

